#include <windows/wday.h>
#include <windows/callbacks.h>
#include <windows/wevent.h>
#include <time.h>
#include <sys/time.h>

#define BUF 50
#define NAME_WDAY "day"

#define FG_R 20000
#define FG_G 50000
#define FG_B 60000

#define BG_R 20000
#define BG_G 20000
#define BG_B 20000

#ifndef PIXMAP_PATH
#define PIXMAP_PATH "data/pixmaps"
#endif

#define BELL_PIXMAP PIXMAP_PATH"/40x40/bell.png"

/**
 * today:
 * @year: 
 * @month: 
 * @day:
 *
 * compares the passed date with the current
 *
 * Return value: %TRUE or %FALSE
 **/
static gboolean today(int year, int month, int day)
{
    struct timeval t;
    struct tm* date;

	/* get date today and write in buf */
	gettimeofday(&t, NULL);
	date = localtime((time_t *) (&(t.tv_sec)));

    if(day == date->tm_mday && month == date->tm_mon && (date->tm_year + 1900) == year) {
        return TRUE;
    } else {
        return FALSE;
    }
}

/**
 * wday_set_title:
 * @win: window
 * @data: context
 *
 * to install the date in the title bar
 **/
static void wday_set_title(GtkWidget* win, AppData* data)
{
    int year; 
    int month;
    int day;
    struct tm date;
    char buf_date[BUF];

    gtk_kimi_calendar_get_date(data->calendar, &year, &month, &day);

    date.tm_sec = 0;             /* seconds */
    date.tm_min = 0;             /* minutes */
    date.tm_hour = 0;            /* hours */
    date.tm_mday = day;          /* day of the month */
    date.tm_mon = month;         /* month */
    date.tm_year = year - 1900;  /* year */

    if(today(year, month, day)) {
        strftime(buf_date, sizeof buf_date, _("%d.%m.%Y (today)"), &date);
    } else {
        strftime(buf_date, sizeof buf_date, "%d.%m.%Y", &date);
    }

    gtk_window_set_title(GTK_WINDOW(win), buf_date);
}

/**
 * create_view:
 *
 * create view
 *
 * Return value: %GtkWidget, view
 **/
static GtkWidget* create_view(void)
{
    GtkCellRenderer* renderer;
    GtkWidget* view;

    view = hildon_gtk_tree_view_new(HILDON_UI_MODE_EDIT);

    renderer = gtk_cell_renderer_text_new();
 
    GdkColor fg, bg;
  
    fg.red   = FG_R;
    fg.green = FG_G;
    fg.blue  = FG_B;
			  
    bg.red   = BG_R;
    bg.green = BG_G;
    bg.blue  = BG_B;
     
    g_object_set (G_OBJECT (renderer), "xalign", 0.5, NULL);
    g_object_set (G_OBJECT (renderer), "foreground-gdk", &fg, NULL);
    g_object_set (G_OBJECT (renderer), "background-gdk", &bg, NULL);
    
    gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),
		                                        -1,
					                            _("Time"),
                                                renderer,			
                                                "text", 
						                        0, 
						                        NULL);
    
    renderer = gtk_cell_renderer_pixbuf_new();
    gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),
		   				                        -1,
						                        NULL,
					       	                    renderer,
						                        "pixbuf",
					       	                    1,
						                        NULL);
    
    renderer = gtk_cell_renderer_text_new();
    gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),
                                                -1,
                                                _("Event name"),
                                                renderer,
                                                "text",
                                                2,
                                                NULL);
                                                                                                                                                                                                            
    renderer = gtk_cell_renderer_pixbuf_new();
    g_object_set (G_OBJECT (renderer), "xalign", 1.0, NULL);
    gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),
			                                    -1,
						                        NULL,
						                        renderer,
						                        "pixbuf",
						                        3,
						                        NULL);
   
    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(view), TRUE);
					    
    return view;
}

/**
 * create_model:
 *
 * creates a model for viewing
 *
 * Return value: %GtkWidget, model
 **/
static GtkTreeModel* create_model(AppData* data)
{
    GtkTreeStore* store;
    GtkTreeIter iter;
    struct tm start_time;
    struct tm end_time;
    char start_time_buf[BUF];
    char end_time_buf[BUF];
    gchar* time;
    gchar* title;
    int day;
    int month;
    int year;
    struct tm date;
    GdkPixbuf* bell = NULL;
    GdkPixbuf* pix_service = NULL;

    GdkPixbuf* pix_bell = gdk_pixbuf_new_from_file(BELL_PIXMAP, NULL);

    gtk_kimi_calendar_get_date(data->calendar,
		                       &year,
			                   &month,
			                   &day);
    
    store = gtk_tree_store_new(5,
                               G_TYPE_STRING,
		             	       GDK_TYPE_PIXBUF,
			                   G_TYPE_STRING,
			                   GDK_TYPE_PIXBUF,
                               G_TYPE_INT);

    GArray* del = data->kimi->date_event_list;
    int i, j;
    for (i = 0; i < del->len; i++) {
        DateEventList dl = g_array_index(del, DateEventList, i);

        date = *localtime(&dl.date);

        if (day == date.tm_mday) {
            GPtrArray* evs = dl.events;
            for (j = 0; j < evs->len; j++) {
                Event* ev = g_ptr_array_index(evs, j);

                start_time = *localtime(&ev->start_time);
                end_time = *localtime(&ev->end_time);

                strftime(start_time_buf, sizeof(start_time_buf), "%H:%M", &start_time);
                strftime(end_time_buf, sizeof(end_time_buf), "%H:%M", &end_time);
                
                /* if type != memo */
                if(ev->id_type != 1) {
                    time = g_strconcat(start_time_buf, "\n", end_time_buf, NULL);
                } else {
                    time = g_strconcat(start_time_buf, "", NULL);
                }

                title = g_strconcat(ev->title, "\n", ev->location, NULL);

                if (ev->remind == -1) {
                    bell = NULL;
                } else {
                    bell = pix_bell;
                }
                 
                GPtrArray* modules = kimi_get_modules(data->kimi);
                Module* module;
                for (i = 0; i < modules->len; i++) {
                    module = g_ptr_array_index(modules, i);
                    if(strcmp(module->service_string, ev->service_event_id) == 0){
                        pix_service = b64_to_pixbuf(module->service_pixmap);
	                    break;
	                }
                }

                gtk_tree_store_append(store, &iter, NULL);
                gtk_tree_store_set(store, &iter, 0, time, 1, bell, 2, title, 3, pix_service, 4, j, -1);

                /* clear */  
                if(pix_service != NULL) {
                    gdk_pixbuf_unref(pix_service);
                }

                g_free(time);
                g_free(title);
            }
            break;
        }
    }
    
    /* free pixbuf */  
    if(pix_bell != NULL) {
        gdk_pixbuf_unref(pix_bell);
    }

    return GTK_TREE_MODEL(store);
}

/**
 * top_win_name:
 *
 * @name: string
 *
 * a window with the name
 *
 * Return value: %TRUE(if the window name == @name) or %FALSE
 **/
static gboolean top_win_name(char* name)
{
    gboolean result;
    GtkWidget* top_win;
    HildonWindowStack* wstack;
    const char* win_name;

    wstack = hildon_window_stack_get_default();
    top_win = hildon_window_stack_peek(wstack); 
    win_name = gtk_widget_get_name(top_win);

    if(strcmp(win_name, name) == 0) {
        result = TRUE;
    } else {
        result = FALSE;
    }

    return result;
}

/**
 * popup_create:
 *
 * @data: context  
 *
 * create menu
 * Return value: GtkWidget menu
 **/
static GtkWidget* popup_create(AppData* data)
{
    GtkWidget* menu;
    GtkWidget* item_edit;
    GtkWidget* item_delete; 

    menu = hildon_gtk_menu_new ();

    /* Create a menu item */
    item_edit = gtk_menu_item_new_with_label ("Edit");
    item_delete = gtk_menu_item_new_with_label ("Delete");

    gtk_menu_shell_append (GTK_MENU_SHELL(menu), item_edit);
    gtk_menu_shell_append (GTK_MENU_SHELL(menu), item_delete);

    
    gtk_widget_show_all (menu);

    /* signals */
    g_signal_connect(G_OBJECT (item_edit), "activate",
                              G_CALLBACK (edit_selected_event),
		                      data);

    g_signal_connect(G_OBJECT (item_delete), "activate",
                              G_CALLBACK (delete_selected_event),
		                      data);
        
    return menu;
}

/**
 * create_menu:
 *
 * @data: context  
 *
 * create menu
 * Return value: GtkWidget menu
 **/
static GtkWidget* create_menu(AppData* data)
{ 
    HildonAppMenu *menu;

    GtkWidget* bt_prev_day;
    GtkWidget* bt_next_day;
    GtkWidget* bt_goto_today;
    GtkWidget* bt_goto;
    GtkWidget* bt_create_event;
    GtkWidget* bt_edit_event;
    GtkWidget* bt_delete_event;

    menu = HILDON_APP_MENU(hildon_app_menu_new());

    /* button "previous day" */
    GtkWidget* prev_image;
    bt_prev_day = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_text(HILDON_BUTTON(bt_prev_day), "Previous day", "");
    prev_image = gtk_image_new_from_stock(GTK_STOCK_GO_BACK, GTK_ICON_SIZE_BUTTON);
    hildon_button_set_image(HILDON_BUTTON(bt_prev_day), prev_image);
    hildon_button_set_image_position(HILDON_BUTTON(bt_prev_day), GTK_POS_LEFT);
    gtk_button_set_alignment(GTK_BUTTON(bt_prev_day), 0.0, 0.5);
    //gtk_button_set_label (GTK_BUTTON(bt_prev_day), "previous day");
    hildon_app_menu_append(menu, GTK_BUTTON(bt_prev_day));

    /* button "next day" */
    GtkWidget* next_image;
    bt_next_day = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_text(HILDON_BUTTON(bt_next_day), "Next day", "");
    next_image = gtk_image_new_from_stock(GTK_STOCK_GO_FORWARD, GTK_ICON_SIZE_BUTTON);
    hildon_button_set_image(HILDON_BUTTON(bt_next_day), next_image);
    hildon_button_set_image_position(HILDON_BUTTON(bt_next_day), GTK_POS_LEFT);
    gtk_button_set_alignment(GTK_BUTTON(bt_next_day), 0.0, 0.5);
    hildon_app_menu_append(menu, GTK_BUTTON(bt_next_day));

    /* button "go to today" */
    GtkWidget* today_image;
    bt_goto_today = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_text(HILDON_BUTTON(bt_goto_today), "Go to today", "");
    today_image = gtk_image_new_from_stock(GTK_STOCK_HOME, GTK_ICON_SIZE_BUTTON);
    hildon_button_set_image(HILDON_BUTTON(bt_goto_today), today_image);
    hildon_button_set_image_position(HILDON_BUTTON(bt_goto_today), GTK_POS_LEFT);
    gtk_button_set_alignment(GTK_BUTTON(bt_goto_today), 0.0, 0.5);
    hildon_app_menu_append(menu, GTK_BUTTON(bt_goto_today));

    /* button "go to" */
    GtkWidget* goto_image;
    bt_goto = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_text(HILDON_BUTTON(bt_goto), "Go to", "");
    goto_image = gtk_image_new_from_stock(GTK_STOCK_JUMP_TO, GTK_ICON_SIZE_BUTTON);
    hildon_button_set_image(HILDON_BUTTON(bt_goto), goto_image);
    hildon_button_set_image_position(HILDON_BUTTON(bt_goto), GTK_POS_LEFT);
    gtk_button_set_alignment(GTK_BUTTON(bt_goto), 0.0, 0.5);
    hildon_app_menu_append(menu, GTK_BUTTON(bt_goto));

    /* button "edit event" */
    GtkWidget* edit_image;
    bt_edit_event = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_text(HILDON_BUTTON(bt_edit_event), "Edit event", "");
    edit_image = gtk_image_new_from_stock(GTK_STOCK_EDIT, GTK_ICON_SIZE_BUTTON);
    hildon_button_set_image(HILDON_BUTTON(bt_edit_event), edit_image);
    hildon_button_set_image_position(HILDON_BUTTON(bt_edit_event), GTK_POS_LEFT);
    gtk_button_set_alignment(GTK_BUTTON(bt_edit_event), 0.0, 0.5);
    hildon_app_menu_append(menu, GTK_BUTTON(bt_edit_event));

    /* button "delete event" */
    GtkWidget* delete_image;
    bt_delete_event = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_text(HILDON_BUTTON(bt_delete_event), "Delete event", "");
    delete_image = gtk_image_new_from_stock(GTK_STOCK_DELETE, GTK_ICON_SIZE_BUTTON);
    hildon_button_set_image(HILDON_BUTTON(bt_delete_event), delete_image);
    hildon_button_set_image_position(HILDON_BUTTON(bt_delete_event), GTK_POS_LEFT);
    gtk_button_set_alignment(GTK_BUTTON(bt_delete_event), 0.0, 0.5);
    hildon_app_menu_append(menu, GTK_BUTTON(bt_delete_event));

    /* button "create new event" */
    GtkWidget* new_image;
    bt_create_event = hildon_button_new(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
    hildon_button_set_text(HILDON_BUTTON(bt_create_event), "New event", "");
    new_image = gtk_image_new_from_stock(GTK_STOCK_NEW, GTK_ICON_SIZE_BUTTON);
    hildon_button_set_image (HILDON_BUTTON (bt_create_event), new_image);
    hildon_button_set_image_position (HILDON_BUTTON(bt_create_event), GTK_POS_LEFT);
    gtk_button_set_alignment(GTK_BUTTON(bt_create_event), 0.0, 0.5);
    hildon_app_menu_append(menu, GTK_BUTTON(bt_create_event));
    
    /* signals */
    g_signal_connect_after(bt_create_event, "clicked", G_CALLBACK(create_new_event), data);
    g_signal_connect_after(bt_prev_day, "clicked", G_CALLBACK(previous_day), data);
    g_signal_connect_after(bt_next_day, "clicked", G_CALLBACK(next_day), data);
    g_signal_connect_after(bt_goto_today, "clicked", G_CALLBACK(goto_today_day), data);
    g_signal_connect_after(bt_goto, "clicked", G_CALLBACK(goto_day), data);
    g_signal_connect_after(bt_edit_event, "clicked", G_CALLBACK(edit_selected_event), data);
    g_signal_connect_after(bt_delete_event, "clicked", G_CALLBACK(delete_selected_event), data);
    
    gtk_widget_show_all(GTK_WIDGET(menu));

    return GTK_WIDGET(menu);
}

/**
 * init_wday:
 *
 * @w: caller widget
 * @data: context  
 *
 * creates a window of the day
 **/
void init_wday(GtkWidget* w, AppData* data)
{
    GtkWidget* win;
    GtkBox* vbox;
    GtkWidget* menu;

    GtkWidget* popup_menu;

    GtkWidget* panarea;

    GtkTreeModel* model;

    /* window is already created */
    if(top_win_name(NAME_WDAY)) {
        return;
    }

    win = hildon_stackable_window_new();
    gtk_widget_set_name(GTK_WIDGET(win), NAME_WDAY);

    vbox = GTK_BOX (gtk_vbox_new (FALSE, 10));
    panarea = hildon_pannable_area_new ();

    popup_menu = popup_create(data);

    data->day_treeview = create_view();
    model = create_model(data);

    gtk_widget_tap_and_hold_setup(GTK_WIDGET(data->day_treeview), popup_menu, NULL, 0);

    gtk_tree_view_set_model(GTK_TREE_VIEW(data->day_treeview), model);
    g_object_unref(model);
 
    gtk_container_add (GTK_CONTAINER (panarea), data->day_treeview);
    gtk_container_add (GTK_CONTAINER (vbox), panarea);
    gtk_container_add (GTK_CONTAINER (win), GTK_WIDGET (vbox));

    wday_set_title(win, data);

    /* create and attach menu to the window */
    menu = create_menu(data);
    hildon_window_set_app_menu(HILDON_WINDOW(win), menu);

    gtk_widget_show_all(win);    
}

void update_day_view(AppData* data)
{
    GtkTreeModel* model;
    
    model = create_model(data);
    
    gtk_tree_view_set_model (GTK_TREE_VIEW(data->day_treeview), model);
    g_object_unref(model);

    gtk_widget_show_all(GTK_WIDGET(data->day_treeview));
}


    
