/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
#ifndef __GTK_KIMI_CALENDAR_H__
#define __GTK_KIMI_CALENDAR_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <glib.h>
#include <glib/gi18n.h>

#ifdef ENABLE_NLS
#define P_(String) gettext(String)
//#define P_(String) g_dgettext(GETTEXT_PACKAGE "-properties",String)
#else 
#define P_(String) (String)
#endif
/* not really I18N-related, but also a string marker macro */
#define I_(string) g_intern_static_string (string)

#define C_(Context,String) (Context,String)


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_TYPE_KIMI_CALENDAR                  (gtk_kimi_calendar_get_type ())
#define GTK_KIMI_CALENDAR(obj)                  (GTK_CHECK_CAST ((obj), GTK_TYPE_KIMI_CALENDAR, GtkKimiCalendar))
#define GTK_KIMI_CALENDAR_CLASS(klass)          (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_KIMI_CALENDAR, GtkKimiCalendarClass))
#define GTK_IS_KIMI_CALENDAR(obj)               (GTK_CHECK_TYPE ((obj), GTK_TYPE_KIMI_CALENDAR))
#define GTK_IS_KIMI_CALENDAR_CLASS(klass)       (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_KIMI_CALENDAR))
#define GTK_KIMI_CALENDAR_GET_CLASS(obj)        (GTK_CHECK_GET_CLASS ((obj), GTK_TYPE_KIMI_CALENDAR, GtkKimiCalendarClass))

typedef struct _GtkKimiCalendar			GtkKimiCalendar;
typedef struct _GtkKimiCalendarClass		GtkKimiCalendarClass;

typedef enum
{
  GTK_KIMI_CALENDAR_SHOW_HEADING =	1 << 0,
  GTK_KIMI_CALENDAR_SHOW_DAY_NAMES =	1 << 1,
  GTK_KIMI_CALENDAR_NO_MONTH_CHANGE = 	1 << 2,
  GTK_KIMI_CALENDAR_SHOW_WEEK_NUMBERS = 1 << 3,
  GTK_KIMI_CALENDAR_WEEK_START_MONDAY = 1 << 4,
  GTK_KIMI_CALENDAR_SHOW_DETAILS = 	1 << 5
} GtkKimiCalendarDisplayOptions;

struct _GtkKimiCalendar
{
  GtkWidget widget;
  
  GtkStyle  *label_style;
  
  gint month;
  gint year;
  gint selected_day;

  gint day_month[6][7];
  gint day[6][7];
  
  gint num_marked_dates;
  gint marked_date[31];
  GtkKimiCalendarDisplayOptions  display_flags;
  GdkColor marked_date_color[31];
  
  GdkGC *gc;
  GdkGC *xor_gc;

  gint focus_row;
  gint focus_col;

  gint highlight_row;
  gint highlight_col;
  
  gpointer priv;
  gchar grow_space [32];
};

struct _GtkKimiCalendarClass
{
  GtkWidgetClass parent_class;
  
  /* Signal handlers */
  void (* month_changed)		(GtkKimiCalendar *calendar);
  void (* day_selected)			(GtkKimiCalendar *calendar);
  void (* day_selected_double_click)	(GtkKimiCalendar *calendar);
  void (* day_selected_click)	(GtkKimiCalendar *calendar);
  void (* week_selected_click)  (GtkKimiCalendar *calendar);
  void (* prev_month)			(GtkKimiCalendar *calendar);
  void (* next_month)			(GtkKimiCalendar *calendar);
  void (* prev_year)			(GtkKimiCalendar *calendar);
  void (* next_year)			(GtkKimiCalendar *calendar);
};


typedef gchar* (*GtkKimiCalendarDetailFunc) (GtkKimiCalendar *calendar,
                                             guint year,
                                             guint month,
                                             guint day,
                                             gpointer user_data);

/****************************************
 *              Public API              *
 ****************************************/
GtkType gtk_kimi_calendar_get_type		(void);

GtkWidget* gtk_kimi_calendar_new 		(void);

void gtk_kimi_calendar_display_options 		(GtkKimiCalendar *calendar,
			                         GtkKimiCalendarDisplayOptions flags);


gboolean gtk_kimi_calendar_set_background (GtkKimiCalendar *calendar,
				                           gchar* name);

void gtk_kimi_calendar_set_rect_day_transparency (GtkKimiCalendar *calendar,
				                           double transparency);

GtkKimiCalendarDisplayOptions gtk_kimi_calendar_get_display_options (GtkKimiCalendar *calendar);

void gtk_kimi_calendar_set_display_options	(GtkKimiCalendar *calendar,
						 GtkKimiCalendarDisplayOptions flags);

gboolean gtk_kimi_calendar_select_month		(GtkKimiCalendar *calendar,
						 guint month,
						 guint year);

void gtk_kimi_calendar_select_day 		(GtkKimiCalendar *calendar,
						 guint day);

void gtk_kimi_calendar_clear_marks 		(GtkKimiCalendar *calendar);

gboolean gtk_kimi_calendar_mark_day		(GtkKimiCalendar *calendar,
			                         guint day);

gboolean gtk_kimi_calendar_unmark_day		(GtkKimiCalendar *calendar,
						 guint day);

void gtk_kimi_calendar_get_date			(GtkKimiCalendar *calendar,
						 guint *year,
						 guint *month,
						 guint *day);

void gtk_kimi_calendar_set_detail_func 		(GtkKimiCalendar *calendar,
						 gpointer func,
			                         gpointer data,
			                         GDestroyNotify destroy);

void gtk_kimi_calendar_set_detail_width_chars 	(GtkKimiCalendar *calendar, gint chars);
void gtk_kimi_calendar_set_detail_height_rows 	(GtkKimiCalendar *calendar, gint rows);

gint gtk_kimi_calendar_get_detail_width_chars 	(GtkKimiCalendar *calendar);
gint gtk_kimi_calendar_get_detail_height_rows 	(GtkKimiCalendar *calendar);

void	   gtk_kimi_calendar_freeze		(GtkKimiCalendar *calendar);
void	   gtk_kimi_calendar_thaw		(GtkKimiCalendar *calendar);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GTK_KIMI_CALENDAR_H__ */

