#!/bin/sh

# If there's a Makefile, then run the 'distclean' target first
if test -f Makefile; then
make distclean
fi

# Remove all tar-files (assuming there are some packages).
rm -f *.tar.* *.tgz *~

# Also remove the autotools cache directory.
rm -Rf autom4te.cache

# Remove rest of the generated files.
rm -f Makefile.in aclocal.m4 configure depcomp compile install-sh missing

rm -f build-stamp config.* intltool-* ltmain.sh mkinstalldirs

# Remove some Makefile.in
rm -f libkimi/Makefile.in libkimi/src/Makefile.in.in src/Makefile.in kimi-console/Makefile.in

