/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
#define CTF_LOG_FORMAT_USE_TIME
#define CTF_THROW_EXIT

#include "events/events.h"
#include "../CTF/src/ctf.h"
#include <ui/callbacks.h>
#include <settings/settings.h>
#include <appdata.h>
#include <time.h>

#define BUF_SIZE 2048

GLOBAL_DECL();
CTF_TEST_DATA_FILE_NAME_DECL;
CTF_STAT_FILE_NAME_DECL;

CTF_TEST_CASE(remote_storage_test) {
    CTF_TEST_NAME("google_module_test");

    AppData   *data;
    event *events = NULL;
    data = create_data();
    conf_init(data);

    int resp;
    char* auth = google_authentification(&resp, data, NULL);
    CTF_CHECK(!strcmp(auth, "Auth=test"));
    free(auth);


    auth = google_authentification(&resp, data, NULL);
    
    CTF_CHECK(!auth);

    events = google_events_download(data,NULL);

    CTF_CHECK(events != NULL);

    events = google_events_download(data,NULL);

    CTF_CHECK(!events);

    events = google_events_download(data,NULL);

    CTF_CHECK(!events);

    destroy_data(data);
}



