/*
 * Copyright (C) 2008-2010 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
#ifndef GOOGLE_H
#define GOOGLE_H

#include <stdio.h>
#include <string.h>
#include <string.h>
#include <curl_request.h>
#include <json-c/json.h>
#include <time.h>
#include <kimi.h>

#ifdef MAEMO5_ENABLED

#include <libosso.h>
#include <conic.h>

#endif /* MAEMO5_ENABLED */

#define MOD_ID "Google"
#define SOURCE  "kimi-Kimi-0.1"
#define SERVICE "cl"
#define GOOGLE_SERVICE_STR "Google Calendar"

#define OSSO_GOOGLE_SERVICE "ru.karelia.cs.kimi.modules.google"

#define GOOGLE_MODULE_ICON "iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAYAAACM/rhtAAAAAXNSR0IArs4c6QAAAAZiS0dEAP8A\
/wD/oL2nkwAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9oCBQkzIYW8eFoAAAsvSURBVFjD\
tZhrjJznVcd/z+W9zezcd9frS7Lx3W3WcSuUOkkt0USEotIvfKIoCkayCJhK8AUUhEQEQkLlAxWi\
SFQhKY4gUr5ULWqjIK1oqwaCGqtgJ3FTx/Z6vdu92Hvx3mZmZ973fQ4f3pnZq50gJc/o1czuPO+8\
/3PO//zPOY9i0zp79iwXLlxAKQXA9evXR4yxEZ/gSpJk+ejRIx8ATE39gv37D2z5XnU/vPfee4yM\
jHDp0jthX1/u674fnNdao7XetOtjXgJpmuKcw7n0zxqN5t88/PCn3djYTQ4dOrgB8OLFizz66KNc\
vfrBY77vv9HfXytHUShamy1GfIJeZHV1jZWVlcl2u/3I8ePHlnoePHv2LK+88gqXL7/zQKVSmRga\
GsJag4ggIpmhnfePc3Vp1H3XWrGyssbdu3dX4zge6u/vb1QqZczly5d57bXXzKFDh16v1WoPBIEv\
IqJEshCgAKU+0qWVAq1QqnNxn/3dKEt2Afi+L2maBnEcL+/bt/etc+fOZeF7441/L588eXJ63769\
oXNOSQ/d1jfFps9KoRWsNByLqwmr9ZhmK6Edp4gTtNF4niH0LbnAUMgbqgWDbxWpYwPVhktRSiEi\
TE/PrA4PP1gEsAB9fX1H8vlcJCK4TaHdnk2CQqks5AsrKe9PtFhabiJJA6sTSnlL4GsShLW1lEZL\
IdpH6QClPRInDJY0pw6F5CLdA9R1pc4MF2tt4Sc/eXv/6dOfm7IAnmcHrbXZZhEU0vPcpoRDK5hb\
cXwwlTB7exGdLHPySIVc4GONj3Muc4xk/k4SR2N9nem7dSbmDX4QcWvdMj5TpxgmnH64xGA1hzgB\
ld2msoWIFIEMYJqm0g2gc7JNgDbW9TsJ74+3WLg9yd5Sm1MjAzSbDeKWRjyL9Tw8Y9Ba40SwaYqx\
CUfCFtVci0vjbdouQKTNyvwit6fH+c0vf5ZcFIDboKZS4JxTvRBLtjKnqQyg2uRBrRUXx2Mmp9vc\
uvYejxz02L+nj+WlVfJ9efr6+gjCEGttlihd6oqQOke73cYP6pyJVvnRu3WWFucIWOLJzx+nWV8l\
8AzdCMo2evYAdnkgLvOeoHrWXByPuXqrzfTYzxgu1xmq7UGcUKlVKBaL+L7fk4seZ0WgI/TWWgLf\
J5+LKFy7yao0+OyJAZrNJnEcIyJZ5FQXneDcbgC7tmfmoxTcXhZuzKRM3ZpkafYqZ44fJkmEob1V\
ypVKZjk7KLtFSgCMsWgvYu9gmVMHA9bW6pRKJYrFIsaYnk70lKIDqQuw95AONhQKreG/r7WYna0z\
ceMKj50oYIyhUq1QKpWwxnSS6qOtwNP80qcHmJ+bJ4wiqtUqYRSBKLoIZJthFiCOkyRNHM5ldVEp\
BQquTCesNYTJWxOs1+d4cN+nyOXzlMsljOfhsrT76NVDQGtDuVLBGIPv+1nAVCZt4gSXpqQpgNsA\
mD1DiOOE5vp6p3gYLt1MmZ5pMT83zUCfAjSlYokgCLMk+qjgNpPeaGwUdZJBSNOUOE5wzgGCzue3\
3GC3i7HqSHI7SRmbavHjt6e59OZFfuURR70xjPFsJuZp3Ctlajvvujm3iU/bL+cEEbexXQmI2kEX\
u7PcgEKzuOZYqwt3l1YREvJRgB8EeJ5Hmib8//oH6WV5lp3SsUV1qpMD0YjaSRm746dEYS2M305o\
NoVGvQGiCcKAXBThed4uSaruTzzJYiMiO+7L0kOhevvu5cGORVpnjcDUfMLsYkyrHaOMwYnG8320\
1h1vKDbzd1eQIoDOniuC0t3aqxERtBakC0rUrpTWO6VLYbRi6k6LG1NNUgfahtTXpVclsizf3O2o\
nVcvhBu/3TWs23F1wSk2wN2Tg2obz0NfWFpLcMpH6Yg7yw1S53oJoNGI7tWbXbynOuYLSlSnMgla\
K3rqpCTjXqe5UJvra+c39U4mKZzAyEGfJBW08VFejpuzCZK0SNJ0owvOGqSOI7e9lGSe6XhzpwcV\
Gr3p/2wrlzsAqp4VqVOMPBRhtQNl0V6emSXDzclFkjjubXe4HiC1y8uJQynwDLiOtKTOkaZC6iCV\
7M5mK9kErhv/XWUmw6wU5ALNYAlm5i3K6yPKV/nH74zx+OmTFIrFjZZ+N1GRTFbq644fv9PgH747\
x+zCOtVyjpHDRcJQ8fPxFv/zzjisXeU7X/9VPnNiAKV2TpB2u1J0EyXwDacOKqbvCNpE2LDEtek5\
fnZ9lifKVbxdOpjNA1ErTvj2j+YohI6vfrGNci3yQYu3bxmmlnLM3Z7Grl7ia189TjW3Tr3eoK9Q\
2NS9c28OokArzR/9RpFmM0ZpD+0VcF6Zv/3Xq6RxY7f+ZYu6BJ7ld35tgCdPBRza4yh5dXS8wOJS\
nXfG1rgzPU68NsmdqVvMz89nXt+S99sAbs5ilUkV+wcL/N6XAkQSlLYYv8jlceGv/ukSrVb7PiNp\
9r92IqAMhUKRB4Yf5Oix4xwZrlIpBj1PO3Hkc3lyudxuPtv2V5ecKtMmY31++4sD5GwLJylKewRR\
mdd+eJd/+f4HBFa2Dj7bZl5rLaVSib1793LgwAH27z9AsRASBQrdSQarDX7QKQA9/bwXQEBp1StA\
WmsG+it864/3EOo1JF0HNNbL8xf/PMlfX3ifOEnQu4DsAtVaYzpzitIKlO4EcmMg1p2Rkw+rJF09\
67JUKUUQhjz00AP83flBaC+RthZJ03Vykcc3/+02v/wHP2V8po5ndXb3PbqILsfqrZSp2QXaazOk\
rcXO87bJvdoBUPW8q1A7jiaKhQInP3WEC88P8/jRFuvL07RXZ5DWAnOLK3z+9/+X3/rLn/Pq6CLX\
p9oIkAsNhciQjwzGKKYXHd/+rwbf/Y8pxq78J8szlzDJCtZsTbdeLugtHXXcTlPX0zbX6dN6WmQt\
1VqVoyeO84df8fny5yZ46ftTjM3cRkyIZ/p46+1Z3vppnoQcTvmUCwH5nCVOhGYzxtMxsj5DUU3z\
66dijn3pM9TKOYrF0kaNz5oJERGVxu24B3Bi4tbkyMhIq1joC7TRSCq985VsGBc8z6O/1k/gBxRL\
Jf58qMbEL+4wc2eF2cVVZu/epd7SOHzCKKJSynNgT5HhfUUGKiGR75MPh1FuiIX5RVqtmDAMqA0M\
9ITfdE7T0iThC09+4dqRI4exZ86cYWpqanltbe1auVwe8X1PRERtb+lFBGMMpVKJMAyp1WoMDi1w\
d2GB1dVVWq0mLk3RWuF5Hp4XYK1B6zbKJGhtSBON53kcGB4mn8+kJZ/PE4UhxmSz8fLyCvV6/VsA\
UZTDTExMcPjw4bRarU5Wq9Wv5PM5ZaztEH53nbPWksvlKJfL1Ppr9PcPUOvvp9pfo1ypUiiVKRZL\
FEslSpUKtVqNgYEB9uzZw9DQEHsGB6lUqxQKBaIwJAgCrOex3lyXpaWl9PLly78bhsHt0dHRLMRB\
EMQvvPDCD/7+G9/4UxG+VqmUiaIQJ4Jx5r7NfF9fX2fGcEjnbEZEei2h0jrjWO9Ibmt7a6wFcbK6\
uqaWl1fiGzdunHv++T+5MjZ2U7Yk9Llz53Sr1ao9/fTTjz/xxJlvep7Xn8/nrDFGdevzh8zm9y19\
O6Ss80W7nUij0Uicc1Ojo6PPXrny7rvr6+vLAC+99NLWp54/f143Go1isVjsP/3YYycKfcUBa7QV\
df/J48PH450jgfTOqF17ZWV55vXXv3clCIIlY2z9zTff5Nq1a7s/86mnnuLYsWPWGBMAfvc47JNY\
HYVwQLvVaq2//PLL7rnnnuPFF1/cfRx75plnePXVVwF49tlniaIIY0xnqP6YD/hFsNYSxzHj4+OM\
jo7uuu//AEnhKT8Dur8aAAAAAElFTkSuQmCC"

/*Some JSON string defines */
#define JSON_FEED "feed"
#define JSON_ENTRY "entry"
#define JSON_ID "id"
#define JSON_LINK "link"
#define JSON_HREF "href"
#define JSON_T "$t"
#define JSON_TITLE "title"
#define JSON_CONTENT "content"
#define JSON_GD_WHEN "gd$when"
#define JSON_GD_WHERE "gd$where"
#define JSON_GD_REMINDER "gd$reminder"
#define JSON_GD_RECURRENCE "gd$recurrence"
#define JSON_START_TIME "startTime"
#define JSON_END_TIME "endTime"
#define JSON_ICAL_RECURR_FORMAT "DTSTART;%*[^:]:%15[0-9T] DTEND;%*[^:]:%15[0-9T]"
#define JSON_GOOGLE_TIME_FORMAT "%FT%T"
#define JSON_GOOGLE_RECURR_TIME_FORMAT "%Y%m%dT%H%M%S"
#define JSON_VALUE_STRING "valueString"
#define JSON_MINUTES "minutes"

/*Data Strings for test framework*/
#ifdef TEST

#define GOOGLE_ANSW_STR_CORRECT "{\"version\":\"1.0\",\"encoding\":\"UTF-8\",\"feed\":{\"entry\":[{\"id\":{\"$t\":\"http://www.google.com/calendar/feeds/default/private/full/j06g1pv9m266uvkpor54lrondg\"},\"title\":{\"$t\":\"test_title\",\"type\":\"text\"},\"content\":{\"$t\":\"test_content\",\"type\":\"text\"},\"gd$where\":[{\"valueString\":\"test_where\"}],\"gd$when\":[{\"endTime\":\"2009-12-19T00:01:00.000+03:00\",\"startTime\":\"2009-12-19T00:00:00.000+03:00\"}]}]}}"

#define GOOGLE_ANSW_STR_INCORRECT "{\"version\":\"1.0\",\"encoding\":\"UTF-8\",\"food\":{\"entry\":[{\"id\":{\"$t\":\"http://www.google.com/calendar/feeds/default/private/full/j06g1pv9266uvkpor54lrondg\"},\"title\":{\"$t\":\"test_title\",\"type\":\"text\"},\"content\":{\"$t\":\"test_content\",\"type\":\"text\"},\"gd$where\":[{\"valueString\":\"test_where\"}],\"gd$when\":[{\"endTime\":\"2009-12-19T00:01:00.000+03:00\",\"startTime\":\"2009-12-19T00:00:00.000+03:00\"}]}]}}"

#endif


/* Some Array size defines */
#define ARRAY_MAX_SIZE 1024
#define TIME_ARRAY_SIZE 200
/* Some Server Answer Defines */
#define SERV_ANSWER_OK 200
#define SERV_ANSWER_CREATED 201
#define SERV_ANSWER_REDIRECT 302
#define SER_ANSWER_UNAUTH 401

/* Event Type */
#define MEMO 0
#define MEETING 1

/* POST message template */
#define POST_MESSAGE_TEMPLATE "<entry xmlns='http://www.w3.org/2005/Atom' xmlns:gd='http://schemas.google.com/g/2005'><category scheme='http://schemas.google.com/g/2005#kind' term='http://schemas.google.com/g/2005#event'></category><title type='text'>%s</title><content type='text'>%s</content><gd:transparency value='http://schemas.google.com/g/2005#event.opaque'></gd:transparency><gd:eventStatus value='http://schemas.google.com/g/2005#event.confirmed'></gd:eventStatus><gd:where valueString='%s'></gd:where><gd:when startTime='%s.000' endTime='%s.000'></gd:when></entry>"

#define PUT_MESSAGE_TEMPLATE 

/* Some URL's defines */
#define AUTH_HEADER "Authorization: GoogleLogin "
#define AUTH_URL "https://www.google.com/accounts/ClientLogin?Email=%s&Passwd=%s&source=%s&service=%s"
#define EVENTS_URL "http://www.google.com/calendar/feeds/default/private/full?alt=json"
#define EVENTS_URL_BY_PER "http://www.google.com/calendar/feeds/default/private/full?alt=json&start-min=%s&start-max=%s&max-results=200000"
#define EVENTS_URL_TIME_FMT "%FT%T"

/* Error messages defines */
#define REM_STRG_ERR g_quark_from_static_string("rem_str_error_quark")
#define ACCOUNT_ERROR_CODE 1
#define ACCOUNT_ERROR "No Account Information in configure file" 
#define AUTH_ERROR "Authorization Error"
#define AUTH_ERROR_CODE 2
#define UPLOAD_ERROR_CODE 3
#define UPLOAD_ERROR "Upload Event Error"
#define DOWNLOAD_ERROR_CODE 4
#define DOWNLOAD_ERROR "Download Events Error"

/*Google Module Data Structure*/

typedef struct _google_module_data {

    int resp_code;
    char* auth_token;
#ifdef MAEMO5_ENABLED
    osso_context_t *osso_context;
    ConIcConnection* connection;
    int connection_status;
#endif MAEMO5_ENABLED
} google_module_data;


/**
 * Authentification with Google
 * @param resp_code Pointer on response code storage
 * @param data Pointer on Application Data structure
 * @return Authentification token
 * */

char* google_authentification(Kimi* data,GError** error);

/**
 * Json Format Parser
 * @param tmp Pointer on events string
 * @return Pointer on events
 * */

GPtrArray* google_json_request_parser(char* tmp);

/**
 * Download events from google
 * @param data Pointer on application data structure
 * @param error Pointer on error handler
 * @return Pointer on events
 * */

GPtrArray* google_get_by_period(time_t start, time_t end, Kimi* data, GError** error);

/**
 * Upload event to google
 * @param data Pointer on application data structure
 * @param error Pointer on error handler
 * @return Pointer on string, what contain a event ID at Google
 * */

int google_event_upload(Event* ev, Kimi* data, GError** error);

void kimi_module_initialize(Kimi* kimi, Module* google_module);

#ifdef MAEMO5_ENABLED
/*Conic connection handler*/
static void connection_handler(ConIcConnection *connection,
                                  ConIcConnectionEvent *event,
                                  gpointer user_data);
/*Connection establish wrapper*/
int connection_wrapper(Kimi* data, GError** error);
#endif /* MAEMO5_ENABLED */

#endif /* GOOGLE_H*/
