#include <stdio.h>
#include "kimi.h"
#include "period.h"
#include <string.h>
#include <stdlib.h>

static int rand_int(int a, int b)
{
    double r = (double)rand() / (double)RAND_MAX;

    return (int)((b - a) * r + a);
}

static int store_event(Event* event, Kimi* app, GError** error)
{
    printf("Emod: store event: %s %s %s\n", event->title, event->description, event->location);
    return 0;
}

static GPtrArray* get_events_by_period(time_t start, time_t end, Kimi* app, GError** error)
{

    Event* ev = kimi_event_new(NULL);
    GPtrArray* arr = g_ptr_array_new();
    g_ptr_array_add(arr, ev);
    
    ev->title = strdup("Example event");
    ev->description = strdup("Example description");
    ev->start_time = rand_int(100000, 2147453648);
    ev->end_time = ev->start_time + 60 * 60;
    
    ev->per = kimi_per_create_period();
    Rule* rul = kimi_per_create_rule_from_ical("FREQ=WEEKLY", 0, 0, 1);
    kimi_per_add_rule(ev->per, rul);

    return arr;
}

void kimi_module_initialize(Module* mod)
{
    mod->service_string = strdup("emod");
    mod->service_name = strdup("Example module");
    mod->store_event = store_event;
    mod->get_events_by_period = get_events_by_period;

    printf("Hello world\n");
}
