#ifndef CB_H
#define CB_H

#define MOD_ID "cbmod"
#define MOD_NAME "Maemo calendar backend module"

extern "C"
{
#include "kimi.h"
#include <glib.h>
}
class CCalendar;
class CEvent;
class CComponent;
//class ConfigModule;

class CalendarBackendData
{   
public:
    CalendarBackendData();
    ~CalendarBackendData();
    void store_event(Event* ev);
    GPtrArray* get_events_by_period(time_t start, time_t end);
    int remove_event(const char* id);

    static CEvent* convert_to_cevent(Event* ev);
    static Event* convert_to_event(CComponent* cev);
    ConfigModule* conf;
private:
    CCalendar* m_cal;
};

#endif // CB_H
