#ifndef MAIN_H
#define MAIN_H

#include <hildon/hildon.h>
#include <libosso.h>
#include <kimi.h>

#include <time.h>
#include <sys/time.h>

#define _(String) gettext(String)

typedef struct _AppData AppData;
struct _AppData {
    HildonProgram* program;     /* handle to application */
    HildonWindow* window;       /* handle to app's window */
    osso_context_t* osso;       /* handle to osso */

    Kimi* kimi;

    GtkWidget* calendar;

    /* settings */
    int default_storage;

    /* day content */
    GtkWidget* day_treeview;

    /* event content */
    HildonPickerButton* button_type;
    GtkWidget* entry_name;
    GtkWidget* entry_location;
    GtkWidget* button_start_date;
    GtkWidget* button_end_date;
    GtkWidget* button_start_time;
    GtkWidget* button_end_time;
    GtkWidget* button_storage;
    Event *edit_ev;
    /* event content more */
    int num_repeat;
    int num_remind; 
    char* desc;
    HildonPickerButton* button_repeat;
    HildonPickerButton* button_remind;
    GtkWidget* text_view;
};	

#endif /* MAIN_H */

