#include <main.h>
#include <locale.h>
#include <windows/wcalendar.h>
#include <windows/callbacks.h>
#include <windows/wsettings.h>

#define OSSO_SERVICE "ru.karelia.cs."PACKAGE

AppData* create_data()
{
    AppData* result = g_new0(AppData, 1);

    /* init osso */
    result->osso = osso_initialize(OSSO_SERVICE, VERSION, TRUE, NULL);
    g_assert(result->osso);

    return result;
}

void destroy_data(AppData* data)
{
    osso_deinitialize(data->osso);
    kimi_deinit(data->kimi);
    g_free(data);
}

void init_kimi_ui_callbacks(AppData* data)
{
    KimiUICallbacks call;
    call.show_banner = show_banner;
    call.show_options = show_options;
    data->kimi = kimi_init(NULL, call, NULL);
}

int main(int argc, char **argv)
{
    HildonProgram* program;
    AppData* data;

    /* Initialize the locale stuff */
    setlocale(LC_ALL, "");
    bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);
    
    hildon_gtk_init (&argc, &argv);

    /* Create the hildon application and setup the title */
    program = HILDON_PROGRAM(hildon_program_get_instance());
    g_set_application_name("Kimi");
 
    data = create_data();
    data->program = program;

    init_kimi_ui_callbacks(data);

    /* init settings */
    data->default_storage = 1;

    /* create main window */
    init_wcalendar(data);
/*
int i;
GPtrArray* array = g_ptr_array_new();

for(i=0; i<2; i++) {
Option opt;
opt.type = OT_STRING;
opt.value.state = OS_SET;
opt.value.v_text = "Ula";
opt.string = "string TesT";

g_ptr_array_add(array, &opt);
}
for(i=0; i<2; i++) {
Option opt;
opt.type = OT_PASSWORD;
opt.value.state = OS_SET;
opt.value.v_text = "Ula";
opt.string = "string TesT";

g_ptr_array_add(array, &opt);
}
for(i=0; i<2; i++) {
Option opt;
opt.type = OT_BOOLEAN;
opt.value.state = OS_SET;
opt.value.v_boolean = TRUE;
opt.string = "Bool";

g_ptr_array_add(array, &opt);
}
for(i=0; i<2; i++) {
Option opt;
opt.type = OT_INTEGER;
opt.value.state = OS_SET;
opt.value.v_int = 539;
opt.string = "INT";

g_ptr_array_add(array, &opt);
}

show_options(NULL, "title", "message", array);
*/
    g_signal_connect_swapped(data->window,
		      "delete_event",
		      G_CALLBACK (question_exit),
		      NULL);
    
    gtk_main ();

    destroy_data(data);

    return 0;
}


