/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
/*
  SETTINGS
  Кодировщик: Цветков Е.М.
  Дата последней модификации: 31.07.2009
*/

#include <settings/settings.h>
void conf_init(AppData *data)
{
    data->KeyFile = g_key_file_new();

    char* file_config = build_full_path(CONFIG);
    
    /* If file exists then load config from file */
    if (g_file_test(file_config, G_FILE_TEST_EXISTS)) {
        g_key_file_load_from_file(data->KeyFile, file_config, G_KEY_FILE_KEEP_COMMENTS, NULL);
    } else { /* If file not exists then generate default config */
        g_key_file_set_string(data->KeyFile, "GUI", "AppName", "Kimi");
        g_key_file_set_string(data->KeyFile, "GUI", "StartWindow", "month");
        g_key_file_set_string(data->KeyFile, "GUI", "Language", "en");
        g_key_file_set_boolean(data->KeyFile, "GUI", "AutoFullScreen", FALSE);
        g_key_file_set_integer(data->KeyFile, "GUI", "ShowImg", 1);
        g_key_file_set_string(data->KeyFile, "GUI", "FontSize", "Medium");

        /* [Service] */
        g_key_file_set_string(data->KeyFile, "Service", "GoogleURL", "");

        g_key_file_set_string(data->KeyFile, "Service", "GoogleLogin", "");
        g_key_file_set_string(data->KeyFile, "Service", "GooglePass", "");

        g_key_file_set_string(data->KeyFile, "Service", "VkontakteURL", "");
        g_key_file_set_string(data->KeyFile, "Service", "VkontakteLogin", "");

        /* [PersonalInfo] */
        g_key_file_set_string(data->KeyFile, "PersonalInfo", "Surname", "");
        g_key_file_set_string(data->KeyFile, "PersonalInfo", "Name", "");
        g_key_file_set_string(data->KeyFile, "PersonalInfo", "Second", "");
        g_key_file_set_string(data->KeyFile, "PersonalInfo", "BirthdayDate", "");
        g_key_file_set_string(data->KeyFile, "PersonalInfo", "Address", "");
        g_key_file_set_string(data->KeyFile, "PersonalInfo", "Phone", "");

    }
    g_free(file_config);

    /* Test */
/*    char *s, *s1;
    s = g_key_file_get_start_group(KeyFile);
    s1= g_key_file_get_string(KeyFile, s, "AppName", NULL);
    printf("\n @@ %s %s @@ \n", s, s1); 

    s1= g_key_file_get_string(KeyFile, "PersonalInfo", "Name", NULL);
    printf("\n @@ %s @@ \n", s1);

    g_key_file_set_string(KeyFile, "PersonalInfo", "Name", "User_test");

    s1= g_key_file_get_string(KeyFile, "PersonalInfo", "Name", NULL);
    printf("\n @@ %s @@ \n", s1);

    conf_save_to_file(KeyFile, CONFIG);
*/
}

void conf_save(AppData *data)
{
    char *str_data;
    int len;

    char* file_config = build_full_path(CONFIG);

    str_data = g_key_file_to_data(data->KeyFile, &len, NULL);
    g_file_set_contents(file_config, str_data, len, NULL);
    g_free (str_data);
}

void conf_destroy(AppData *data)
{
    g_key_file_free(data->KeyFile);
}

