/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
#include <remote_storage/remote_storage.h>
#include <hildon/hildon-program.h>
#include <gtk/gtk.h>
#include <stdlib.h>

int ev_rcv_contact_upload(RemoteStorage service, account auth, GPtrArray* contacts, GError** error)
{

/* DEPRICATED: Left from previous iteration

    GError *tmp_error = NULL;

    g_return_val_if_fail (error == NULL || *error == NULL, NULL);

    switch (service) {
        case GOOGLE_CALENDAR:
            if (!google_contact_upload(auth, contacts, &tmp_error)) {
                g_propagate_error (error, tmp_error);
                return NULL;
            }
            break;
        case VKONTAKTE_CALENDER:
            if (!vkontakte_contact_upload(auth, contacts, &tmp_error)) {
                g_propagate_error (error, tmp_error);
                return NULL;
            }
            break;
        default:
            g_set_error(error, NULL, NULL, "Can't upload events. Unknown calendar remote storage.");
            return NULL;
    }

*/

    return 0;
}


GPtrArray* ev_rcv_contact_download(RemoteStorage service, account auth, GError** error)
{

/* DEPRICATED: Left from previous iteration

    GError *tmp_error = NULL;
    GPtrArray *contacts = NULL;
    contacts = g_ptr_array_new ();

    g_return_val_if_fail (error == NULL || *error == NULL, NULL);

    switch (service) {
        case GOOGLE_CALENDAR:
            contacts = google_contact_download(auth, &tmp_error);
            if (tmp_error != NULL) {
                g_propagate_error (error, tmp_error);
                return NULL;
            }
            break;
        case VKONTAKTE_CALENDER:
            contacts = vkontakte_contact_download(auth, &tmp_error);
            if (tmp_error != NULL) {
                g_propagate_error (error, tmp_error);
                return NULL;
            }
            break;
        default:
            g_set_error(error, NULL, NULL, "Can't download contacts. Unknown calendar remote storage.");
            return NULL;
    }

    if (contacts == NULL) {
        g_set_error(error, NULL, NULL, "Can't download contacts. Unknown problem with protocol.");
        return NULL;
    }

*/

    return contacts;
}
