/*

Kana of The Day -- Japanese kana learning application for Maemo Fremantle.
Copyright (C) 2012 M. Hossein Azadmanesh (mhazadmanesh2009@gmail.com)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#include "HelpDialog.h"
#include "ScrollableLabel.h"

#include <QBoxLayout>

HelpDialog::HelpDialog(bool showWelcome, QWidget *parent) :
    QDialog(parent)
{
    setWindowTitle("Short Introduction");

    QString homewidgetstext;
    if (showWelcome) homewidgetstext = "<b>This application has two <i>DESKTOP WIDGET</i>s, one horizontal "
        "and one vertical; they should "
        "have been added to Maemo's desktop screen!</b> If not, after closing this message choose 'Help' from "
        "the application menu for instructions on adding them.<br/><br/>\n";
    else homewidgetstext =
        "This application installs two home-screen widgets to let you view the Kana of The Day on Maemo's "
        "desktop screen. If they weren't automatically added to your desktop, add them this way: On your "
        "Maemo desktop, tap the screen once, then tap the <i>gear</i> icon on the top and from <i>Desktop "
        "Menu</i> choose <i>Add Widget</i>, select your desired 'Kana of The Day' widget and tap your "
        "favourite location on the screen to add them.<br/><br/>\n"
        "You can dock the home widgets to any edge of the screen (or just leave it <i>near</i> any edge) "
        "and they will stick to that position.<br/><br/>\n";

    QString introText = "";
    if (showWelcome)
        introText = "<b>Welcome To Kana of The Day!</b><br/><br/>\n";
    introText +=
        "You can memorize one hiragana and one katakana every day (or more than one, if you wish).<br/><br/>\n"
        "You can also restrict the kanas to small groups via the <i>Choose Kana Set</i> menu.<br/><br/>\n";
    introText += homewidgetstext;
    introText +=
        "You can tap the home widget to open the main application.<br/><br/>\n"
        "If you wish to memorize more than one kana, you can use <i>Previous Kana</i> "
        "and <i>Next Kana</i> buttons, press Left arrow or Right arrow key on keyboard, or "
        "<b>SWIPE your finger on the screen left and right</b>.<br/><br/>\nYou can use this program "
        "in both portrait and landscape mode, so hold your device conveniently.<br/><br/>\n"
        "You can test your knowledge by clicking on the <b>[x]</b> button besides the Romaji field to hide it."
        "<br/><br/>\nHowever, if you want a more advanced flash-card like repetition and exam program, "
        "I recommend you use <b>kanatest</b> application besides this program.<br/><br/>\n"
        "The kana sets (categories) used in this program are exactly the same as those in <b>kanatest</b>, "
        "so you can use this program to learn kana, then use <b>kanatest</b> to test knowledge.";

    QVBoxLayout* mainLayout = new QVBoxLayout();
    mainLayout->addWidget(new ScrollableLabel(introText));
    setLayout(mainLayout);
}

HelpDialog::~HelpDialog()
{

}
