/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef TOOLBARITEM_H
#define TOOLBARITEM_H

#include <QtCore/QObject>
#include <QtGui/QGraphicsPixmapItem>

class QString;

class ToolbarItem: public QObject, public QGraphicsPixmapItem
{
    Q_OBJECT

public:
    ToolbarItem(QString const& filename, QString const& activeFilename, QGraphicsItem *parent = 0);

protected:
    virtual void mousePressEvent(QGraphicsSceneMouseEvent *event);
    virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *event);
    virtual void mouseMoveEvent( QGraphicsSceneMouseEvent* event);

signals:
    void clicked();

private:
    QPixmap pixmap_;
    QPixmap activePixmap_;
    bool active_;
};


#endif
