/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "mainwindowstack.h"

MainWindowStack::MainWindowStack(QWidget* parent): WidgetScreen(parent),
currentScreen_(-1)
{
}

void MainWindowStack::addScreen(WidgetScreen* screen)
{
    screens_.push_back(screen);
    connect(screen, SIGNAL(minimizePressed()), this, SIGNAL(minimizePressed()));
    connect(screen, SIGNAL(settingsPressed()), this, SIGNAL(settingsPressed()));
    connect(screen, SIGNAL(closePressed()), this, SIGNAL(closePressed()));
    connect(screen, SIGNAL(clicked()), this, SLOT(toggleScreen()));
    addWidget(screen);

    if(currentScreen_ == -1)
    {
        toggleScreen();
    }
}

void MainWindowStack::reArrange()
{
    for(int i = 0; i < screens_.size(); i++)
    {
        screens_.at(i)->reArrange();
    }
}

void MainWindowStack::flip()
{
    for(int i = 0; i < screens_.size(); i++)
    {
        screens_.at(i)->flip();
    }
}

void MainWindowStack::toggleScreen()
{
    if(currentScreen_ < 0)
    {
        currentScreen_ = 0;
    }
    else
    {
        currentScreen_++;

        if(currentScreen_ >= screens_.size())
        {
            currentScreen_ = 0;
        }
    }

    setCurrentIndex(currentScreen_);
}
