/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef EFFECT_H
#define EFFECT_H

class QString;
class QGraphicsItem;

class Effect
{
public:
    struct AttributeDetails
    {
        QString name;
        bool isQreal;
    };

    Effect();
    static Effect* getEffect(QString const& name);
    virtual bool setAttribute(QString const& name, QString const& value) = 0;
    virtual void apply(QGraphicsItem* item) = 0;

protected:
    int getAttribute(QString const& name, QString const& value, const AttributeDetails details[], int count, qreal& realValue);

};

#endif
