/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef ODOMETER_H
#define ODOMETER_H

#include <QtCore/QObject>
#include "location.h"

class QTime;
class QTimer;

class Odometer : public QObject
{
    Q_OBJECT

public:
    virtual ~Odometer();
    static Odometer& instance();
    void start();
    void end();
    double getTrip() const;
    double getAverageSpeed() const;
    double getTotal() const;
    double getMaxSpeed() const;
    qulonglong getTotalTime() const;
    qulonglong getTripTime() const;
    Location::Fix const& getLatestFix() const;
    double getSignalStrength() const;
    static QString const& getUnit();
    static QString const& getSpeedUnit();

signals:
    void dataUpdated();
    void timeUpdated();
    void unitChanged();

public slots:
    void update(Location::Fix const& fix);
    void updateUnit();
    void resetTrip();
    void resetTotal();
    void resetAll();
    void store();

private slots:
    void fixTimeout();

private:
    Q_DISABLE_COPY(Odometer);
    Odometer();
    void startTiming();
    void endTiming();
    void resetTiming();
    int timeAddition() const;
    Location::Fix latestFix_;
    double trip_;
    double total_;
    double maxSpeed_;
    qulonglong totalTime_;
    qulonglong tripTime_;
    QTime* fixTimer_;
    QTime* mainTimer_;
    bool emitUpdate_;
    Location* location_;
    QTimer* signalTimer_;
    QTimer* timeoutTimer_;
};

#endif
