/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtCore/QString>
#include <QtCore/QByteArray>
#include <QtCore/QDir>
#include <QtCore/QFile>
#include "filereader.h"

FileReader::FileReader(QString const& dirname): Reader(), dirname_(dirname)
{
}

bool FileReader::open()
{
    return true;
}

bool FileReader::readFile(QString const& filename, QByteArray& data)
{
    QFile file(dirname_ + QDir::separator() + filename);

    if(!file.exists())
    {
        error_ = "No such file: " + filename;
        return false;
    }

    if(file.open(QIODevice::ReadOnly))
    {
        data = file.readAll();
    }
    else
    {
        error_ = "Unable to open file: " + filename;
        return false;
    }

    file.close();
    return true;
}

bool FileReader::fileExists(QString const& filename) const
{
    return QFile::exists(dirname_ + QDir::separator() + filename);
}

bool FileReader::close()
{
    return true;
}

QString const& FileReader::errorString() const
{
    return error_;
}
