/*
 * jammo-game.h
 *
 * This file is part of JamMo.
 *
 * (c) 2010 University of Oulu
 *
 * Authors: Henrik Hedberg <henrik.hedberg@oulu.fi>
 */

#ifndef __JAMMO_GAME_H__
#define __JAMMO_GAME_H__

#include <tangle.h>

#define JAMMO_TYPE_GAME (jammo_game_get_type())
#define JAMMO_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), JAMMO_TYPE_GAME, JammoGame))
#define JAMMO_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), JAMMO_TYPE_GAME))
#define JAMMO_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), JAMMO_TYPE_GAME, JammoGameClass))
#define JAMMO_IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), JAMMO_TYPE_GAME))
#define JAMMO_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), JAMMO_TYPE_GAME, JammoGameClass))

typedef struct _JammoGamePrivate JammoGamePrivate;

typedef struct _JammoGame {
	TangleObject parent_instance;
	JammoGamePrivate* priv;
} JammoGame;

typedef struct _JammoGameClass {
	TangleObjectClass parent_class;
	void (*started)(JammoGame* game);
	void (*task_completed)(JammoGame* game, const gchar* task_name, guint tasks_completed);
	void (*task_redone)(JammoGame* game, const gchar* task_name, guint tasks_completed);
	void (*completed)(JammoGame* game);
} JammoGameClass;

GType jammo_game_get_type(void) G_GNUC_CONST;

JammoGame* jammo_game_new(TangleView* view);

void jammo_game_start(JammoGame* game);
void jammo_game_complete(JammoGame* game);

GList* jammo_game_get_tasks(JammoGame* game);
void jammo_game_add_task(JammoGame* game, const gchar* task_name);

gboolean jammo_game_get_task_completed(JammoGame* game, const gchar* task_name);
void jammo_game_set_task_completed(JammoGame* game, const gchar* task_name, gboolean is_completed);

guint jammo_game_get_tasks_to_complete(JammoGame* game);
void jammo_game_set_tasks_to_complete(JammoGame* game, guint number_of_tasks);

guint jammo_game_get_tasks_completed(JammoGame* game);

#endif
