/**sequencer.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is center of 7-12 years full sequencer view.
View contains three part:
 *wheel-game (loop-view)
 *track-view
 *general-view (settings)

*/

#include <glib-object.h>
//#include <clutter/clutter.h>
#include <math.h>
#include <string.h>

#include <tangle.h>

#include "../../meam/jammo-meam.h"
#include "../jammo.h"
#include "../jammo-mentor.h"
#include "../jammo-track-view.h"
#include "../jammo-miditrack-view.h"


#include "sequencer.h"
#include "sequencer_loop.h"
#include "sequencer_general.h"
#include "sequencer_track_view.h"
#include "startmenu.h"


static void load_state_from_file(FILE *ifp) {
	gboolean not_ready = TRUE;

	int bytes_read;

	size_t nbytes = 256; //No field can have this many characters
	char *my_string;
	my_string = (char *) malloc (nbytes + 1);

	int slot;
	char* wav_name = malloc (nbytes + 1);
	char* png_name = malloc (nbytes + 1);

	ClutterActor* track_view = NULL; //Will be jammo_trac_view or jammo_miditrack_view
	while (not_ready) {

		bytes_read = getline (&my_string, &nbytes, ifp);
		if (bytes_read <= 0)
		{
			not_ready=FALSE;
			continue;
		}

		if(strncmp(my_string, "Track-type:", 11) == 0) {
			printf("New track.\n");

			/* TODO: Do we know the total length of the song (and thus, this track)? */
			track_view=sequencer_track_view_add_with_type(my_string +12); //FIXME: (char*  + 12)
		} else {
				if (JAMMO_IS_MIDITRACK_VIEW(track_view)) {
					bytes_read = getline (&my_string, &nbytes, ifp);
					if (bytes_read <= 0) {
						not_ready=FALSE;
						continue;
					}
				char* note_file= malloc (nbytes + 1);
				strncpy(note_file, my_string, strlen(my_string)-1); //throw end-of-line away
				note_file[strlen(my_string)-1]='\0';                //Add string terminator

				printf("loading notes from file '%s'\n",note_file);
				GList* events = jammomidi_file_to_glist(note_file);
				jammo_miditrack_view_add_event_list(JAMMO_MIDITRACK_VIEW(track_view),events);

				} else {
						printf("New sample to slot.\n");
						slot = atoi(my_string);
						printf("Slot: %d\n", slot);
						//sound filename
						bytes_read = getline (&my_string, &nbytes, ifp);
						if (bytes_read <= 0)
						{
							not_ready=FALSE;
							continue;
						}
						strncpy(wav_name, my_string, strlen(my_string)-1); //throw end-of-line away
						wav_name[strlen(my_string)-1]='\0';                //Add string terminator

						printf("name of soundfile='%s'\n",wav_name);


						//image filename
						bytes_read = getline (&my_string, &nbytes, ifp);
						if (bytes_read <= 0)
							{
							not_ready=FALSE;
							continue;
							}
						strncpy(png_name, my_string, strlen(my_string)-1); //throw end-of-line away
						png_name[strlen(my_string)-1]='\0';                //Add string terminator

						printf("name of pngfile='%s'\n",png_name);

						//Make sample_button and put it into track.
						ClutterActor* sample_button;
						sample_button = jammo_sample_button_new_from_files(png_name, wav_name);
						printf("Sample button created\n");

						if (track_view == NULL)
							printf("Can't put sample because track is NULL\n");
						else
							jammo_track_view_add_jammo_sample_button(JAMMO_TRACK_VIEW(track_view),JAMMO_SAMPLE_BUTTON(sample_button), slot);
						}
			}
	}
}



gboolean sequencer_change_to_loop_view(TangleActor *actor, gpointer data) {
	printf("changing view to loop \n");
	ClutterActor* scrolling_actor = jammo_get_actor_by_id("fullsequencer-scroller");
	clutter_actor_animate(CLUTTER_ACTOR(scrolling_actor), CLUTTER_EASE_IN_OUT_QUAD, 250, "scrolling-offset-y", 0.0, NULL);
	return TRUE;
}

gboolean sequencer_change_to_sequencer_view(TangleActor *actor, gpointer data) {
	printf("changing view to sequencer \n");
	ClutterActor* scrolling_actor = jammo_get_actor_by_id("fullsequencer-scroller");
	clutter_actor_animate(CLUTTER_ACTOR(scrolling_actor), CLUTTER_EASE_IN_OUT_QUAD, 250, "scrolling-offset-y", 480.0, NULL);
	return TRUE;
}

gboolean sequencer_change_to_bottom_view (TangleActor *actor, gpointer data) {
	printf("changing view to bottom \n");
	ClutterActor* scrolling_actor = jammo_get_actor_by_id("fullsequencer-scroller");
	clutter_actor_animate(CLUTTER_ACTOR(scrolling_actor), CLUTTER_EASE_IN_OUT_QUAD, 250, "scrolling-offset-y", 960.0, NULL);
	return TRUE;
}

static void on_duration_notify(GObject* object, GParamSpec* pspec, gpointer sequencer) {
	JammoSample* sample;
	sample = JAMMO_SAMPLE(object);

	// The duration of backing track is used to set fixed duration for other tracks
	guint64 duration;
	duration = jammo_sample_get_duration(sample);
	g_print("Duration: %" G_GUINT64_FORMAT "\n", duration);


	gint number_of_slots = 32 ; //TODO: now we know that backing track has 32 slots.
	gfloat slot_width = 40.0;
	gfloat height = 50.0;
	//sequencer_track_view uses internally this just created area.
	sequencer_track_view_create_area_for_tracks(JAMMO_SEQUENCER(sequencer),number_of_slots, duration, slot_width,height);

	//tangle_widget_add(TANGLE_WIDGET(jammo_get_actor_by_id("fullsequencer-container_old_-for-tracks")), sequencer_view,NULL);



	//Loading tracks from file:
	if(inputFilename) {
		FILE *ifp;
		ifp = fopen(inputFilename, "r"); //currently open only for reading

		if(ifp != NULL) {
			load_state_from_file(ifp);
		}
	} else {
		printf("No file specified for sequencer.\n");
	}

	// Do not call this function ever again!
	g_signal_handlers_disconnect_by_func(object, G_CALLBACK(on_duration_notify), sequencer);
}


void start_sequencer(gpointer filename)
{
	//This is The sequencer of the game. All 'play'-buttons should play this.
	//All new tracks are added to this
	//If metronome is enabled it is added to this
	JammoSequencer* sequencer = jammo_sequencer_new ();

	printf("Starting sequencer GUI\n");
	//inputFilename is global! (from sequencer.h)
	if (filename == NULL)
		inputFilename = NULL;
	else {
		inputFilename = malloc(strlen((gchar*) filename) + 1);
		memcpy(inputFilename, (gchar*) filename, strlen((gchar*) filename) + 1);
		printf("The filename is '%s'\n",inputFilename);
	}


	tangle_actor_hide_animated(TANGLE_ACTOR(jammo_mentor_get_default()));

	ClutterActor* mainview;
	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);

	ClutterActor* view = jammo_get_actor_by_id("fullsequencer-view");
	clutter_actor_show(view);


	//Tune some things that can't be done with JSON only (TODO)
	sequencer_loop_tune_wheels();

	//TODO. these can be done with JSON
	sequencer_general_tune_containers();


	//TODO:
	JammoEditingTrack* backing_track;
	JammoSample* sample;
	backing_track = jammo_editing_track_new();
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(backing_track));
	sample = jammo_sample_new_from_file("/opt/jammo/themes/animal/140/backing_track.wav");
	jammo_editing_track_add_sample(backing_track, sample, 0);


	// Create tracks when the duration of the backing track is known.
	g_signal_connect(sample, "notify::duration", G_CALLBACK(on_duration_notify), sequencer);


	sequencer_change_to_sequencer_view(NULL,NULL); //Start to middle view.
}

/*
void leave_sequencer()
{
	clutter_actor_hide(CLUTTER_ACTOR(sequencer_view));

	start_startmenu();
}
*/

