/*
There are list of songs.
When pressing song-icon it will start playing alone ( on ad-hoc sequencer).
 Pressing another song-icon will stop previous song.

If vocal-button is toggled, vocal-version of track is used.


Last selected/listened will be used when user press 'OK'-button.
Cancel-button returns without modification.

*/
#include <glib-object.h>
#include <tangle.h>


#include "../../meam/jammo-meam.h"
#include "../../meam/jammo-backing-track.h"


#include "../jammo.h"
#include "../configure.h"
//This affects to adhoc_sequencer and when returning to main-view.
static gboolean vocal_selected = FALSE;


static JammoSequencer* adhoc_sequencer;
static void on_sequencer_stopped(JammoSequencer* sequencer, gpointer user_data) {
	printf("backingtrack_selection.c: on_sequencer_stopped\n");
	g_object_unref(sequencer);
	adhoc_sequencer=NULL;
}


void backingtrack_song_clicked (TangleButton* tanglebutton, gpointer none){
	const gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(tanglebutton));
	printf("backingtrack_song_clicked: '%s'\n",name);

	//Vocal or accompaniment only
	gchar* prefix = vocal_selected?"SaV":"Sa";


	gchar* backing_track_filename = g_strdup_printf("%s/backingtracks/%s_%s_$t_$p.ogg",DATA_DIR,prefix,name);
	printf ("looking backing_track_filename: '%s'\n",backing_track_filename);
	if (adhoc_sequencer){
		jammo_sequencer_stop(adhoc_sequencer);
	}

	adhoc_sequencer = jammo_sequencer_new();
	JammoSequencer* global_sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));
	jammo_sequencer_set_tempo(adhoc_sequencer,jammo_sequencer_get_tempo(global_sequencer));
	jammo_sequencer_set_pitch(adhoc_sequencer,jammo_sequencer_get_pitch(global_sequencer));
	//printf("tempo and pitch set\n");

	JammoTrack* track = JAMMO_TRACK(jammo_backing_track_new(backing_track_filename));
	jammo_sequencer_add_track(adhoc_sequencer, JAMMO_TRACK(track));


	g_signal_connect(adhoc_sequencer, "stopped", G_CALLBACK(on_sequencer_stopped), NULL);
	jammo_sequencer_play(adhoc_sequencer);
}


void backingtrack_selection_vocal_clicked(TangleButton* tanglebutton, gpointer none){
	printf("backingtrack_selection_vocal_clicked\n");
	vocal_selected = tangle_button_get_selected(tanglebutton);
}

static void end_backingtrack_selection() {
	jammo_sequencer_stop(adhoc_sequencer);
	clutter_actor_hide(jammo_get_actor_by_id("backingtrack-selection-view"));
	clutter_actor_show(jammo_get_actor_by_id("fullsequencer-view"));
}

//TODO
void backingtrack_selection_ok_clicked(TangleButton* tanglebutton, gpointer none){
	printf("backingtrack_selection_ok_clicked\n");
	end_backingtrack_selection();
}


void backingtrack_selection_cancel_clicked(TangleButton* tanglebutton, gpointer none){
	printf("backingtrack_selection_cancel_clicked\n");
	end_backingtrack_selection();
}

void backingtrack_up_arrow_clicked(TangleButton* tanglebutton, gpointer none){
printf("backingtrack_up_arrow_clicked\n");
	ClutterActor* scroller = jammo_get_actor_by_id( "backingtrack-selection-scroller");
	float old_value;
	g_object_get(scroller, "scrolling-offset-y", &old_value, NULL);
	clutter_actor_animate(scroller, CLUTTER_EASE_IN_OUT_QUAD, 250,"scrolling-offset-y",old_value-130, NULL);
}


void backingtrack_down_arrow_clicked(TangleButton* tanglebutton, gpointer none){
printf("backingtrack_down_arrow_clicked\n");
	ClutterActor* scroller = jammo_get_actor_by_id( "backingtrack-selection-scroller");
	float old_value;
	g_object_get(scroller, "scrolling-offset-y", &old_value, NULL);
	clutter_actor_animate(scroller, CLUTTER_EASE_IN_OUT_QUAD, 250,"scrolling-offset-y",old_value+130, NULL);
}

