/**sequencer_track_view.h is part of JamMo.
License: GPLv2, read more from COPYING

SequencerTrackView is struct which contains jammo-track-view (or jammo-miditrack-view)
and buttons for volume, muting
and label
and some metadata.

*/

#ifndef SEQUENCER_SEQUENCER_H_
#define SEQUENCER_SEQUENCER_H_

#include <stdbool.h>

/*
 * Wraps TrackView and buttons & labels into one clean package
 * to add and remove TrackViews easily to sequencer
 */
typedef struct {
	ClutterActor *sequencer_track_view_container;
	ClutterActor *track_view;
	ClutterActor *label;
	ClutterActor *mute_button;
	ClutterActor *volume_button;
	gint position;
	bool muted;
	bool volume_pressed_down;
	gint volume_level;
	char *track_type;
} SequencerTrackView;

/*
 * Contains all possible SequencerTrackView types
 */
enum {
	KEYBOARD_TRACK_VIEW = 1,
	DRUM_TRACK_VIEW,
	SLIDER_TRACK_VIEW,
	AUDIO_TRACK_VIEW,
	LOOP_TRACK_VIEW,
	BACKING_TRACK_VIEW
};


ClutterActor *sequencer_track_view_create_area_for_tracks(JammoSequencer* seq);
ClutterActor* sequencer_track_view_add_with_type(gchar* track_view_type, guint64 duration);

//void sequencer_sequencer_track_view_remove_last();
bool save_sequencer_state();

#endif /* SEQUENCER_SEQUENCER_H_ */
