/**midi_editor_notes.h is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This header files consists of note structures and functions to modify notes.

These structures and functions should make it easier to control notes, their properties
and visual representations.
*/

#ifndef MIDI_EDITOR_NOTES_H_
#define MIDI_EDITOR_NOTES_H_

#include <stdlib.h>
#include <stdio.h>
#include <clutter/clutter.h>
#include <glib.h>

//Struct to represent notes
typedef struct note_struct {
	ClutterActor *note_actor;
	char note;
	int octave;
	//TODO: Add precise start and stop times (floats, doubles, what?)
	double start_time;
	double end_time;

} Note;

typedef GPtrArray NoteArray;

NoteArray* new_note_collection();
void free_note_collection(NoteArray *array);
guint get_note_collection_size(NoteArray *array);

void sort_note_collection(NoteArray *array);

Note* new_note(char note, int octave, double start_time, double end_time);
Note* new_note_with_actor(char note, int octave, double start_time, double end_time, ClutterActor *actor);

Note* get_note(NoteArray *array, int note_index);
Note* get_note_from_actor(NoteArray *array, ClutterActor *actor);
ClutterActor* get_note_actor(NoteArray *array, int note_index);
gboolean set_note_time(NoteArray *array, double start_time, double end_time, ClutterActor *actor);
gboolean remove_note_from_collection(NoteArray *array, ClutterActor *actor);
void add_note_to_collection(NoteArray *array, Note *note);
gboolean is_note_overlapping(NoteArray *array, Note *note);

//Debug prints for internal use
void note_debug_print(Note *note);
void note_collection_debug_print(NoteArray *array);

void save_note_collection_to_file(NoteArray *array, gchar *filename);

void midi_note_test();


#endif /* MIDI_EDITOR_NOTES_H_ */
