/*
 * jammo-slider-track.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009 University of Oulu
 *
 * Authors: Aapo Rantalainen
 */
 
#include "jammo-slider-track.h"
#include "jammo-meam.h"
#include "jammo-meam-private.h"
#include <sys/time.h>

G_DEFINE_TYPE(JammoSliderTrack, jammo_slider_track, JAMMO_TYPE_TRACK);

enum {
	PROP_0,
	PROP_SLIDER_TYPE,
};

struct _JammoSliderTrackPrivate {
	GstElement* element;
	int slider_type;
	struct timeval creation_time; //Not used yet
};


JammoSliderTrack* jammo_slider_track_new(JammoSliderType slider_type) {
	return JAMMO_SLIDER_TRACK(g_object_new(JAMMO_TYPE_SLIDER_TRACK,"slider-type",slider_type,NULL));
}

static guint64 jammo_slider_track_get_duration(JammoTrack* track) {
	guint64 duration = 0;

	/* TODO: Get real duration. */

	return duration;
}

static GstElement* jammo_slider_track_get_element(JammoTrack* track) {

	return JAMMO_SLIDER_TRACK(track)->priv->element;
}

static void jammo_slider_track_set_property(GObject* object, guint prop_id, const GValue* value, GParamSpec* pspec) {
	JammoSliderTrack* slider_track;
	
	slider_track = JAMMO_SLIDER_TRACK(object);

	switch (prop_id) {
		case PROP_SLIDER_TYPE:
			slider_track->priv->slider_type = g_value_get_int(value);
			printf("set_property: slider=%d \n",g_value_get_int(value));
			break;
		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
			break;
	}
}

static void jammo_slider_track_get_property(GObject* object, guint prop_id, GValue* value, GParamSpec* pspec) {
    JammoSliderTrack* slider_track;
		slider_track = JAMMO_SLIDER_TRACK(object);

        switch (prop_id) {
					case PROP_SLIDER_TYPE:
						g_value_set_int(value, slider_track->priv->slider_type);
						break;
	        default:
		        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
		        break;
        }
}

static void jammo_slider_track_finalize(GObject* object) {
	G_OBJECT_CLASS(jammo_slider_track_parent_class)->finalize(object);
}

static void jammo_slider_track_dispose(GObject* object) {
	JammoSliderTrack* slider_track;

	slider_track = JAMMO_SLIDER_TRACK(object);
	G_OBJECT_CLASS(jammo_slider_track_parent_class)->dispose(object);
}


static GObject* jammo_slider_track_constructor(GType type, guint n_properties, GObjectConstructParam* properties) {
	GObject* object;
	JammoSliderTrack* slider_track;

	object = G_OBJECT_CLASS(jammo_slider_track_parent_class)->constructor(type, n_properties, properties);

	slider_track = JAMMO_SLIDER_TRACK(object);
	slider_track->priv = G_TYPE_INSTANCE_GET_PRIVATE(slider_track, JAMMO_TYPE_SLIDER_TRACK, JammoSliderTrackPrivate);

	int slider_nro = slider_track->priv->slider_type;
	printf ("Type of slider is: %d\n",slider_nro);

	slider_track->priv->element = gst_element_factory_make("jammoslider", NULL);
	g_object_set(G_OBJECT(slider_track->priv->element), "instrument", slider_nro, NULL);


	gettimeofday(&slider_track->priv->creation_time, NULL);

	return object;
}


static void jammo_slider_track_class_init(JammoSliderTrackClass* slider_track_class) {
	GObjectClass* gobject_class = G_OBJECT_CLASS(slider_track_class);
	JammoTrackClass* track_class = JAMMO_TRACK_CLASS(slider_track_class);

	track_class->get_duration = jammo_slider_track_get_duration;
	track_class->get_element = jammo_slider_track_get_element;
	gobject_class->constructor = jammo_slider_track_constructor;
	gobject_class->finalize = jammo_slider_track_finalize;
	gobject_class->dispose = jammo_slider_track_dispose;
	gobject_class->set_property = jammo_slider_track_set_property;
	gobject_class->get_property = jammo_slider_track_get_property;

	/**
	 * JammoSliderTrack:slider-type:
	 */
	g_object_class_install_property(gobject_class, PROP_SLIDER_TYPE,
	                                g_param_spec_int("slider-type",
	                                "Slider type",
	                                "Specifies type of slider",
	                                0,JAMMO_SLIDER_TYPE_DUMMY-1,0,
	                                G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	
	g_type_class_add_private(gobject_class, sizeof(JammoSliderTrackPrivate));
}

void jammo_slider_track_set_frequency(JammoSliderTrack* slider_track,int frequency){
	g_object_set(G_OBJECT(slider_track->priv->element), "slider-freq", (gfloat)frequency, NULL);
}

void jammo_slider_track_set_state(JammoSliderTrack* slider_track,gboolean state){
	g_object_set(G_OBJECT(slider_track->priv->element), "slider-state", state, NULL);
}

static void jammo_slider_track_init(JammoSliderTrack* slider_track) {
	slider_track->priv = G_TYPE_INSTANCE_GET_PRIVATE(slider_track, JAMMO_TYPE_SLIDER_TRACK, JammoSliderTrackPrivate);
}

