/**sequencer.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is the sequencer.
 */

#include <glib-object.h>
//#include <clutter/clutter.h>
#include <math.h>
#include <string.h>

#include <tangle.h>

#include "jammo-texture.h"

#include "config.h"
#include "sequencer.h"
#include "sequencer_loop.h"
#include "sequencer_general.h"
#include "sequencer_sequencer.h"
#include "../chum/chum.h"

/*
 * state machine states
 */
enum {
	SEQUENCER_STATE_MOVING = 0,
			SEQUENCER_STATE_LOOP,
			SEQUENCER_STATE_SEQUENCER,
			SEQUENCER_STATE_GENERAL,
			LOOP_ROLL_READY,
			LOOP_ROLL_MOVING,
			SEQUENCER_STATE_PLAYING,
			SEQUENCER_STATE_AUDIO_RECORD

};

int state = SEQUENCER_STATE_SEQUENCER;

//private functions

gboolean sequencer_is_ready = FALSE;

ClutterActor *sequencer_group;

static gboolean set_sequencer_state_loop(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	state = SEQUENCER_STATE_LOOP;
	return TRUE;
}

static gboolean set_sequencer_state_sequncer(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	state = SEQUENCER_STATE_SEQUENCER;
	return TRUE;
}

static gboolean set_sequencer_state_general(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	state = SEQUENCER_STATE_GENERAL;
	return TRUE;
}


/*
 * Event for changing to loop view
 */
static gboolean change_loop_view(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	if(state != SEQUENCER_STATE_MOVING) {
		ClutterAnimation *anim = clutter_actor_animate(sequencer_group,
				CLUTTER_EASE_IN_OUT_CUBIC, 1000, "x", 0.0, "y", 0.0, NULL);
		state = SEQUENCER_STATE_MOVING;
		g_signal_connect(anim, "completed", G_CALLBACK(set_sequencer_state_loop), NULL);
	}

	return TRUE;
}

/*
 * Event for changing to sequencer view
 */
static gboolean change_sequencer_view(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	if(state != SEQUENCER_STATE_MOVING) {
		ClutterAnimation *anim = clutter_actor_animate (sequencer_group,
				CLUTTER_EASE_IN_OUT_CUBIC, 1000, "x", 0.0, "y", -480.0, NULL);
		state = SEQUENCER_STATE_MOVING;
		g_signal_connect(anim, "completed", G_CALLBACK(set_sequencer_state_sequncer), NULL);
	}

	return TRUE;
}

/*
 * Event for changing to general view
 */
static gboolean change_general_view(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	if(state != SEQUENCER_STATE_MOVING) {
		ClutterAnimation *anim = clutter_actor_animate (sequencer_group,
				CLUTTER_EASE_IN_OUT_CUBIC, 1000, "x", 0.0, "y", -960.0, NULL);
		state = SEQUENCER_STATE_MOVING;
		g_signal_connect(anim, "completed", G_CALLBACK(set_sequencer_state_general), NULL);
	}
	return TRUE;
}


void init_sequencer() {}

void start_sequencer()
{
	printf("Starting sequencer GUI\n");

	ClutterActor* mainview;
	ClutterActor* view;

	mainview = jammo_get_actor_by_id("main-views-widget"); //No drawing on stage anymore, use this.
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), chum_hide_this_tangle_actor, NULL);
	
	view = tangle_view_new();   //This can be defined in json too.
	clutter_container_add(CLUTTER_CONTAINER(mainview), view, NULL);
	clutter_actor_show(view);
	
	ClutterActor* stage = view;



	sequencer_is_ready = FALSE;
	sequencer_group = clutter_group_new();
	clutter_actor_hide(CLUTTER_ACTOR(sequencer_group));
	ClutterActor *sequencer_background;
	//Buttons for sequencer scrolling


	ClutterActor *loop_button_down = config_get_configured_actor("sequencer", "loop_button_down");
	ClutterActor *sequencer_button_down = config_get_configured_actor("sequencer", "sequencer_button_down");
	ClutterActor *sequencer_button_up = config_get_configured_actor("sequencer", "sequencer_button_up");
	ClutterActor *general_button_up = config_get_configured_actor("sequencer", "general_button_up");
	ClutterActor *loop_view = create_loop_view();
	ClutterActor *sequencer_view = create_sequencer_container();

	ClutterActor *general_container = create_general_container();

	sequencer_background = config_get_configured_actor("sequencer","sequencer_bg"); //background

	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), sequencer_background);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), sequencer_view);
//	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), create_loop_view_rolls());
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), loop_view);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), loop_button_down);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), sequencer_button_up);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), sequencer_button_down);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), general_button_up);
	clutter_container_add_actor(CLUTTER_CONTAINER(sequencer_group), general_container);

	clutter_actor_set_rotation(loop_button_down, CLUTTER_Z_AXIS, 180, 0, 0, 0);
	clutter_actor_set_rotation(sequencer_button_down, CLUTTER_Z_AXIS, 180, 0, 0, 0);

	g_signal_connect(CLUTTER_ACTOR(loop_button_down), "button_press_event", G_CALLBACK(change_sequencer_view), NULL);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_down), "button_press_event", G_CALLBACK(change_general_view), NULL);
	g_signal_connect(CLUTTER_ACTOR(sequencer_button_up), "button_press_event", G_CALLBACK(change_loop_view), NULL);
	g_signal_connect(CLUTTER_ACTOR(general_button_up), "button_press_event", G_CALLBACK(change_sequencer_view), NULL);


	/*
  clutter_actor_set_anchor_point(loop_button_down, 42, 50);
  clutter_actor_set_anchor_point(sequencer_button_up, 42, 50);
  clutter_actor_set_anchor_point(sequencer_button_down, 42, 50);
  clutter_actor_set_anchor_point(general_button_up, 42, 5sequencer_button_play_stop0);

  clutter_actor_set_position(loop_view, 0.0, 0.0);
  clutter_actor_set_position(sequencer_view, 0.0, 480.0); //-480.0
  clutter_actor_set_position(loop_button_down, 700, 420);
  clutter_actor_set_position(sequencer_button_up, 700, 520);
  clutter_actor_set_position(sequencer_button_down, 700, 920);
  clutter_actor_set_position(general_button_up, 700, 1000);
	 */
	//  clutter_actor_show_all (CLUTTER_ACTOR(general_container));
	//  clutter_actor_set_reactive(CLUTTER_ACTOR(general_container), TRUE);
	clutter_actor_set_size (CLUTTER_ACTOR(general_container), 800, 480);
	clutter_actor_set_position (CLUTTER_ACTOR(general_container), 0, 960);

	clutter_container_add_actor (CLUTTER_CONTAINER (stage), CLUTTER_ACTOR(sequencer_group));

	clutter_actor_set_reactive(CLUTTER_ACTOR(sequencer_group), TRUE);
	clutter_actor_set_reactive(loop_button_down, TRUE);
	clutter_actor_set_reactive(sequencer_button_down, TRUE);
	clutter_actor_set_reactive(sequencer_button_up, TRUE);
	clutter_actor_set_reactive(general_button_up, TRUE);

	clutter_actor_set_position (sequencer_group, 0.0, -480.0);

	/*  g_signal_connect (grid, "button-release-event", G_CALLBACK (grid_released), NULL);
  g_signal_connect (grid, "motion-event", G_CALLBACK (grid_motion), NULL);
  g_signal_connect (grid, "button-press-event", G_CALLBACK (grid_press),NULL);*/


	//stencil will be all other buttons and elements in editor
	/*
  ClutterActor* stencil=clutter_rectangle_new_with_color (get_transparency_color());
  clutter_actor_set_size (stencil, 800, 480);
  clutter_actor_set_position (stencil, 0, 0);
  clutter_rectangle_set_border_color(CLUTTER_RECTANGLE(stencil),get_blue_color());
  clutter_rectangle_set_border_width(CLUTTER_RECTANGLE(stencil),50);
  clutter_actor_show (stencil);
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), stencil);
	 */
	//clutter_actor_raise_top (actor);
	printf("Sequencer initialization complete!\n");
	sequencer_is_ready = TRUE;
		clutter_actor_show (CLUTTER_ACTOR(sequencer_group));

}

gboolean sequencer_is_initialized()
{
	return sequencer_is_ready;
}

/* TODO - is there better way to do this - i.e. using signals or is this good enough
 *
 * Function to change the view from loop_view and add sample into sequencer
 */
void change_view_to_sequencer(ClutterActor *sample) {
	change_sequencer_view(NULL, NULL, NULL);
	//TODO function to add sample into sequencer
}
