/*
 * jammo-playing-track.h
 *
 * This file is part of JamMo.
 *
 * (c) 2010 University of Oulu
 *
 * Authors: Henrik Hedberg <henrik.hedberg@oulu.fi>
 */
 
#ifndef __JAMMO_PLAYING_TRACK_H__
#define __JAMMO_PLAYING_TRACK_H__

#include <glib.h>
#include <glib-object.h>
#include "jammo-track.h"

#define JAMMO_TYPE_PLAYING_TRACK (jammo_playing_track_get_type ())
#define JAMMO_PLAYING_TRACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), JAMMO_TYPE_PLAYING_TRACK, JammoPlayingTrack))
#define JAMMO_IS_PLAYING_TRACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), JAMMO_TYPE_PLAYING_TRACK))
#define JAMMO_PLAYING_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), JAMMO_TYPE_PLAYING_TRACK, JammoPlayingTrackClass))
#define JAMMO_IS_PLAYING_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), JAMMO_TYPE_PLAYING_TRACK))
#define JAMMO_PLAYING_TRACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), JAMMO_TYPE_PLAYING_TRACK, JammoPlayingTrackClass))

typedef struct _JammoPlayingTrackPrivate JammoPlayingTrackPrivate;

typedef struct _JammoPlayingTrack {
	JammoTrack parent_instance;
	JammoPlayingTrackPrivate* priv;
} JammoPlayingTrack;

typedef struct _JammoPlayingTrackClass {
	JammoTrackClass parent_class;
} JammoPlayingTrackClass;

GType jammo_playing_track_get_type(void);

JammoPlayingTrack* jammo_playing_track_new(const gchar* filename);

#endif
