#include <tangle.h>
#include <clutter/clutter.h>
#include "jammo-mentor.h"
#include "trafficlight_dialog.h"

//Only one trafficlight at a time. 
static gboolean reserved = FALSE;

/*
Hides dialog and restores mentor_idle_speech.
*/
static void finalize(ClutterActor* actor, gchar* idle_speech){
	printf("trafficlight finalize got idle_speech= '%s'\n",idle_speech);
	jammo_mentor_shut_up(jammo_mentor_get_default());
	tangle_actor_destroy_animated(TANGLE_ACTOR(clutter_actor_get_parent(CLUTTER_ACTOR(actor))));
	jammo_mentor_set_idle_speech(jammo_mentor_get_default(),idle_speech);
	reserved = FALSE;
}


static gboolean handle_click (ClutterTexture *actor_2, ClutterEvent *event, gpointer data_vault){
	printf("trafficlight: handle_click\n");
	
	TangleVault* vault;
	ClutterActor* actor;
	gchar* speech;
	TrafficligthCallback user_callback;
	gpointer data;

	vault = TANGLE_VAULT(data_vault);
	tangle_vault_get(vault, 4,
                  CLUTTER_TYPE_ACTOR, &actor,
                  G_TYPE_STRING, &speech,
                  G_TYPE_POINTER,&user_callback,
                  G_TYPE_POINTER,&data);

	finalize(CLUTTER_ACTOR(actor_2),speech);
	user_callback(data);

	return FALSE;
}



static gboolean cancel_clicked (ClutterTexture *actor_2, ClutterEvent *event, gpointer idle_speech) {
	printf("cancel selected\n");
	finalize(CLUTTER_ACTOR(actor_2),(gchar*)idle_speech);

	return FALSE;
}


//Color for trasparency layer over all but dialog.
static ClutterColor transparency_color = { 0, 0, 0, 0xcc };
static ClutterColor *get_transparency_color(){ return &transparency_color; }

void trafficlight_dialog(ClutterActor* parent, gchar* mentor_speech, gchar* mentor_idle_speech, TrafficligthCallback yes_clicked, gpointer data_for_yes,  TrafficligthCallback no_clicked, gpointer data_for_no){
	if (reserved)
		return;
	reserved = TRUE;
	gchar* previous_idle_speech = g_strdup_printf("%s",jammo_mentor_get_idle_speech(jammo_mentor_get_default()));
	
	jammo_mentor_speak(jammo_mentor_get_default(),mentor_speech);
	jammo_mentor_set_idle_speech(jammo_mentor_get_default(),mentor_idle_speech);

	ClutterActor* container_for_trafficlights = tangle_widget_new(); //TANGLEWIDGET

	ClutterActor* box=clutter_rectangle_new_with_color (get_transparency_color());
	clutter_actor_set_size (box, 800,480);
	clutter_actor_set_position (box, 0, 0); 
	clutter_actor_show (box);
	clutter_actor_set_reactive(box,TRUE);
	clutter_container_add_actor (CLUTTER_CONTAINER (container_for_trafficlights), box);

	
	TangleVault* vault;
	vault = tangle_vault_new(4,
                         CLUTTER_TYPE_ACTOR, container_for_trafficlights,
                         G_TYPE_STRING, previous_idle_speech,
                         G_TYPE_POINTER, no_clicked,
                         G_TYPE_POINTER, data_for_no);

	ClutterActor* no_button;
	no_button=clutter_texture_new_from_file("/opt/jammo/buttons/no-button.png", NULL);
	g_object_set(no_button, "x", 303.0,  "y", 60.0, NULL);
	clutter_container_add(CLUTTER_CONTAINER(container_for_trafficlights), no_button, NULL);
	clutter_actor_set_reactive(no_button,TRUE);
	g_signal_connect (no_button, "button-press-event", G_CALLBACK(handle_click), vault);



	TangleVault* vault2;
	vault2 = tangle_vault_new(4,
                         CLUTTER_TYPE_ACTOR, container_for_trafficlights,
                         G_TYPE_STRING, previous_idle_speech,
                         G_TYPE_POINTER, yes_clicked,
                         G_TYPE_POINTER, data_for_yes);

	ClutterActor* yes_button;
	yes_button=clutter_texture_new_from_file("/opt/jammo/buttons/yes-button.png", NULL);
	g_object_set(yes_button, "x", 300.0,  "y", 241.0, NULL);
	clutter_container_add(CLUTTER_CONTAINER(container_for_trafficlights), yes_button, NULL);
	clutter_actor_set_reactive(yes_button,TRUE);
	g_signal_connect (yes_button, "button-press-event",  G_CALLBACK(handle_click), vault2);


	ClutterActor* cancel_button;
	cancel_button=clutter_texture_new_from_file("/opt/jammo/cross_icon.png", NULL);
	g_object_set(cancel_button, "x", 719.0,  "y", 16.0, NULL);
	clutter_container_add(CLUTTER_CONTAINER(container_for_trafficlights), cancel_button, NULL);
	clutter_actor_set_reactive(cancel_button,TRUE);
	g_signal_connect (cancel_button, "button-press-event", G_CALLBACK (cancel_clicked),(gpointer)previous_idle_speech);

	clutter_container_add(CLUTTER_CONTAINER(parent),container_for_trafficlights, NULL);
}
