/**chum.h is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui and it handles config file reading
*/


#ifndef _CHUM_H_
#define _CHUM_H_

#include "../meam/jammo-sample.h" //We want return Sample*
#include "../meam/jammo-editing-track.h"
#include <clutter/clutter.h>

/**
 * Defines default folders.
 */

#define DATA_DIR "/opt/jammo"
#define SEQUENCER_DIR "/opt/jammo/sequencer"
#define STARTMENU_DIR "/opt/jammo/startmenu"
#define GAMESMENU_DIR "/opt/jammo/gamesmenu"
#define COMMUNITYMENU_DIR "/opt/jammo/communitymenu"
#define THEMES_DIR DATA_DIR "/themes"
#define SONGS_DIR DATA_DIR "/songs"

//N900 has very limited /tmp space.
#ifdef N900
#define JAMMO_DIRECTORY "/home/user/MyDocs/jammo"
#else
#define JAMMO_DIRECTORY "/tmp/jammo"
#endif

#define COMPOSITIONS_DIRECTORY JAMMO_DIRECTORY "/compositions"
#define SINGINGS_DIRECTORY JAMMO_DIRECTORY "/singings"

/* This is temporary location: move to jammo.h or similar. */
ClutterActor* jammo_get_actor_by_id(const gchar* id);

const char* chum_get_current_song();
void chum_set_current_song(const gchar* song);

int chum_get_state_of_chum();
void chum_set_state_of_chum(int state);

const char* chum_get_selected_language();
void  chum_set_selected_language(const gchar* language);

void chum_set_duetto(gboolean b);
gboolean chum_get_duetto();

gboolean chum_is_easy_game();
void chum_set_easy_game(gboolean b);

void chum_hide_this_tangle_actor (ClutterActor *actor, gpointer none);
#endif  /*  _CHUM_H_  */
