/**sequencer.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is the sequencer.
 */
#include <tangle.h>
#include <glib-object.h>
#include "startmenu.h"
#include "config.h"
#include "../chum/chum.h"

ClutterActor* startmenu_group=NULL;
gboolean startmenu_is_ready = FALSE;

//button release animation
static gboolean buttonrelease_animate(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	ClutterActor *button = CLUTTER_ACTOR(clutter_animation_get_object(CLUTTER_ANIMATION(actor)));
	clutter_actor_animate (button,          /* the actor to animate */
			CLUTTER_LINEAR, /* the easing mode */
			100,           /* the duration of the animation */
			"scale-gravity",CLUTTER_GRAVITY_CENTER,
			"scale-x", 1.0, /* final horizontal scaling factor */
			"scale-y", 1.0, /* final vertical scaling factor */
			NULL);
	return TRUE;
}


//button press animation
static gboolean buttonpress_animate(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	ClutterAnimation * anim = clutter_actor_animate(actor,
			CLUTTER_LINEAR, /* the easing mode */
			100,           /* the duration of the animation */
			"scale-gravity",CLUTTER_GRAVITY_CENTER,
			"scale-x", 0.80, /* final horizontal scaling factor */
			"scale-y", 0.80, /* final vertical scaling factor */
			NULL);
	g_signal_connect(anim, "completed", G_CALLBACK(buttonrelease_animate), NULL);
	return TRUE;
}

//go to sequencer
static gboolean goto_sequencer(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	buttonpress_animate(actor, event, data);
	start_sequencer();
	return TRUE;
}

//go to gamesmenu
static gboolean goto_gamesmenu(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	buttonpress_animate(actor, event, data);
	start_gamesmenu();
	return TRUE;
}

//go to communitymenu
static gboolean goto_communitymenu(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	buttonpress_animate(actor, event, data);
	start_communitymenu();
	return TRUE;
}
void init_startmenu() {}

gboolean start_startmenu(gpointer data)
{
	ClutterActor* mainview;
	ClutterActor* view;

	mainview = jammo_get_actor_by_id("main-views-widget"); //No drawing on stage anymore, use this.
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), tangle_actor_hide_animated, NULL);
	
	view = tangle_view_new();   //This can be defined in json too.
	clutter_container_add(CLUTTER_CONTAINER(mainview), view, NULL);
	clutter_actor_show(view);
	
	ClutterActor* stage = view;

	startmenu_is_ready = FALSE;
	
	startmenu_group = config_get_configured_actor("startmenu","startmenu_view");
	clutter_actor_hide(startmenu_group);

	ClutterActor * start_games = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(startmenu_group), "start_games");

	ClutterActor * start_sequencer = clutter_container_find_child_by_name(
				CLUTTER_CONTAINER(startmenu_group), "start_sequencer");

	ClutterActor * start_community = clutter_container_find_child_by_name(
				CLUTTER_CONTAINER(startmenu_group), "start_community");

	ClutterActor * mentor = clutter_container_find_child_by_name(
				CLUTTER_CONTAINER(startmenu_group), "mentor");

	buttonpress_animate(CLUTTER_ACTOR(start_games), NULL, NULL);
	buttonpress_animate(CLUTTER_ACTOR(start_sequencer), NULL, NULL);
	buttonpress_animate(CLUTTER_ACTOR(start_community), NULL, NULL);
	buttonpress_animate(CLUTTER_ACTOR(mentor), NULL, NULL);

	g_signal_connect(CLUTTER_ACTOR(start_sequencer), "button_press_event", G_CALLBACK(goto_sequencer), NULL);
	g_signal_connect(CLUTTER_ACTOR(start_games), "button_press_event", G_CALLBACK(goto_gamesmenu), NULL);
	g_signal_connect(CLUTTER_ACTOR(start_community), "button_press_event", G_CALLBACK(goto_communitymenu), NULL);
	g_signal_connect(CLUTTER_ACTOR(mentor), "button_press_event", G_CALLBACK(buttonpress_animate), NULL);


	clutter_actor_set_reactive(start_games, TRUE);
	clutter_actor_set_reactive(start_sequencer, TRUE);
	clutter_actor_set_reactive(start_community, TRUE);
	clutter_actor_set_reactive(mentor, TRUE);

	clutter_container_add_actor(CLUTTER_CONTAINER(stage), CLUTTER_ACTOR(startmenu_group));

	printf("Startmenu initialization complete!\n");
	startmenu_is_ready = TRUE;
	clutter_actor_show (CLUTTER_ACTOR(startmenu_group));
	return FALSE;
}
gboolean startmenu_is_initialized()
{
	return startmenu_is_ready;
}
