/**instrument_testing.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
It is used to test virtual instruments.
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <clutter/clutter.h>
#include <pthread.h>

#include "jammo-texture.h"
#include "clutter_jammo.h"
#include "../chum/chum.h" //THEMES_DIR
#include "object.h"
#include "config.h"

#include "../meam/meam.h"  //FIXME. get rid of this.

#include "../gui_terminal/instrument_mode_joystick.h"



static void back_to_game_selection(){
chum_stop_sequencer();
show_game_selection();
}


//this is same than virtual-instrument
static gchar notenames[] ={'c','1','d','2','e','f',
			   '3','g','4','a','5','b'};

static void instrument_click(ClutterActor *actor, ClutterEvent *event, gpointer data){
int octave=GPOINTER_TO_INT(data) / 100;
int note=GPOINTER_TO_INT(data)-100*octave;
char notename=notenames[note];

chum_toggle_note_on_octave(notename,octave);

}





void *start_reading_joystick(){
virtual_instrument_mode_joystick();
pthread_exit(NULL);
}


#include <fcntl.h> //we might check some files
void start_test_instrument(ClutterActor *actor, ClutterEvent *event, gpointer data){

    int type=GPOINTER_TO_INT(data);

    g_list_foreach(get_mainPipeline()->tracks, (GFunc)remove_track, NULL);
    create_new_empty_track(); //for objects
    create_new_empty_track(); //for backing track

    //Now there are long silence and then bling.
    chum_add_new_sample_to_track_nth_slot(0,g_strdup_printf("%s/themes/forest/loop1.wav",DATA_DIR),39);

/*  //add backing_track from theme 4 (maybe rockcity)
    gchar*filepath1 = g_strdup_printf("%s/%s/backing_track.wav", THEMES_DIR, chum_get_theme_folder(4));
    int fd = open(filepath1,O_RDONLY);
    if (fd != -1)
	meam_seq_add_new_sample_to_track(1,filepath1,0); //trac-number,file,starting position
*/

    //make instrument track
    chum_add_instrument_track(type);


  ClutterActor* stage =main_getStage();

  ClutterActor* box=clutter_rectangle_new_with_color (get_blue_color());
  clutter_rectangle_set_border_color(CLUTTER_RECTANGLE(box),get_blue_color());
  clutter_rectangle_set_border_width(CLUTTER_RECTANGLE(box),1);
  clutter_actor_set_size (box, 800,480);
  clutter_actor_set_position (box, 0, 0); 
  clutter_actor_show (box);
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), box);
  clutter_actor_set_reactive(box, TRUE);

  //regarding what instrument we are using, make boxes. FIXME this is very ad-hoc.
  int min_j,max_j;
  if (type==0) {
      min_j=3;
      max_j=7;
  } else if (type==1) {
    min_j=1;
      max_j=2;
  }else if (type==2) {
    min_j=2;
      max_j=6;
  } else {
    min_j=0;
      max_j=8;
  }


  int i;
  int j;
  // width / notes = 800/12 =66
  // height / octaves = 480/8 = 60
  for (i=0;i<12;i++) {
    for (j=min_j;j<max_j;j++) {
      if (  type==0 && j==6 && i>0)                //Flute doesn't have these notes
          continue;
      if ( (type==1 && i==1) || (type==1 && i==3)) //Drumkit doesn't have these notes 
          continue;
      if (  type==2 && j==5 && i>0)                //Ud doesn't have these notes
          continue;
      ClutterActor* box=clutter_rectangle_new_with_color (get_transparency_color());
      clutter_rectangle_set_border_color(CLUTTER_RECTANGLE(box),get_dark_color());
      clutter_rectangle_set_border_width(CLUTTER_RECTANGLE(box),1);
      clutter_actor_set_size (box, 66, 60);
      clutter_actor_set_position (box, 66*i, 60*j); 
      clutter_actor_show (box);
      clutter_container_add_actor (CLUTTER_CONTAINER (stage), box);
      clutter_actor_set_reactive(box, TRUE);
      g_signal_connect (box, "button-press-event", G_CALLBACK (instrument_click),GINT_TO_POINTER(j*100+i));
    }
  }

  chum_play_sequencer();

ClutterActor *s1 = config_get_configured_actor(NULL,"house");
clutter_container_add_actor (CLUTTER_CONTAINER (stage), s1);
clutter_actor_set_position (s1, 720, 5); 
clutter_actor_set_size (s1, 66, 60);
clutter_actor_show (s1);
clutter_actor_set_name(s1, "house");
clutter_actor_set_reactive(s1, TRUE);
g_signal_connect (s1, "button-release-event", G_CALLBACK (back_to_game_selection),NULL);
}




static void slider_motion(ClutterActor *actor, ClutterEvent *event, gpointer data){
gfloat x_release, y_release;
clutter_event_get_coords (event, &x_release, &y_release);
//printf("move: X=%f\n",x_release);
meam_slider_freq((int)x_release);
}

static void slider_press(ClutterActor *actor, ClutterEvent *event, gpointer data){
gfloat x_release, y_release;
clutter_event_get_coords (event, &x_release, &y_release);
//printf("Press: X=%f\n",x_release);
meam_slider_freq((int)x_release);
meam_slider_state(TRUE);
}


static void slider_release(ClutterActor *actor, ClutterEvent *event, gpointer data){
gfloat x_release, y_release;
clutter_event_get_coords (event, &x_release, &y_release);
//printf("Release: X=%f\n",x_release);
meam_slider_state(FALSE);
}


void start_slider(ClutterActor *actor, ClutterEvent *event, gpointer data){
printf("Slider\n");
  g_list_foreach(get_mainPipeline()->tracks, (GFunc)remove_track, NULL);
    create_new_empty_track(); //for objects
    create_new_empty_track(); //for backing track

    //Now there are long silence and then bling.
    chum_add_new_sample_to_track_nth_slot(0,g_strdup_printf("%s/themes/forest/loop1.wav",DATA_DIR),39);

/*  //add backing_track from theme 4 (maybe rockcity)
    gchar*filepath1 = g_strdup_printf("%s/%s/backing_track.wav", THEMES_DIR, chum_get_theme_folder(4));
    int fd = open(filepath1,O_RDONLY);
    if (fd != -1)
	meam_seq_add_new_sample_to_track(1,filepath1,0); //trac-number,file,starting position
*/

    //make instrument track
    chum_add_instrument_track(3);


 ClutterActor* stage =main_getStage();

      ClutterActor* box=clutter_rectangle_new_with_color (get_blue_color());
      clutter_rectangle_set_border_color(CLUTTER_RECTANGLE(box),get_blue_color());
      clutter_rectangle_set_border_width(CLUTTER_RECTANGLE(box),1);
      clutter_actor_set_size (box, 800,480);
      clutter_actor_set_position (box, 0, 0); 
      clutter_actor_show (box);
      clutter_container_add_actor (CLUTTER_CONTAINER (stage), box);
      clutter_actor_set_reactive(box, TRUE);
      
      g_signal_connect (box, "button-press-event", G_CALLBACK (slider_press),NULL);      
      g_signal_connect (box, "button-release-event", G_CALLBACK (slider_release),NULL);
      g_signal_connect (box, "motion-event", G_CALLBACK (slider_motion),NULL);


  chum_play_sequencer();
ClutterActor *s1 = config_get_configured_actor(NULL,"house");
clutter_container_add_actor (CLUTTER_CONTAINER (stage), s1);
clutter_actor_set_position (s1, 720, 5); 
clutter_actor_set_size (s1, 66, 60);
clutter_actor_show (s1);
clutter_actor_set_name(s1, "house");
clutter_actor_set_reactive(s1, TRUE);
g_signal_connect (s1, "button-release-event", G_CALLBACK (back_to_game_selection),NULL);
    }


