/**button.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui and it is about buttons.
Buttons can be clicked, but not dragged.
*/

#include "clutter_jammo.h"
#include "config.h"
#include "object.h"
#include <pthread.h>
#include <clutter/clutter.h>
#include <string.h>

#include "../chum/chum.h"

#include "clutter_jammo.h"



/*
Not implemented yet.
*/
void do_help_button_press(){
    printf("help pressed\n");

chum_get_all_slot_info(0);
    //testing things:
    /*
    set_track_speed(0, 10);
    */

    /*guint64 length1;
    guint64 length2= count_track_endtime(0,&length1);

    g_print ("Length1: %" GST_TIME_FORMAT " \n", GST_TIME_ARGS (length1)); 
    g_print ("Length2: %" GST_TIME_FORMAT " \n", GST_TIME_ARGS (length2)); 
    */
}


void do_back_button_press(){
  chum_stop_sequencer();
  chum_go_back();
}


/**
 * Button-press function for play_button 
 */
void do_play_button_press()  {
//this should be pause (not implemented), fix.
chum_play_sequencer();
}


void do_mobikid_next_button_press(){
chum_go_next();
}


/**
 * this is called when mouse is moving or mouse is clicked over button.
 *
 * @param		actor			actor for behaviour
 * @param		event			motion / press
 * @param		behaviour		behaviour which is used
 */

/*
2009-10-10:
This was used to identify different buttons.
g_object_get(G_OBJECT(actor), "name", &command_name, NULL);
Names are in data/config.json and this worked on PC, but in N900
'get(name)' results filename !
So we use id. FIXME.

*/
void button_mouse_behaviour(ClutterActor* actor,  ClutterEvent *event, ClutterBehaviour* behaviour) {

      //regardless of event type, start behaving.
      ClutterAlpha* alpha;
      ClutterTimeline* timeline;
      if(behaviour != NULL && CLUTTER_IS_BEHAVIOUR(behaviour)) {
	  alpha = clutter_behaviour_get_alpha(behaviour);
	  timeline = clutter_alpha_get_timeline(alpha);
	  clutter_timeline_start(timeline);
      }

      if (event->type == CLUTTER_BUTTON_PRESS){
          printf("button press\n");
	  gchar *command_name;
	  g_object_get(G_OBJECT(actor), "name", &command_name, NULL);
	  printf("name of button '%s'\n",command_name);
          

          
	  if (command_name==NULL) return;
  
	  //All possible json-command must be listed and hooked here.
          

	  if(strcmp (command_name, "play")==0)
	      do_play_button_press();
	  else if(strcmp (command_name, "help")==0)
	     do_help_button_press();
	  else if((strcmp (command_name, "back") ==0 ) || (strcmp (command_name, "mobikid-back") ==0))
	      do_back_button_press();
	  else if(strcmp (command_name, "mobikid-next")==0)
	      do_mobikid_next_button_press();

      }
}


/**
This functions loads background-image for every themes and make one button-image 
using all these backgrounds.
Used colors are from clutter_jammo.h
*/
ClutterActor* button_create_theme_selection_button (){

  ClutterActor* objects_group;
  objects_group = clutter_group_new();


  gint number_of_themes =chum_get_number_of_themes();
  g_return_val_if_fail(THEMES_DIR,NULL);
  GError* error = NULL;
  GDir* dir = g_dir_open (THEMES_DIR, 0, &error);
  if (error) {
      g_warning ("g_dir_open() failed: %s\n", error->message);
      g_clear_error (&error);
      return NULL;
  }

  int i=0;
  const gchar* filename = NULL;
  const gchar* theme_folders[10]; //use dynamic value. FIX
  while ((filename = g_dir_read_name(dir))) {
      if (filename[0]!='.') { //do not count hidden files (folders)
	    i++;
	    theme_folders[i]=filename;
      }
  }




  for (i=1;i<number_of_themes+1;i++){
    ClutterActor*  actor= load_background(chum_get_theme_folder(i));
    //if (actor==NULL)   printf("Background is NULL\n");

    //there are empty white area bottom of background:
    //first make image taller and then clip from bottom

    clutter_actor_set_height (actor,700);
    clutter_actor_set_clip (actor,800/number_of_themes,0,800/number_of_themes,480);
    clutter_actor_set_scale (actor,0.1,0.1);

    clutter_actor_set_position (actor,80/number_of_themes*(i-2),0);		

    clutter_container_add_actor (CLUTTER_CONTAINER (objects_group), actor);
    clutter_actor_show (actor);
    clutter_actor_set_reactive(actor, TRUE);
    clutter_actor_set_name(actor, "back");
    g_signal_connect (actor, "button-press-event", G_CALLBACK (button_mouse_behaviour),NULL);  

    //make vertical bar between each theme
    ClutterActor* line=clutter_rectangle_new_with_color (get_transparency_color());
    clutter_rectangle_set_border_color(CLUTTER_RECTANGLE(line),get_dark_color());
    clutter_rectangle_set_border_width(CLUTTER_RECTANGLE(line),2);
    clutter_actor_set_size (line, 2, 48);
    clutter_actor_set_position (line, 80/number_of_themes*(i), 0);
    clutter_actor_show (line);
    clutter_container_add_actor (CLUTTER_CONTAINER (objects_group), line);
  }

  //frame all over
  ClutterActor* actor=clutter_rectangle_new_with_color (get_transparency_color());
  clutter_actor_set_size (actor, 80, 48);
  clutter_actor_set_position (actor, 0, 0);
  clutter_rectangle_set_border_color(CLUTTER_RECTANGLE(actor),get_dark_color());
  clutter_rectangle_set_border_width(CLUTTER_RECTANGLE(actor),2);
  clutter_actor_show (actor);  
  clutter_container_add_actor (CLUTTER_CONTAINER (objects_group), actor);


  clutter_actor_set_position (objects_group,700,5);

  return objects_group;
}

/**
This function loads all buttons and add them to 
given objects_group.
*/
void button_create_buttons (ClutterActor* objects_group) {
	ClutterActor* actor;
	gint i, k;
	gchar* buffer;
	int number_of_buttons = count_actors_in_script("button-"); 

	for(i=0; i < number_of_buttons; ++i) {
		k = i + 1;
		buffer = g_strdup_printf("button-%d", k);
		actor = config_get_configured_actor(NULL,buffer);
		
		clutter_container_add_actor(CLUTTER_CONTAINER(objects_group), actor);
		clutter_actor_set_reactive(actor, TRUE);
	}

//And add dynamically created back-button:
  clutter_container_add_actor (CLUTTER_CONTAINER (objects_group), button_create_theme_selection_button());
}
