/**chum.h is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui and it handles config file reading
*/


#ifndef _CHUM_H_
#define _CHUM_H_

#include "../meam/sequencer/sample.h" //We want return Sample*

/**
 * Defines default folders.
 */
/*
#define THEMES_DIR "../share/jammo/themes"
#define SONGS_DIR "../share/jammo/songs"
*/
//In n900 we should use /opt for data files. And maybe this is not bad place for all systems?

#define DATA_DIR "/opt/jammo"

#define THEMES_DIR "/opt/jammo/themes"
#define SONGS_DIR "/opt/jammo/songs"


void remove_track (Track *trc); //FIXME. this is not right place for this

void chum_report_melodic_contour(float freq);

int chum_get_state_of_chum();
void chum_start_chum(int argc, char** argv);
void chum_start_jammo_main_loop();

void chum_go_back();
void chum_go_next();
void chum_go_screen(int screen_number);
void chum_change_to_game(int game_number);
void chum_change_to_theme(int theme_number);

int chum_get_current_theme();
const char* chum_get_theme_folder(int index);
int chum_get_number_of_themes();

int chum_get_current_song();
const char* chum_get_song_folder(int index);
void chum_change_to_song(int song_number);

void chum_play_one_sample(char* filename);
void chum_stop_one_sample();


void chum_stop_sequencer();
void chum_play_sequencer();
Sample *chum_add_new_sample_to_track(int track_number, const gchar srcLocation[], guint64 startTime);
Sample *chum_add_new_sample_to_track_nth_slot(int track_number, const gchar srcLocation[], guint slot);
void chum_remove_sample_from_slot(guint track_number,int slot);

void chum_get_all_slot_info(int track_number);

void chum_add_instrument_track(int type);
void chum_state_of_note(gboolean state, char note);
void chum_toggle_note(char note);
void chum_toggle_note_on_octave(char note, int octave);
void chum_print_note_table();

void chum_octave_up();
void chum_octave_down();

void chum_get_duration_of_song(guint64 *value);
GList* chum_get_all_songs();

guint chum_get_meter_of_track(int track_number);
guint chum_get_tempo_of_track(int track_number);

#endif  /*  _CHUM_H_  */
