/*
 * gems_definitions.h
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu, Lappeenranta University of Technology
 *
 * Authors: Jussi Laakkonen <jussi.laakkonen@lut.fi>
 *	    Tommi Kallonen  <tommi.kallonen@lut.fi>
 */
 
 
#ifndef __GEMS_DEFINITIONS_
#define __GEMS_DEFINITIONS_

// Event list operation types for CHUM
// with these CHUM can specify what to do with a midi or slider event list
typedef enum
{
	GEMS_EVENTLIST_REPLACE
} GemsEventListOperation;

typedef enum
{
	GEMS_GROUP_CONTROL_NOT_IN_GROUP,
	GEMS_GROUP_CONTROL_GROUP_NOT_ACTIVE,
	GEMS_GROUP_CONTROL_GROUP_FULL,
	GEMS_GROUP_CONTROL_ALREADY_IN_GROUP,
	GEMS_GROUP_CONTROL_GROUP_LOCKED,
	GEMS_GROUP_CONTROL_GROUP_ADD_ERROR,
	GEMS_GROUP_CONTROL_NOT_GROUP_OWNER
} GemsGroupControlCallbackType;

typedef enum
{
	GEMS_GAME_JOINED_PAIR_COMPOSITION
} GemsGameCallbackType;

#define ERROR_GROUP_NOT_ACTIVE_TYPE 10008
#define ERROR_INVALID_GROUP_ID_TYPE 10009
#define ERROR_GROUP_FULL_TYPE 10010
#define ERROR_ALREADY_IN_GROUP_TYPE 10011
#define ERROR_GROUP_LOCKED_TYPE 10012
#define ERROR_GROUP_ADD_ERROR_TYPE 10013
#define ERROR_NOT_GROUP_OWNER_TYPE 10014

#define JAMMO_NETWORK_BUFFER_MAX_SIZE 2048
// TODO change to use sha256 -> 32 bytes
#define JAMMO_MESSAGE_DIGEST_SIZE 20 // 160 bit SHA1
// If no reply received the request is being sent every X seconds
#define PROFILE_REQUEST_INTERVAL 5.00
// Group info request interval, 15 seconds 
#define GROUP_REQUEST_INTERVAL 15.00
// Group adverting interval, 3 seconds
#define GROUP_ADVERT_INTERVAL 3.00
// Limit for removing group (from last advert)
#define GROUP_REMOVE_LIMIT 4*GROUP_ADVERT_INTERVAL
// Limit for removing from rejected list - 5 min
#define REJECTED_LIST_REMOVE_LIMIT 300.00
// Limit for errorous connections
#define CONNECTION_ERRORLIMIT 5
// Basic interval for connection attempts, each error increases this by 1 second
#define CONNECTION_INTERVAL 5.00
// Idle limit for connecting devices (in jammo service verification phase)
#define IDLE_CONNECTION_LIMIT 10.00
// High and low for random connection delay
#define AC_DELAY_HIGH 1.50
#define AC_DELAY_LOW 0.10
// Max size for group
#define GROUP_MAX_SIZE 4
// Group not assigned
#define FREE_SLOT 0
// Group not active
#define NOT_ACTIVE 0
// Timer limit for teacher profile requests
#define TEACHER_PROFILE_REQUEST_LIMIT 2.00
#define TEACHER_PROFILE_REQUEST_MAX_COUNT 2

// Used as return values when searching connections from various lists
#define NOT_IN_LIST 0
#define IN_INITIALIZED_LIST 1
#define IN_JAMMO_SERVICE_LIST 2
#define IN_CONNECTING_LIST 3
#define IN_CONNECTED_LIST 4
#define IN_REJECTED_LIST 5

// Group return velues
#define ADDED_TO_GROUP 0
#define REQUEST_SENT 1
#define ALREADY_IN_GROUP 2
#define CANNOT_ADD 3
#define REMOVED_OK 4
#define NOT_IN_GROUP 5
#define GROUP_LOCKED 6
#define CANNOT_CONNECT_TO_OWNER 7
#define NO_OWNER 8
#define NO_MATCHING_GROUP 9
#define GROUP_FULL 10
#define REQUEST_NOT_SENT 11

// Group status
#define IN_GROUP 111
#define JOINING 112
#define LEAVING 113
// NOT_ACTIVE in group = not in group

// Error type
#define ERROR_CONNECTION 21
#define ERROR_REJECTED 22
#define ERROR_ALREADY_CONNECTED 23

/* NETWORK DEFINITIONS */

#define JAMMO_PACKET_PRIVATE 10
#define JAMMO_PACKET_GROUP 11
#define JAMMO_PACKET_ADMIN 12

/*-----------  Service ID's ----------*/
#define JAMMO_SERVICE_ID 100
#define AA_SERVICE_ID 101
#define PROFILE_SERVICE_ID 102
#define GROUP_SERVICE_ID 103
#define COLLABORATION_SERVICE_ID 104
#define SONGBANK_SERVICE_ID 105
#define DATATRANSFER_SERVICE_ID 106
#define MENTOR_SERVICE_ID 107
#define CONTROL_SERVICE_ID 108
#define PROBE_SERVICE_ID 109
#define TEACHER_PROFILE_SERVICE_ID PROFILE_SERVICE_ID


/*-----------  Service Names ----------*/
#define JAMMO_SERVICE_NAME "JamMo"
#define AA_SERVICE_NAME JAMMO_SERVICE_NAME ":AuthenticationAndAuthorization"
#define PROFILE_SERVICE_NAME JAMMO_SERVICE_NAME ":Profile"
#define GROUP_SERVICE_NAME JAMMO_SERVICE_NAME ":GroupManagement"
#define COLLABORATION_SERVICE_NAME JAMMO_SERVICE_NAME ":Collaboration"
#define SONGBANK_SERVICE_NAME JAMMO_SERVICE_NAME ":Songbank"
#define DATATRANSFER_SERVICE_NAME JAMMO_SERVICE_NAME ":DataTransfer"
#define MENTOR_SERVICE_NAME JAMMO_SERVICE_NAME ":Mentor"
#define CONTROL_SERVICE_NAME JAMMO_SERVICE_NAME ":Control"
#define PROBE_SERVICE_NAME JAMMO_SERVICE_NAME ":ProbeVerification"

// Generic teacher server name
#define TEACHER_SERVICE_NAME JAMMO_SERVICE_NAME ":TeacherServer"
// Teacher profile service
#define TEACHER_PROFILE_SERVICE_NAME TEACHER_SERVICE_NAME ":Profile"



/*-----------  Command types ----------*/

// ERROR
#define ERROR_MSG 10000
#define ERROR_NO_ERROR "No error" // When error id is invalid

// JAMMO SERVICE
#define CONNECT_REQ 1001
#define VERSION_REQ 1002
#define VERSION_REPLY 1003
#define CONNECT_REPLY 1004

// AUTHENTICATION & AUTHORIZATION
#define AUTH_CONNECTION 1011
#define GET_CERTIFICATE 1012
#define PUBLISH_CERTIFICATE 1013
#define CERTIFICATE_OK 1014
#define START_PEER_KEY_EXCHANGE 1015
#define KEY_DATA 1016
#define KEY_DATA_REPLY 1017
#define KEY_OK 1018

// PROFILE SERVICE
#define GET_PROFILE 1021
#define PROFILE_PUB 1022
#define PROFILE_FULL 1023
#define GET_PROFILE_PUB 1024
#define GET_PROFILE_FULL 1025
#define REQ_ENC_PROFILE 1026
#define PROFILE_ENC 1027
#define PROFILE_SET_UNAME 1028
#define PROFILE_PASSCHANGED 1029

// GROUP SERVICE
#define REQUEST_MEMBERS 1030
#define OFFER_GROUP 1031
#define REQUEST_GROUP_INFO 1032
#define JOIN_GROUP 1033
#define MEMBER_LIST 1034
#define NEW_MEMBER 1035
#define LEAVE_GROUP 1036
#define REMOVED_FROM_GROUP 1037
#define MEMBER_DROPPED 1038
#define CURRENT_GROUP 1039
#define GROUP_IS_UNLOCKED 1028 // Unused by profile service messages
#define GROUP_IS_LOCKED 1029 // Unused by profile service messages
#define FORCE_GROUP 1065

// COLLABORATION SERVICE
#define ACTION_VI_SINGLE 1040
#define ACTION_CONFIRMED 1041
#define SONG_INFO 1042
#define ACTION_LOOP 1043
#define ACTION_LOOP_SYNC 1044
#define ACTION_MIDI 1045
#define ACTION_SLIDER 1046

#define ADD_LOOP 1048
#define REMOVE_LOOP 1049
#define REPLACE_MIDI_SERIES 1050
#define REPLACE_SLIDER_SERIES 1051

// CONTROL SERVICE
#define CONTROL_MODE 1060
#define CONTROL_OK 1061
#define CONTROL_SET_LOGIN 1062
#define CONTROL_GET_LOGIN 1063
#define CONTROL_REPLY_LOGIN 1064
#define CONTROL_FORCE_LOGIN 1065

// MENTOR SERVICE
#define LOG_MESSAGE 1070

// Group types
#define GROUP_TYPE_PAIR 10311
#define GROUP_TYPE_CHAIN 10312
#define GROUP_TYPE_WS_NON_RT 10313
#define GROUP_TYPE_WS_RT 10314
#define GROUP_TYPE_WS_NET 10315




// Group themes
// TODO define group themes

/*-----------  ERROR MESSAGES ----------*/
#define ERROR_ALREADY_CONNECTED_TYPE 10001
#define ERROR_VERSION_MISMATCH_TYPE 10002
#define ERROR_INVALID_STATE_TYPE 10003
#define ERROR_INVALID_SERVICE_ID_TYPE 10004
#define ERROR_SERVICE_NOT_RUNNING_TYPE 10005
#define ERROR_CONNECTION_REJECTED_TYPE 10006
#define ERROR_NOT_IN_GROUP_TYPE 10007
#define ERROR_GROUP_NOT_ACTIVE_TYPE 10008
#define ERROR_INVALID_GROUP_ID_TYPE 10009
#define ERROR_GROUP_FULL_TYPE 10010
#define ERROR_ALREADY_IN_GROUP_TYPE 10011
#define ERROR_GROUP_LOCKED_TYPE 10012
#define ERROR_GROUP_ADD_ERROR_TYPE 10013
#define ERROR_NOT_GROUP_OWNER_TYPE 10014

#define ERROR_INVALID_ACCESS_TYPE 10036
#define ERROR_NO_PROFILE_FOR_USERNAME_TYPE 10037

#define ERROR_ALREADY_CONNECTED_MSG "Already connected or trying to connect."
#define ERROR_VERSION_MISMATCH_MSG "Versions mismatch."
#define ERROR_INVALID_STATE_MSG "Wrong message in current state."
#define ERROR_INVALID_SERVICE_ID_MSG "Invalid service id."
#define ERROR_SERVICE_NOT_RUNNING_MSG "Service with requested id is not running."
#define ERROR_CONNECTION_REJECTED_MSG "Connection was previously rejected."
#define ERROR_NOT_IN_GROUP_MSG "Not in group."
#define ERROR_GROUP_NOT_ACTIVE_MSG "Group is not active."
#define ERROR_INVALID_GROUP_ID_MSG "Given group id is not valid."
#define ERROR_GROUP_FULL_MSG "Group is full."
#define ERROR_ALREADY_IN_GROUP_MSG "User is already in the active group."
#define ERROR_GROUP_LOCKED_MSG "Group cannot be joined, group is locked."
#define ERROR_GROUP_ADD_ERROR_MSG "Cannot add to group."
#define ERROR_NOT_GROUP_OWNER_MSG "Not the owner of the group."

#define ERROR_INVALID_ACCESS_MSG "Not enough privileges to get full profile"
#define ERROR_NO_PROFILE_FOR_USERNAME_MSG "No profile exists for requested username."

/*----------- PROFILE MANAGER ----------*/
#define JAMMOPROFILE "profiles"
#define PROFILETYPE ".csv"
// new encrypted profile type
#define PROFILE_FILE_EXT ".jpf"

// Minimum compatible profile version
#define JAMMO_PROFILE_VERSION 1

// Profile parameters
#define PROF_PARAM_USERID "userID"
#define PROF_PARAM_USERNAME "username"
#define PROF_PARAM_AUTHLEVEL "authLevel"
#define PROF_PARAM_FIRSTNAME "firstName"
#define PROF_PARAM_LASTNAME "lastName"
#define PROF_PARAM_POINTS "gamePoints"
#define PROF_PARAM_AGE "age"
#define PROF_PARAM_AVATARID "avatarID"
// versions from 1,2,3 ... 
#define PROF_PARAM_VERSION "profileVersion"
#define PROF_PARAM_TYPE	"profileType"

// "Local" profile, only on the device
#define PROF_TYPE_LOCAL 1
// Profile that should be updated either to teacher or to community
#define PROF_TYPE_REMOTE 2

#define PROF_TOKENS 9

#define PROF_DEFAULT_AVATARID 260

// Security - extraction of envelope return values
#define SECURITY_OK 10190
#define SECURITY_CORRUPT_MESSAGE 10191 // hash value in envelope doesn't match the content
#define SECURITY_VERIFY_FAILED 10192 // cannot verify the signature of hash

// authentication returnvalues
#define LOGIN_PROFILE_READ_ERROR -3
#define LOGIN_INVALID_PROFILE -2
#define LOGIN_NO_PROFILE -1
#define LOGIN_OK 0
#define LOGIN_INVALID_PARAMS 1
#define LOGIN_CANNOT_INIT_PASSWD 2
#define LOGIN_CANNOT_INIT_SECURITY 3
#define LOGIN_INVALID_PASSWORD 4
#define LOGIN_PROFILE_HASH_FAIL 5
#define LOGIN_PROFILE_CORRUPT 6
#define CHANGE_USER_OK 0
#define CHANGE_USER_WAITING_PROFILE 1
#define CHANGE_USER_LOGOUT_REQUIRED 2
#define CHANGE_USER_NO_PROFILE -1
#define CHANGE_USER_NO_USERNAME 3

// Profile loading returnvalues
#define PROFILE_LOADED 0
#define PROFILE_READ_FAILURE 1
#define PROFILE_NOT_FOUND 2
#define PROFILE_VERSION_MISMATCH 3
#define PROFILE_RELOAD_FAILED 4
#define PROFILE_RELOAD_FAILED_NOT_AUTHENTICATED 5


// Security vars
#define AES_ROUNDS 5
#define AES_SALT_LENGTH 8
#define PASSLEN 64
#define SHA_HASH_LENGTH 32

// Default strings for games
#define GEMS_EMPTY_SONG_INFO "empty song info"

#endif //__GEMS_DEFINITIONS_
