/*
License: GPLv2, read more from COPYING

This file contains the functionality of JamMo Songs menu.
 */
#include <tangle.h>
#include <glib-object.h>
#include "startmenu.h"
#include <string.h>
#include "community_utilities.h"
#include "../../meam/jammo-sample.h"
#include "jammosongs.h"
#include "../../meam/jammo-recording-track.h"
#include <meam/jammo-meam.h>
#include <meam/jammo-backing-track.h>
#include "single_thread.h"
#include "src/configure.h"
#include "profile_viewer.h"
#include "../../gems/gems_utils.h"
#include "../../cem/cem.h"

static void on_recording_stopped(JammoSequencer* sequencer, gpointer user_data);
static list_type list = {0, 0};
static gboolean isrecording_voice_comment = FALSE;
static gboolean voice_comment_ready = FALSE;
gchar* recording_filename;
JammoSequencer* sequencer;
GList *paramsList = 0;
GList *labelParamsList = 0;


void start_jammosongs(){

	int numberOfSongs = 0;  //this should contain the number of songs in the list

	cem_add_to_log("Starting JamMoSongs", J_LOG_DEBUG);
	
	//clutter_actor_hide(jammo_get_actor_by_id("communitymenu-view"));
	ClutterActor* mainview;
	
	mainview = jammo_get_actor_by_id("main-views-widget");
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
	
	ClutterActor* jammosongs_view = jammo_get_actor_by_id("jammosongs-view");
				

	if(jammosongs_view){

		clutter_actor_show(CLUTTER_ACTOR(jammosongs_view));

		
		if(numberOfSongs > 5)
			list.list = CLUTTER_CONTAINER(jammo_get_actor_by_id("jammosongs-songs-list-scrollable"));	

		else
			list.list = CLUTTER_CONTAINER(jammo_get_actor_by_id("jammosongs-songs-list-unscrollable"));	


		for(int i = 0; i < numberOfSongs; i++){
			add_song_to_list("", i, gems_profile_manager_get_userid(NULL));	
			//TODO: third parameter must be user id of the composer, now we are using default
		}

	ClutterAction *listAction = tangle_actor_get_action_by_type(CLUTTER_ACTOR(list.list), TANGLE_TYPE_SCROLL_ACTION);

	
	
	g_signal_connect_swapped(listAction, "clamp-offset-y", G_CALLBACK(community_autoscroll_to_correct_pos), &list);


	}
	else
		cem_add_to_log("can't find 'jammosongs-view' ", J_LOG_ERROR);
}



gboolean add_song_to_list(char* loopName, int numberOfSongs, guint32 user_id){

	ClutterActor *listImage;
	ClutterContainer *listContainer;
	ClutterActor *reviewButton;
	ClutterActor *avatarBackground;
	ClutterActor *composer;
	ClutterActor *songName;
	ClutterActor *label = 0;
	guint32 avatar_id = 0;
	Avatar avatar = {0,0,0,0};
	profile_view_params *params = malloc(sizeof(profile_view_params));
	show_label_params *labelParams = malloc(sizeof(show_label_params));
	gchar *command;

	paramsList = g_list_append(paramsList, params);
	strcpy(params->parent_view, "jammosongs");
	params->user_id = user_id;

	gchar* listImage_filename = g_strdup_printf("%s/communitymenu/colorbar4.png", DATA_DIR);

	listImage = tangle_texture_new(listImage_filename); //TODO: image color depends on the song

	listContainer = CLUTTER_CONTAINER(clutter_group_new());

	gchar* reviewButton_filename = g_strdup_printf("%s/communitymenu/community_comment_icon.png", DATA_DIR);
	reviewButton = tangle_button_new_with_background_actor(tangle_texture_new(reviewButton_filename));
	
	gchar* avatarBackground_filename = g_strdup_printf("%s/communitymenu/community_avatarbackground_small.png", DATA_DIR);
	avatarBackground = clutter_group_new();	
	clutter_container_add_actor(CLUTTER_CONTAINER(avatarBackground), tangle_texture_new(avatarBackground_filename));
	composer = tangle_button_new_with_background_actor(avatarBackground);		
			
	//TODO: add correct filename	
	gchar * filename = "Name of the song"; // TESTING

	songName = tangle_button_new_with_background_actor(clutter_text_new_with_text(TEXT_NORMAL, "Name of the song"));
	clutter_actor_set_name(songName, filename);


	if(listImage == NULL)
		return FALSE;	

	if(list.listItemHeight == 0)
		list.listItemHeight = clutter_actor_get_height(listImage);

	clutter_container_add_actor(listContainer, listImage);
	
	clutter_actor_set_position(songName, 200, list.listItemHeight/5*2);
	
	clutter_actor_set_position(composer, 20, 0);
	
	avatar_id = gems_profile_manager_get_avatar_id(gems_profile_manager_get_profile_of_user(user_id));
	if (avatar_id == 0)
		avatar_id = 260; //default avatar
		
	community_get_avatar(&avatar, avatar_id);
	community_shrink_and_set_avatar(&avatar, CLUTTER_CONTAINER(avatarBackground));	
	
	clutter_container_add_actor(listContainer, composer);
	
	clutter_container_add_actor(listContainer, songName);

	labelParams->path = g_strdup_printf("%s/label_%d_%s.csv", configure_get_jammo_directory(), user_id, loopName);
	
	command = g_strdup_printf("ls %s 1> /dev/null 2> /dev/null", labelParams->path);
	gchar* label_filename = g_strdup_printf("%s/communitymenu/community_cdlabel_small.png", DATA_DIR);
	
	if(system(command) == 0){
		label = tangle_button_new_with_background_actor(tangle_texture_new(label_filename));
		clutter_actor_set_position(label, 500, list.listItemHeight/3);
		clutter_container_add_actor(listContainer, label);
	}
	labelParamsList = g_list_append(labelParamsList, labelParams);

	g_free(command);
	g_free(label_filename);	

	clutter_actor_set_position(CLUTTER_ACTOR(reviewButton), 700, 15);

	clutter_container_add_actor(listContainer, CLUTTER_ACTOR(reviewButton));
	
	g_signal_connect_swapped(reviewButton, "clicked", G_CALLBACK(review_selected_song), 
				clutter_actor_get_parent(reviewButton));

	g_signal_connect_swapped(songName, "button-press-event", G_CALLBACK(song_name_press_action), songName);
	g_signal_connect_swapped(songName, "button-release-event", G_CALLBACK(song_name_release_action), songName);
	
	if(label != 0){	
		strcpy(labelParams->parentview, "jammosongs");
		g_signal_connect_swapped(label, "clicked", G_CALLBACK(show_song_label), (gpointer)labelParams);
		}	
	
	g_signal_connect_swapped(composer, "clicked", G_CALLBACK(start_profile_view), (gpointer)params);

	clutter_container_add_actor(list.list, CLUTTER_ACTOR(listContainer));
	
	g_free(listImage_filename);	
	g_free(reviewButton_filename);	
	g_free(avatarBackground_filename);	

	if(numberOfSongs <= 6)
		clutter_actor_set_height(CLUTTER_ACTOR(list.list), list.listItemHeight * numberOfSongs);	

	else
		clutter_actor_set_height(CLUTTER_ACTOR(list.list), list.listItemHeight * 6);		

	return TRUE;

}


void review_selected_song(ClutterActor *song){

	GList *children = clutter_container_get_children(list.list);
	GList* messages = NULL;
	//TODO: get messages to list
	message *msg;
	int i;
	//time_t now; //this might be needed later...

	if(isrecording_voice_comment)
		stop_recording();

//NOTE: when creting messages, message structure and variables msg and avatar inside structure
//	must be dynamically allocated


	for(i = 0; i < 3 /*this should be the number of messages*/; i++){
		msg = malloc(sizeof (message));
		
		msg->filepath = 0;

		msg->index = 0; //Index of this comment

		msg->msg = malloc(strlen("Message#1")+sizeof(char));
		sprintf(msg->msg, "Message#%d", i+1);
		msg->user_id = 0; //this should be the user id of the message writer			
		strcpy(msg->title, "");
		strcpy(msg->sender, "Teppo");
		strcpy(msg->time, "21.1.2011 10:09");
		msg->type = TEXT_COMMENT;

		/*if(voice_comment_ready == TRUE){
			strcpy(msg->filepath, g_strdup_printf("%s/last_recorded.ogg",configure_get_jammo_directory()) );
			msg->type = VOICE_COMMENT;
			voice_comment_ready == FALSE;
		}*/
		messages = g_list_append(messages, (gpointer)msg);

		//TODO: Delete last_recorded after sending it to server
	}

	int first = 0;
	
	if(children != NULL){
		
		do{
			if(first == 0)
				first++;
			else	
				children = children->next;
				
		
			if(song == children->data){
				clear_container(list.list);
				ClutterActor* mainview = jammo_get_actor_by_id("main-views-widget");
				clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL);
				start_thread_view(messages, "jammosongs", NULL, 0);
				
				break;
				}
		
		}while(children->next != NULL);
	
	}
	
	g_list_free(children);

}


gboolean end_jammosongs(TangleButton *tanglebutton, gpointer none){

	community_clear_labelparamslist(labelParamsList);

	labelParamsList = 0;

	community_clear_paramslist(paramsList);

	paramsList = 0;

	clear_container(list.list);

	if(isrecording_voice_comment)
		stop_recording();

	if(voice_comment_ready){
		voice_comment_ready = FALSE;
		remove(recording_filename);
	}
   
	if(strcmp(clutter_actor_get_name(CLUTTER_ACTOR(tanglebutton)), "gotocommunity") == 0)
		startmenu_goto_communitymenu(tanglebutton, none);
		
	else
	   startmenu_goto_startmenu(tanglebutton, none);

	return TRUE;
}


/*********************************
Voice comment recording functions
**********************************/

void record_voice_comment(){

	JammoBackingTrack* backing_track;
	JammoRecordingTrack* recording_track;

	gchar* backing_track_filename = g_strdup_printf("%s/voice_comment_backing.wav", DATA_DIR);

	recording_filename = g_strdup_printf("%s/last_recorded.ogg",configure_get_jammo_directory());
	
	jammo_meam_init(NULL, NULL, "jammo_test_duration_cache"); 	
	
	sequencer = jammo_sequencer_new();
	g_signal_connect(sequencer, "stopped", G_CALLBACK(on_recording_stopped), NULL);

	backing_track = jammo_backing_track_new(backing_track_filename);
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(backing_track)); //max length 30s
	
	recording_track = jammo_recording_track_new_with_pitch_detect(recording_filename);
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(recording_track)); 

	g_print("Recording...\n");
	g_print("Max length is 30 seconds.\n");

	isrecording_voice_comment = TRUE;

	jammo_sequencer_play(JAMMO_SEQUENCER(sequencer));
	
	g_free(backing_track_filename);
}

void stop_recording()
{
	isrecording_voice_comment = FALSE;
	voice_comment_ready = TRUE;
	jammo_sequencer_stop(JAMMO_SEQUENCER(sequencer));
}

static void on_recording_stopped(JammoSequencer* sequencer, gpointer user_data) 
{
	g_print("Stopped recording.\n");
	voice_comment_ready = TRUE;
	isrecording_voice_comment = FALSE;
}

void rec_press_action(ClutterActor *song){

	
	GList *children = clutter_container_get_children(list.list);
	GList* messages = NULL;
	//TODO: get messages to list
	//message *msg;//this might be needed later...
	//int i;//this might be needed later...
	//time_t now;//this might be needed later...


//NOTE: when creting messages, message structure and variables msg and avatar inside structure
//	must be dynamically allocated

	
	
	int first = 0;
	
	if(children != NULL){
		
		do{
			if(first == 0)
				first++;
			else	
				children = children->next;
				
		
			if(song == children->data){

				clear_container(list.list);
				ClutterActor* mainview = jammo_get_actor_by_id("main-views-widget");
				clutter_container_foreach(CLUTTER_CONTAINER(mainview), CLUTTER_CALLBACK(tangle_actor_hide_animated), NULL); //TODO: get voice comments of the song
				start_thread_view(messages, "jammosongs-voice", NULL, 0);
				
				break;
				}
		
		}while(children->next != NULL);
	
	}
	
	g_list_free(children);
	/*
	static gboolean isrecording = FALSE;

	if(isrecording == FALSE){
		isrecording = TRUE;
		record_voice_comment();
	}else{
		stop_recording();
		isrecording = FALSE;
	}*/
}
