/*
 * gems_message_functions.h
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu, Lappeenranta University of Technology
 *
 * Authors: Jussi Laakkonen <jussi.laakkonen@lut.fi>
 */
 
#ifndef __GEMS_MESSAGE_FUNCTIONS_
#define __GEMS_MESSAGE_FUNCTIONS_

#include "gems_structures.h"

gems_message* gems_create_error_message(gint16 errortype, gint16 serviceid);

void gems_clear_message(gems_message* message);

gchar* get_errormessage(gint16 errortype);

gems_message* gems_create_message_service_jammo(gint16 type);

gems_message* gems_create_message_service_profile(gint16 type);

gems_message* gems_create_message_profile_request(gint16 type);

gems_message* gems_create_message_group_management_notify(gint16 type, guint32 groupid, guint32 member);

gems_message* gems_create_message_group_management_group_info(gint16 type);

gems_message* gems_create_message_collaboration_action_confirmed();

gems_message* gems_create_message_collaboration_action_vi_single(gint16 type, const gchar png_name[], const gchar wav_name[], guint16 slot);

gems_message* gems_create_message_collaboration_action_song_info(gint16 type, const gchar song_info[]);

gems_message* gems_create_message_collaboration_action_loop(gint16 type, guint loop_id, guint slot);
gems_message* gems_create_message_collaboration_action_loop_sync(GList * list);

gems_message* gems_create_message_collaboration_action_midi_series(gint16 type, gint16 instrument_id, GList * list);
gems_message* gems_create_message_collaboration_action_slider_series(gint16 type, gint16 instrument_id, GList * list);

gems_message* gems_create_message_control_mode(gint16 type, gint16 cntrl_type, gint16 lock_mode);
gems_message* gems_create_message_control_ok(gint16 type);

#endif // __GEMS_MESSAGE_FUNCTIONS
