/**
 * intervalometer
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to tomi.suviola@gmail.com so I can send you a copy immediately.
 *
 * @copyright  Copyright (c) 2010 Tomi Suviola
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

#include <QtGui>
#include <QDebug>
#include <QSettings>

#include "ui_intervalwindow.h"

#include "intervalwindow.h"
#include "plugindialog.h"

IntervalWindow::IntervalWindow(Interval *model) :
        m_model(model)
{
    setWindowTitle(APPNAME);
    QSettings settings;

    ui.setupUi(this);

    bool advanced = m_model->isAdvancedMode();
    ui.horizontalLayout_adv->setEnabled(advanced);
    ui.label_adv->setVisible(advanced);

    connect(m_model, SIGNAL(stopped()), this, SLOT(done()));
    connect(m_model, SIGNAL(started()), this, SLOT(start()));

}

void IntervalWindow::on_pushButtonOnOff_clicked()
{
    bool on = m_model->isRunning();
    if (!on) {
        //update all fields
        on_spinBox_SelfS_valueChanged(m_model->m_SelfS);
        on_spinBox_LongS_valueChanged(m_model->m_LongS);
        on_spinBox_IntS_valueChanged(m_model->m_IntS);
        on_spinBox_Frames_valueChanged(m_model->m_Frames);
        m_model->start();
    } else {
        m_model->stop();
    }
}

void IntervalWindow::on_pushButtonReset_clicked()
{
    ui.pushButtonOnOff->setText(QString("On"));
    m_model->stop();
    m_model->resetSettings();
}

void IntervalWindow::on_pushButtonTrigger_clicked()
{
    m_model->trigger();
}

void IntervalWindow::on_actionAdvanced_triggered()
{
    bool enable = true;
    qDebug() << "advanced";
    m_model->setAdvancedMode(true);

    ui.horizontalLayout_adv->setEnabled(enable);
    ui.label_adv->setVisible(enable);

}

void IntervalWindow::on_actionSimple_triggered()
{
    bool enable = false;
    qDebug() << "simple";
    m_model->setAdvancedMode(false);

    ui.horizontalLayout_adv->setEnabled(enable);
    ui.label_adv->setVisible(enable);
}

void IntervalWindow::on_actionPlugins_triggered()
{
    qDebug() << "plugins";
    QDir pluginsDir = QDir(qApp->applicationDirPath());
    QStringList pluginFileNames;
    PluginDialog dialog(pluginsDir.path(), pluginFileNames, this);
    dialog.exec();

}

void IntervalWindow::on_spinBox_SelfH_valueChanged(int val)
{
    Q_UNUSED(val);
    long time;
    time = ((ui.spinBox_SelfH->value()*60) +
           (ui.spinBox_SelfM->value()))*60 +
           (ui.spinBox_SelfS->value());
    m_model->setSelf(time);
}

void IntervalWindow::on_spinBox_SelfM_valueChanged(int val)
{
    Q_UNUSED(val);
    long time;
    time = ((ui.spinBox_SelfH->value()*60) +
           (ui.spinBox_SelfM->value()))*60 +
           (ui.spinBox_SelfS->value());
    m_model->setSelf(time);
}

void IntervalWindow::on_spinBox_SelfS_valueChanged(int val)
{
    Q_UNUSED(val);
    long time;
    time = ((ui.spinBox_SelfH->value()*60) +
           (ui.spinBox_SelfM->value()))*60 +
           (ui.spinBox_SelfS->value());
    m_model->setSelf(time);
}

void IntervalWindow::on_spinBox_LongH_valueChanged(int val)
{
    Q_UNUSED(val);
    long time;
    time = ((ui.spinBox_LongH->value()*60) +
           (ui.spinBox_LongM->value()))*60 +
           (ui.spinBox_LongS->value());
    m_model->setLong(time);
}

void IntervalWindow::on_spinBox_LongM_valueChanged(int val)
{
    Q_UNUSED(val);
    long time;
    time = ((ui.spinBox_LongH->value()*60) +
           (ui.spinBox_LongM->value()))*60 +
           (ui.spinBox_LongS->value());
    m_model->setLong(time);
}

void IntervalWindow::on_spinBox_LongS_valueChanged(int val)
{
    Q_UNUSED(val);
    long time;
    time = ((ui.spinBox_LongH->value()*60) +
           (ui.spinBox_LongM->value()))*60 +
           (ui.spinBox_LongS->value());
    m_model->setLong(time);
}

void IntervalWindow::on_spinBox_IntH_valueChanged(int val)
{
    Q_UNUSED(val);
    long time;
    time = ((ui.spinBox_IntH->value()*60) +
           (ui.spinBox_IntM->value()))*60 +
           (ui.spinBox_IntS->value());
    m_model->setInt(time);
}

void IntervalWindow::on_spinBox_IntM_valueChanged(int val)
{
    Q_UNUSED(val);
    long time;
    time = ((ui.spinBox_IntH->value()*60) +
           (ui.spinBox_IntM->value()))*60 +
           (ui.spinBox_IntS->value());
    m_model->setInt(time);
}

void IntervalWindow::on_spinBox_IntS_valueChanged(int val)
{
    Q_UNUSED(val);
    long time;
    time = ((ui.spinBox_IntH->value()*60) +
           (ui.spinBox_IntM->value()))*60 +
           (ui.spinBox_IntS->value());
    m_model->setInt(time);
}

void IntervalWindow::on_spinBox_Frames_valueChanged(int val)
{
    m_model->setFrames(val);
}

void IntervalWindow::start()
{
    qDebug() << "got started";
    ui.pushButtonOnOff->setText(QString("Off"));
}

void IntervalWindow::done()
{
    qDebug() << "got done";
    ui.pushButtonOnOff->setText(QString("On"));
}

