/**
 * intervalometer
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to tomi.suviola@gmail.com so I can send you a copy immediately.
 *
 * @copyright  Copyright (c) 2010 Tomi Suviola
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

#ifndef CAMERAINTERFACE_H
#define CAMERAINTERFACE_H

#include <QtPlugin>
#include <QString>

class CameraInterface
{
public:
    virtual ~CameraInterface() {}
    virtual QString name() = 0;
    virtual void open() = 0;
    virtual void close() = 0;
    virtual void shutter(const bool open) = 0;
    virtual void focus(const bool open) = 0;
};

QT_BEGIN_NAMESPACE
Q_DECLARE_INTERFACE(CameraInterface,
                    "org.dyndns.tonet.Plugin.CameraInterface/1.0");
QT_END_NAMESPACE

#endif //CAMERAINTERFACE_H
