#!/usr/bin/perl -w

# A simple intervalometer for the Nokia N900.
# Author: Ricardo Mendonca Ferreira - ric@mpcnet.com.br
# http://talk.maemo.org/showthread.php?t=38275

# This script requires gstreamer installed on your N900.
# See the link above for more info.
# Run this script on an X Terminal in your device with:
#   perl intervalometer.pl

# 2009.12.17  First version.
# 2009.12.24  Better gstreamer pipeline; more options, with better descriptions.
# ############ rm changes rudolf.mittelmann@artm-friends.at
# 2010-02-22 Try to use better file naming to avoid name clashes - new var jetztstr

use strict;
use POSIX qw(strftime);

#---- CONFIG SECTION ---- [BEGIN] ----

 my ($x,$y) = (1600, 1200);              # image resolution - try (2592, 1968)
 my $cam    = 0;                        # camera: 0 = back, 1 = front
 my $dir    = '/home/user/MyDocs/interval'; # folder where images will be saved
 my $max    = 1;  # total number of images to take
 my $delay  = 0;  # interval between pictures

#---- CONFIG SECTION ----  [END]  ----

die "$dir not found!\n" if !-d $dir;

my $jetztstr = strftime ("%Y-%m-%d_%H-%M-%S_", localtime());

my $gst = "/usr/bin/gst-launch v4l2camsrc device=/dev/video$cam num-buffers=1 ! ffmpegcolorspace ! video/x-raw-yuv,width=$x,height=$y ! jpegenc ! filesink location=";

my $num=0;

print "Intervalometer started - will take $max pictures at $x x $y\n";

while ($num < $max) {
	$num=sprintf'%05d',$num;
	`$gst$dir/$jetztstr$num.jpg`;
	printf "saved %d of %d", $num+1, $max;
	$num++;
	if ($num < $max) { print " - sleeping $delay sec."; sleep $delay; }
        print "\n";
}
