/**
 * intervalometer
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to tomi.suviola@gmail.com so I can send you a copy immediately.
 *
 * @copyright  Copyright (c) 2010 Tomi Suviola
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

#ifndef INTERVAL_H
#define INTERVAL_H

#include <QObject>
#include <QTimer>

#include "camerainterface.h"

QT_BEGIN_NAMESPACE
class QString;
QT_END_NAMESPACE

class Interval : public QObject
{
    Q_OBJECT
public:
    Interval();
    ~Interval();
    void setAdvancedMode(bool advanced);
    bool isAdvancedMode();
    bool isRunning();

    void addTimer(int msec, QObject *receiver, const char *member);

    void setSelf(long val);
    void setLong(long val);
    void setInt(long val);
    void setFrames(long val);

signals:
    void started();
    void stopped();
    void nextEvent(int msec);

public slots:
    void start();
    void stop();
    void trigger();
    void exposure();
    void exposure_off();
    void mlu();
    void mlu_off();
    void focus();
    void done();

    void resetSettings();
    void checkSettings();
private slots:

public:
    bool loadPlugin(const QString &pluginName = QString());

    CameraInterface *intervalInterface;
    bool m_mode;
    bool m_running;
    bool m_cancel;

    QList<QTimer *> m_timers;
    /* settings */
    long m_SelfS;
    long m_IntS;
    long m_IntModS;
    long m_LongModS;
    long m_LongS;
    long m_Frames;
    long m_PreS;
    long m_MluS;
    long m_AlDelay;
    long m_SlDelay;
    long m_Brackets;
    bool m_Bracket;
    bool m_Sleep;
    bool m_ExpSleep;
    bool m_Sound;

  /*globals */
//    bool m_OnOff;
    bool m_ShutterOpen;
    long m_FrameCounter;
    long m_BracketCounter;
    long m_SysTimeOut;
    long m_Timer;
    long m_TimerStart;

};

#endif //INTERVAL_H
