#include "insync.h"
#include "ui_insync.h"
#include "network.h"
#include <QSound>
#include <QFileDialog>
#include <QMessageBox>
#include <stdio.h>
#include <QUrl>
#include <QDesktopServices>


InSync::InSync(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::InSync),
    createSessionID(0),joinSessionID(0),session(0)

{

    ui->setupUi(this);

    progressTimer = new QTimer(this);
    ttlTimer = new QTimer(this);
    ttlTimer->setSingleShot(true);
    ss = new QHttp(HOST,PORT,this);

    audioOutput = new Phonon::AudioOutput(Phonon::MusicCategory, this);
    music = new Phonon::MediaObject(this);
    Phonon::createPath(music,audioOutput);

    connect(progressTimer,SIGNAL(timeout()),this,SLOT(updateProgress()));
    connect(ui->volumeSlider, SIGNAL(sliderReleased()),this,SLOT(updateVolume()));

    connect(ttlTimer,SIGNAL(timeout()),this,SLOT(PlayMP3()));
    connect(ui->progressSlider, SIGNAL(sliderReleased()),this,SLOT(changePosition()));
    connect(ss,SIGNAL(requestFinished(int,bool)),this,SLOT(handleHttpRead(int, bool)));

    connect(ui->playButton,SIGNAL(clicked()),this,SLOT(PlayMP3()));
    connect(ui->stopButton,SIGNAL(clicked()),this,SLOT(StopMP3()));
    connect(ui->browseButton, SIGNAL(clicked()),this,SLOT(Browse()));
    connect(ui->createButton,SIGNAL(clicked()),this,SLOT(createSession()));
    connect(ui->joinButton,SIGNAL(clicked()),this,SLOT(joinSession()));
    connect(ui->startButton,SIGNAL(clicked()),this,SLOT(startCountdown()));

    //get an initial list
    listSessions();

}

InSync::~InSync()
{
     /* also clean up */
    delete ss;
    delete progressTimer;
    delete ttlTimer;
    delete ui;
}


void InSync::PlayMP3(){

    while(!music)
        InSync::Browse();
    if(music->state() == Phonon::PausedState){
        music->play();
        return;
    }
    else if(music->state() == Phonon::PlayingState){
        music->pause();
        return;
    }

  //setup currentFile
  if(ui->lineEdit->text().isEmpty()){
      InSync::Browse();
  }
  music->play();

  /* now run */
  progressTimer->start(200);


}
void InSync::StopMP3()
{
     music->stop();
}

void InSync::Browse()
{
     currentFile = QFileDialog::getOpenFileName(
                    this,
                    "Choose a file",
                    QDesktopServices::storageLocation(QDesktopServices::MusicLocation),
                    "Music (*.mp3 *.wav *.wma)");
       currentFile.prepend("file://");

       music->setCurrentSource(currentFile);

       //Setup UI
       ui->lineEdit->setText(currentFile.toStdString().c_str());
       ui->progressSlider->setMaximum(music->totalTime());

       qint64 time = music->totalTime();
       printf("Total Time: %lld\n",time);
       QTime dispTime(0,(time/60000)%60,(time/1000)%60,0);
       ui->durationLabel->setText(dispTime.toString("mm:ss"));

}

void InSync::updateProgress()
{
    if(!ui->progressSlider->isSliderDown())
        ui->progressSlider->setValue(music->currentTime()); //dont update when seeking

    ui->progressSlider->setMaximum(music->totalTime());
    InSync::updateTime();

}

void InSync::updateTime()
{
    qint64 time = music->currentTime();
    QTime dispTime(0,(time/60000)%60,(time/1000)%60,0);
    ui->currentLabel->setText(dispTime.toString("mm:ss"));

    time = music->totalTime();
       QTime dispTime2(0,(time/60000)%60,(time/1000)%60,0);
       ui->durationLabel->setText(dispTime2.toString("mm:ss"));
}

void InSync::updateVolume()
{
    qreal vol = ui->volumeSlider->value()*1.0 / ui->volumeSlider->maximum();
    audioOutput->setVolume(vol);
}

void InSync::changePosition()
{
    qint64 time = ui->progressSlider->value();
    music->seek(time);
}

void InSync::createSession()
{
    createSessionID=ss->get("http://HOST:PORT?method=createsession"); //produces requestFinished() signal

}

void InSync::joinSession()
{
    QList<QListWidgetItem*> list=ui->listWidget->selectedItems();
    if(list.size()==0){
        listSessions();
        return;
    }
    else if(list.size()!=1){
        printf("Multiple Items Selected");
        return;
    }else{
        printf("Join Session: %s",list.at(0)->text().data());
        joinSessionID=ss->get("http://HOST:PORT?method=joinsession&sessionid=" + list.at(0)->text());
    }
}

void InSync::listSessions()
{
    listSessionID=ss->get( "http://HOST:PORT?method=getsessionssimple");
    //listBTDevices();
    //"getplaybackttl"
    //"initiateplayback"30s timer
}

void InSync::startCountdown()
{
    ss->get("http://HOST:PORT?method=initiateplayback");
    getTTL();
}

void InSync::getTTL()
{
    songttlID=ss->get("http://HOST:PORT?method=getplaybackttl");
}

void InSync::handleHttpRead(int id, bool err)
{
    bool ok;
    if(err){
        perror("Http request failed\n");
        perror(ss->readAll().data());
        return;
    }
    QByteArray data= ss->readAll();

    if(id== createSessionID){
        printf("%s",data.data());

        session=data.toInt(&ok,10); //convert number to right of : to int
        if(ok)
            printf("SESSION ID: %d\n",session);
        listSessions();
    }else if(id == listSessionID){
        ui->listWidget->clear();
        QStringList sessions= QString(data).split('\n');
        for(int i=0;i<sessions.size();i++){
            if(!sessions.at(i).isEmpty()){
                ui->listWidget->addItem(sessions.at(i));
            }
        }
        printf("%s",data.data());

    }else if(id == joinSessionID){
        getTTL();
    }else if(id == songttlID){
        printf("String: %s\n",data.data());
        if(data.toFloat()==0){
            QTimer::singleShot(5000,this,SLOT(getTTL()));
            return;
        } else if (data.toFloat()>0){
            ttlTimer->start(int(data.toFloat()));
            printf("ttl: %f\n",data.toFloat());
        } else { //too late
            PlayMP3();
            qint64 pos=data.toFloat()*-1000000; //ns -> ms
            music->seek(pos);

        }

    }else{
        perror("Unexpected Http response");
        return;
    }
}

