#ifndef INSYNC_H
#define INSYNC_H

#include <QtGui/QMainWindow>
#include <Phonon>
#include <QTimer>
#include <QHttp>
#include <QtDBus>
namespace Ui
{
    class InSync;
}

class InSync : public QMainWindow
{
    Q_OBJECT

public:
    InSync(QWidget *parent = 0);
    ~InSync();

private:
    bool initialized;
    Ui::InSync *ui;
    Phonon::MediaObject *music;
    Phonon::AudioOutput *audioOutput;

    QHttp* ss; //session server
    QString currentFile;
    QTimer *progressTimer;
    QTimer *ttlTimer;

    //HTTP Request ID's
    int createSessionID;
    int joinSessionID;
    int listSessionID;
    int songttlID;

    //Session State
    int session;

    void listSessions();
    void listBTDevices();
    void updateTime();

public slots:
    void PlayMP3();
    void StopMP3();
    void Browse();
    void updateProgress();
    void changePosition();
    void createSession();
    void joinSession();
    void handleHttpRead(int, bool);
    void getTTL();
    void startCountdown();
    void updateVolume();
};


#endif // INSYNC_H
