#ifndef LUM_OS_X11_IMAGE_H
#define LUM_OS_X11_IMAGE_H

#include <Lum/Private/Config.h>

#if defined(HAVE_LIB_XFT2)
#include <X11/Xdefs.h>
#include <X11/Xft/Xft.h>
#endif

#include <Lum/Images/Image.h>

#include <Lum/OS/X11/Display.h>

namespace Lum {
  namespace OS {
    namespace X11 {

      class Image : public Images::Image
      {
      private:
        ::Pixmap  pixmap;
        ::Pixmap  shape;
#if defined(HAVE_LIB_XFT2)
        ::Picture picture;
#endif

      private:
        void CreateOSStructures();


      public:
        Image();
        ~Image();

        void FreeOSStructures();

        void Draw(OS::DrawInfo* draw, int x, int y);
        void DrawSub(OS::DrawInfo* draw, int x, int y, size_t w, size_t h, int dx, int dy);
        void DrawSubCliped(OS::DrawInfo* draw, int x, int y, size_t w, size_t h, int dx, int dy);
        void DrawTiled(OS::DrawInfo* draw, int x, int y, size_t w, size_t h, int dx, int dy);
      };

      class ImageFactory : public Images::Factory
      {
      public:
        ImageFactory(OS::Display* display);

        void Deinit(OS::Display* display);

        Images::Image* CreateImage() const;
      };
    }
  }
}

#endif
