#ifndef LUM_OS_MANAGER_REPOSITORY_H
#define LUM_OS_MANAGER_REPOSITORY_H

/*
  This source is part of the Illumination library
  Copyright (C) 2009  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Private/ImportExport.h>

#include <Lum/Base/Singleton.h>

#include <Lum/OS/Manager/DisplayManager.h>
#include <Lum/OS/Manager/KeyboardManager.h>
#include <Lum/OS/Manager/NetworkManager.h>

namespace Lum {
  namespace OS {
    namespace Manager {

      /**
        Centeral repository for accessing various manager instances for different purposes.
        Manager are abstracting certain aspects of the underlying system like advanced
        display handling, accessing networks etc...
      */
      class LUMAPI Repository
      {
      private:
        DisplayManager  *displayManager;
        KeyboardManager *keyboardManager;
        NetworkManager  *networkManager;

      public:
        Repository();
        ~Repository();

        /**
          Return a instance of the DisplayManager or NULL if no such manager is available.
         */
        DisplayManager* GetDisplayManager();

        /**
          Return a instance of the KeyboardManager or NULL if no such manager is available.
         */
        KeyboardManager* GetKeyboardManager();

        /**
          Return a instance of the NetworkManager or NULL if no such manager is available.
         */
        NetworkManager* GetNetworkManager();
      };

      extern LUMAPI Lum::Base::Singleton<Repository> repository;
    }
  }
}

#endif
