/*
  This source is part of the Illumination library
  Copyright (C) 200  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Def/Boolean.h>

namespace Lum {
  namespace Def {
    Boolean::Boolean(Model::Boolean *value)
     : value(value),
       hasLabel(false),
       hasStockImage(false),
       hasFileImage(false),
       hasShortcut(false)
    {
      assert(value!=NULL);
    }

    Model::Boolean* Boolean::GetBoolean() const
    {
      return value;
    }

    Boolean& Boolean::SetLabel(const std::wstring& label)
    {
      assert(label.length()>0);

      this->label=label;
      hasLabel=true;

      return *this;
    }

    bool Boolean::HasLabel() const
    {
      return hasLabel;
    }

    std::wstring Boolean::GetLabel() const
    {
      assert(hasLabel);

      return label;
    }

    Boolean& Boolean::SetStockImage(const OS::Theme::StockImage& stockImage)
    {
      this->stockImage=stockImage;
      hasStockImage=true;

      return *this;
    }

    bool Boolean::HasStockImage() const
    {
      return hasStockImage;
    }

    OS::Theme::StockImage Boolean::GetStockImage() const
    {
      assert(hasStockImage);

      return stockImage;
    }

    Boolean& Boolean::SetFileImage(const std::wstring& baseName, const std::wstring& suffix)
    {
      assert(baseName.length()>0);
      assert(suffix.length()>0);

      this->fileImageBaseName=baseName;
      this->fileImageSuffix=suffix;
      hasFileImage=true;

      return *this;
    }

    bool Boolean::HasFileImage() const
    {
      return hasFileImage;
    }

    std::wstring Boolean::GetFileImageBaseName() const
    {
      assert(hasFileImage);

      return fileImageBaseName;
    }

    std::wstring Boolean::GetFileImageSuffix() const
    {
      assert(hasFileImage);

      return fileImageSuffix;
    }

    Boolean& Boolean::SetShortcut(unsigned long qualifier, const std::wstring& key)
    {
      assert(key.length()>0);

      this->shortcutQualifier=qualifier;
      this->shortcutKey=key;
      hasShortcut=true;

      return *this;
    }

    bool Boolean::HasShortcut() const
    {
      return hasShortcut;
    }

    unsigned long Boolean::GetShortcutQualifier() const
    {
      assert(hasShortcut);

      return shortcutQualifier;
    }

    std::wstring Boolean::GetShortcutKey() const
    {
      assert(hasShortcut);

      return shortcutKey;
    }
  }
}

