/*
  This source is part of the Illumination library
  Copyright (C) 2009  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Def/Action.h>

namespace Lum {
  namespace Def {
    Action::Action(Model::Action *action)
     : action(action),
       type(normal),
       hasLabel(false),
       hasStockImage(false),
       hasFileImage(false),
       hasShortcut(false)
    {
      assert(action!=NULL);
    }

    Model::Action* Action::GetAction() const
    {
      return action;
    }

    Action& Action::SetType(Type type)
    {
      this->type=type;

      return *this;
    }

    Action::Type Action::GetType() const
    {
      return type;
    }

    Action& Action::SetLabel(const std::wstring& label)
    {
      assert(label.length()>0);

      this->label=label;
      hasLabel=true;

      return *this;
    }

    bool Action::HasLabel() const
    {
      return hasLabel;
    }

    std::wstring Action::GetLabel() const
    {
      assert(hasLabel);

      return label;
    }

    Action& Action::SetStockImage(const OS::Theme::StockImage& stockImage)
    {
      this->stockImage=stockImage;
      hasStockImage=true;

      return *this;
    }

    bool Action::HasStockImage() const
    {
      return hasStockImage;
    }

    OS::Theme::StockImage Action::GetStockImage() const
    {
      assert(hasStockImage);

      return stockImage;
    }

    Action& Action::SetFileImage(const std::wstring& baseName, const std::wstring& suffix)
    {
      assert(baseName.length()>0);
      assert(suffix.length()>0);

      this->fileImageBaseName=baseName;
      this->fileImageSuffix=suffix;
      hasFileImage=true;

      return *this;
    }

    bool Action::HasFileImage() const
    {
      return hasFileImage;
    }

    std::wstring Action::GetFileImageBaseName() const
    {
      assert(hasFileImage);

      return fileImageBaseName;
    }

    std::wstring Action::GetFileImageSuffix() const
    {
      assert(hasFileImage);

      return fileImageSuffix;
    }

    Action& Action::SetShortcut(unsigned long qualifier, const std::wstring& key)
    {
      assert(key.length()>0);

      this->shortcutQualifier=qualifier;
      this->shortcutKey=key;
      hasShortcut=true;

      return *this;
    }

    bool Action::HasShortcut() const
    {
      return hasShortcut;
    }

    unsigned long Action::GetShortcutQualifier() const
    {
      assert(hasShortcut);

      return shortcutQualifier;
    }

    std::wstring Action::GetShortcutKey() const
    {
      assert(hasShortcut);

      return shortcutKey;
    }
  }
}

