#ifndef LUM_OS_X11_FONT_H
#define LUM_OS_X11_FONT_H

/*
  This source is part of the Illumination library
  Copyright (C) 2005  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Private/Config.h>

// std
#include <string>

// X11
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#if defined(HAVE_LIB_XFT2)
#include <X11/Xft/Xft.h>
#endif

#include <Lum/OS/Base/Font.h>

namespace Lum {
  namespace OS {
    namespace X11 {

      class Font : public OS::Base::Font
      {
      public:
        std::string fullName;
        bool        loaded;
        XFontStruct *fonts[maxStyleNum];
#if defined(HAVE_LIB_XFT2)
        XftFont     *xftfonts[maxStyleNum];
#endif

      private:
        std::string BuildFontName() const;
#if defined(HAVE_LIB_XFT2)
        std::string BuildXftFontName(unsigned long style) const;
#endif
        void Complete();

      public:
        Font();
        virtual ~Font();

        size_t StringWidth(const std::wstring& text, unsigned long style=normal);
        void StringExtent(const std::wstring& text, OS::FontExtent& extent, unsigned long style=normal);

        OS::Font* Load();
        unsigned long GetFontPos(unsigned long style);
      };
    }
  }
}

#endif
