/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.SystemTray;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.MouseEvent;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.image.ColorModel;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DesktopPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.SystemTrayPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.TrayIconPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import sun.awt.AppContext;
import sun.awt.ComponentAccessor;
import sun.awt.SunToolkit;
import sun.awt.UNIXToolkit;
import sun.awt.X11.AwtScreenData;
import sun.awt.X11.MotifColorUtilities;
import sun.awt.X11.Native;
import sun.awt.X11.XAWTLookAndFeel;
import sun.awt.X11.XAWTXSettings;
import sun.awt.X11.XAnyEvent;
import sun.awt.X11.XAtom;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XButtonPeer;
import sun.awt.X11.XCanvasPeer;
import sun.awt.X11.XCheckboxMenuItemPeer;
import sun.awt.X11.XCheckboxPeer;
import sun.awt.X11.XChoicePeer;
import sun.awt.X11.XClipboard;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XConstants;
import sun.awt.X11.XCrossingEvent;
import sun.awt.X11.XCustomCursor;
import sun.awt.X11.XDesktopPeer;
import sun.awt.X11.XDialogPeer;
import sun.awt.X11.XDragSourceContextPeer;
import sun.awt.X11.XDropTargetEventProcessor;
import sun.awt.X11.XEmbedCanvasPeer;
import sun.awt.X11.XEmbedChildProxy;
import sun.awt.X11.XEmbedChildProxyPeer;
import sun.awt.X11.XEmbeddedFrame;
import sun.awt.X11.XEmbeddedFramePeer;
import sun.awt.X11.XErrorEvent;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XFileDialogPeer;
import sun.awt.X11.XFontPeer;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XInputMethod;
import sun.awt.X11.XInputMethodDescriptor;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XLabelPeer;
import sun.awt.X11.XLayerProtocol;
import sun.awt.X11.XListPeer;
import sun.awt.X11.XMenuBarPeer;
import sun.awt.X11.XMenuItemPeer;
import sun.awt.X11.XMenuPeer;
import sun.awt.X11.XModifierKeymap;
import sun.awt.X11.XMotionEvent;
import sun.awt.X11.XMouseDragGestureRecognizer;
import sun.awt.X11.XMouseInfoPeer;
import sun.awt.X11.XNETProtocol;
import sun.awt.X11.XPanelPeer;
import sun.awt.X11.XPopupMenuPeer;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XRobotPeer;
import sun.awt.X11.XRootWindow;
import sun.awt.X11.XScrollPanePeer;
import sun.awt.X11.XScrollbarPeer;
import sun.awt.X11.XSelectionEvent;
import sun.awt.X11.XSystemTrayPeer;
import sun.awt.X11.XTextAreaPeer;
import sun.awt.X11.XTextFieldPeer;
import sun.awt.X11.XTrayIconPeer;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;
import sun.awt.X11GraphicsEnvironment;
import sun.awt.XSettings;
import sun.font.FontManager;
import sun.java2d.x11.X11SurfaceData;
import sun.misc.PerformanceLogger;
import sun.print.PrintJob2D;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XToolkit
extends UNIXToolkit
implements Runnable,
XConstants {
    private static Logger log = Logger.getLogger("sun.awt.X11.XToolkit");
    private static Logger eventLog = Logger.getLogger("sun.awt.X11.event.XToolkit");
    private static final Logger timeoutTaskLog = Logger.getLogger("sun.awt.X11.timeoutTask.XToolkit");
    private static Logger keyEventLog = Logger.getLogger("sun.awt.X11.kye.XToolkit");
    private static final Logger backingStoreLog = Logger.getLogger("sun.awt.X11.backingStore.XToolkit");
    static final boolean PRIMARY_LOOP = false;
    static final boolean SECONDARY_LOOP = true;
    private static String awtAppClassName = null;
    XClipboard clipboard;
    XClipboard selection;
    protected static boolean dynamicLayoutSetting = false;
    private boolean loadedXSettings;
    private XSettings xs;
    static int arrowCursor;
    static TreeMap winMap;
    static HashMap specialPeerMap;
    static HashMap winToDispatcher;
    private static long _display;
    static UIDefaults uidefaults;
    static X11GraphicsEnvironment localEnv;
    static X11GraphicsDevice device;
    static final X11GraphicsConfig config;
    static int awt_multiclick_time;
    static boolean securityWarningEnabled;
    private WeakHashMap<Window, Boolean> overrideRedirectWindows = new WeakHashMap();
    private static int screenWidth;
    private static int screenHeight;
    static long awt_defaultFg;
    private static XMouseInfoPeer xPeer;
    private static Method m_removeSourceEvents;
    private static long saved_error_handler;
    static volatile XErrorEvent saved_error;
    private static XErrorHandler current_error_handler;
    private static boolean noisyAwtHandler;
    static Thread toolkitThread;
    static Object displayLock;
    static final String DATA_TRANSFERER_CLASS_NAME = "sun.awt.X11.XDataTransferer";
    private Point lastCursorPos;
    private Collection<XEventListener> listeners = new LinkedList<XEventListener>();
    static ColorModel screenmodel;
    private static boolean initialized;
    private static boolean timeStampUpdated;
    private static long timeStamp;
    private static final XEventDispatcher timeFetcher;
    private static XAtom _XA_JAVA_TIME_PROPERTY_ATOM;
    private static final String prefix = "DnD.Cursor.";
    private static final String postfix = ".32x32";
    private static final String dndPrefix = "DnD.";
    static int altMask;
    static int metaMask;
    static int numLockMask;
    static int modeSwitchMask;
    static int modLockIsShiftLock;
    private static SortedMap timeoutTasks;
    static long reset_time_utc;
    static final long WRAP_TIME_MILLIS = Integer.MAX_VALUE;
    private static int backingStoreType;
    static boolean awt_ServerInquired;
    static boolean awt_IsXsunServer;
    static boolean awt_XKBInquired;
    static boolean awt_UseXKB;
    private static long eventNumber;
    private static XEventDispatcher oops_waiter;
    private static boolean oops_updated;
    private static boolean oops_failed;
    private XAtom oops;
    private static final long WORKAROUND_SLEEP = 100L;

    public static void WITH_XERROR_HANDLER(XErrorHandler handler) {
        saved_error = null;
        current_error_handler = handler;
    }

    public static void RESTORE_XERROR_HANDLER() {
        current_error_handler = null;
    }

    public static int SAVED_ERROR_HANDLER(long display, XErrorEvent error) {
        if (saved_error_handler != 0L) {
            // empty if block
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Unhandled XErrorEvent: id=" + error.get_resourceid() + ", " + "serial=" + error.get_serial() + ", " + "ec=" + error.get_error_code() + ", " + "rc=" + error.get_request_code() + ", " + "mc=" + error.get_minor_code());
        }
        return 0;
    }

    private static int globalErrorHandler(long display, long event_ptr) {
        XErrorEvent event;
        if (noisyAwtHandler) {
            XlibWrapper.PrintXErrorEvent(display, event_ptr);
        }
        saved_error = event = new XErrorEvent(event_ptr);
        try {
            if (current_error_handler != null) {
                return current_error_handler.handleError(display, event);
            }
            return XToolkit.SAVED_ERROR_HANDLER(display, event);
        }
        catch (Throwable z) {
            log.log(Level.FINE, "Error in GlobalErrorHandler", z);
            return 0;
        }
    }

    private static native void initIDs();

    static native void waitForEvents(long var0);

    static boolean isToolkitThread() {
        return Thread.currentThread() == toolkitThread;
    }

    static void initSecurityWarning() {
        String runtime = XToolkit.getSystemProperty("java.runtime.version");
        securityWarningEnabled = runtime != null && runtime.contains("internal");
    }

    static boolean isSecurityWarningEnabled() {
        return securityWarningEnabled;
    }

    static native void awt_output_flush();

    static final void awtFUnlock() {
        XToolkit.awtUnlock();
        XToolkit.awt_output_flush();
    }

    public native void nativeLoadSystemColors(int[] var1);

    static UIDefaults getUIDefaults() {
        if (uidefaults == null) {
            XToolkit.initUIDefaults();
        }
        return uidefaults;
    }

    @Override
    public void loadSystemColors(int[] systemColors) {
        this.nativeLoadSystemColors(systemColors);
        MotifColorUtilities.loadSystemColors(systemColors);
    }

    static void initUIDefaults() {
        try {
            SystemColor c = SystemColor.text;
            XAWTLookAndFeel lnf = new XAWTLookAndFeel();
            uidefaults = ((LookAndFeel)lnf).getDefaults();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static long getDisplay() {
        return _display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDefaultRootWindow() {
        XToolkit.awtLock();
        try {
            long res = XlibWrapper.RootWindow(XToolkit.getDisplay(), XlibWrapper.DefaultScreen(XToolkit.getDisplay()));
            if (res == 0L) {
                throw new IllegalStateException("Root window must not be null");
            }
            long l = res;
            return l;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        XToolkit.awtLock();
        try {
            XlibWrapper.XSupportsLocale();
            if (XlibWrapper.XSetLocaleModifiers("") == null) {
                log.finer("X locale modifiers are not supported, using default");
            }
            AwtScreenData defaultScreen = new AwtScreenData(XToolkit.getDefaultScreenData());
            awt_defaultFg = defaultScreen.get_blackpixel();
            arrowCursor = XlibWrapper.XCreateFontCursor(XToolkit.getDisplay(), 2);
            saved_error_handler = XlibWrapper.SetToolkitErrorHandler();
        }
        finally {
            XToolkit.awtUnlock();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (log.isLoggable(Level.FINE)) {
                    XToolkit.dumpPeers();
                }
            }
        });
    }

    static String getCorrectXIDString(String val) {
        if (val != null) {
            return val.replace('.', '-');
        }
        return val;
    }

    static native String getEnv(String var0);

    static String getAWTAppClassName() {
        return awtAppClassName;
    }

    public XToolkit() {
        if (PerformanceLogger.loggingEnabled()) {
            PerformanceLogger.setTime("XToolkit construction");
        }
        if (!GraphicsEnvironment.isHeadless()) {
            String mainClassName = null;
            StackTraceElement[] trace = new Throwable().getStackTrace();
            int bottom = trace.length - 1;
            if (bottom >= 0) {
                mainClassName = trace[bottom].getClassName();
            }
            if (mainClassName == null || mainClassName.equals("")) {
                mainClassName = "AWT";
            }
            awtAppClassName = XToolkit.getCorrectXIDString(mainClassName);
            this.init();
            XWM.init();
            SunToolkit.setDataTransfererClassName(DATA_TRANSFERER_CLASS_NAME);
            toolkitThread = new Thread(this, "AWT-XAWT");
            toolkitThread.setPriority(6);
            toolkitThread.setDaemon(true);
            ThreadGroup mainTG = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup currentTG = Thread.currentThread().getThreadGroup();
                    ThreadGroup parentTG = currentTG.getParent();
                    while (parentTG != null) {
                        currentTG = parentTG;
                        parentTG = currentTG.getParent();
                    }
                    return currentTG;
                }
            });
            toolkitThread.start();
        }
    }

    @Override
    public ButtonPeer createButton(Button target) {
        XButtonPeer peer = new XButtonPeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public FramePeer createFrame(Frame target) {
        XFramePeer peer = new XFramePeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addToWinMap(long window, XBaseWindow xwin) {
        TreeMap treeMap = winMap;
        synchronized (treeMap) {
            winMap.put(window, xwin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeFromWinMap(long window, XBaseWindow xwin) {
        TreeMap treeMap = winMap;
        synchronized (treeMap) {
            winMap.remove(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XBaseWindow windowToXWindow(long window) {
        TreeMap treeMap = winMap;
        synchronized (treeMap) {
            return (XBaseWindow)winMap.get(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addEventDispatcher(long window, XEventDispatcher dispatcher) {
        HashMap hashMap = winToDispatcher;
        synchronized (hashMap) {
            Long key = window;
            Vector<XEventDispatcher> dispatchers = (Vector<XEventDispatcher>)winToDispatcher.get(key);
            if (dispatchers == null) {
                dispatchers = new Vector<XEventDispatcher>();
                winToDispatcher.put(key, dispatchers);
            }
            dispatchers.add(dispatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeEventDispatcher(long window, XEventDispatcher dispatcher) {
        HashMap hashMap = winToDispatcher;
        synchronized (hashMap) {
            Long key = window;
            Collection dispatchers = (Collection)winToDispatcher.get(key);
            if (dispatchers != null) {
                dispatchers.remove(dispatcher);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getLastCursorPos(Point p) {
        XToolkit.awtLock();
        try {
            if (this.lastCursorPos == null) {
                boolean bl = false;
                return bl;
            }
            p.setLocation(this.lastCursorPos);
            boolean bl = true;
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGlobalMotionEvent(XEvent e) {
        if (e.get_type() == 6) {
            XMotionEvent ev = e.get_xmotion();
            XToolkit.awtLock();
            try {
                if (this.lastCursorPos == null) {
                    this.lastCursorPos = new Point(ev.get_x_root(), ev.get_y_root());
                }
                this.lastCursorPos.setLocation(ev.get_x_root(), ev.get_y_root());
            }
            finally {
                XToolkit.awtUnlock();
            }
        } else {
            if (e.get_type() == 8) {
                XToolkit.awtLock();
                try {
                    this.lastCursorPos = null;
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
            if (e.get_type() == 7) {
                XCrossingEvent ev = e.get_xcrossing();
                XToolkit.awtLock();
                try {
                    if (this.lastCursorPos == null) {
                        this.lastCursorPos = new Point(ev.get_x_root(), ev.get_y_root());
                    } else {
                        this.lastCursorPos.setLocation(ev.get_x_root(), ev.get_y_root());
                    }
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXEventListener(XEventListener listener) {
        Collection<XEventListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(XEvent xev) {
        Collection<XEventListener> collection = this.listeners;
        synchronized (collection) {
            if (this.listeners.size() == 0) {
                return;
            }
            XEvent copy = xev.clone();
            try {
                for (XEventListener listener : this.listeners) {
                    listener.eventProcessed(copy);
                }
            }
            finally {
                copy.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(XEvent ev) {
        XAnyEvent xany = ev.get_xany();
        if (XToolkit.windowToXWindow(xany.get_window()) != null && (ev.get_type() == 6 || ev.get_type() == 7 || ev.get_type() == 8)) {
            this.processGlobalMotionEvent(ev);
        }
        XBaseWindow.dispatchToWindow(ev);
        Vector dispatchers = null;
        HashMap hashMap = winToDispatcher;
        synchronized (hashMap) {
            Long key = xany.get_window();
            dispatchers = (Vector)winToDispatcher.get(key);
            if (dispatchers != null) {
                dispatchers = new Vector(dispatchers);
            }
        }
        if (dispatchers != null) {
            for (XEventDispatcher disp : dispatchers) {
                disp.dispatchEvent(ev);
            }
        }
        this.notifyListeners(ev);
    }

    static void processException(Throwable thr) {
        if (log.isLoggable(Level.WARNING)) {
            log.log(Level.WARNING, "Exception on Toolkit thread", thr);
        }
    }

    static native void awt_toolkit_init();

    @Override
    public void run() {
        XToolkit.awt_toolkit_init();
        this.run(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean loop) {
        XEvent ev = new XEvent();
        while (true) {
            XToolkit.awtLock();
            try {
                XWindow ownerWindow;
                Component owner;
                if (loop) {
                    if (!XlibWrapper.XNextSecondaryLoopEvent(XToolkit.getDisplay(), ev.pData)) {
                        break;
                    }
                } else {
                    XToolkit.callTimeoutTasks();
                    while (XlibWrapper.XEventsQueued(XToolkit.getDisplay(), 1) == 0 && XlibWrapper.XEventsQueued(XToolkit.getDisplay(), 2) == 0) {
                        XToolkit.callTimeoutTasks();
                        XToolkit.waitForEvents(this.getNextTaskTime());
                    }
                    XlibWrapper.XNextEvent(XToolkit.getDisplay(), ev.pData);
                }
                if (ev.get_type() != 14) {
                    ++eventNumber;
                }
                if (XDropTargetEventProcessor.processEvent(ev) || XDragSourceContextPeer.processEvent(ev)) continue;
                if (eventLog.isLoggable(Level.FINER)) {
                    eventLog.log(Level.FINER, "{0}", String.valueOf(ev));
                }
                long w = 0L;
                if (XToolkit.windowToXWindow(ev.get_xany().get_window()) != null && (owner = XKeyboardFocusManagerPeer.getCurrentNativeFocusOwner()) != null && (ownerWindow = (XWindow)((Object)ComponentAccessor.getPeer(owner))) != null) {
                    w = ownerWindow.getContentWindow();
                }
                if (keyEventLog.isLoggable(Level.FINE) && (ev.get_type() == 2 || ev.get_type() == 3)) {
                    keyEventLog.fine("before XFilterEvent:" + ev);
                }
                if (XlibWrapper.XFilterEvent(ev.getPData(), w)) continue;
                if (keyEventLog.isLoggable(Level.FINE) && (ev.get_type() == 2 || ev.get_type() == 3)) {
                    keyEventLog.fine("after XFilterEvent:" + ev);
                }
                this.dispatchEvent(ev);
                continue;
            }
            catch (ThreadDeath td) {
                XBaseWindow.ungrabInput();
                return;
            }
            catch (Throwable thr) {
                XBaseWindow.ungrabInput();
                XToolkit.processException(thr);
                continue;
            }
            finally {
                XToolkit.awtUnlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getDefaultScreenWidth() {
        if (screenWidth == -1) {
            long display = XToolkit.getDisplay();
            XToolkit.awtLock();
            try {
                screenWidth = (int)XlibWrapper.DisplayWidth(display, XlibWrapper.DefaultScreen(display));
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        return screenWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getDefaultScreenHeight() {
        if (screenHeight == -1) {
            long display = XToolkit.getDisplay();
            XToolkit.awtLock();
            try {
                screenHeight = (int)XlibWrapper.DisplayHeight(display, XlibWrapper.DefaultScreen(display));
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        return screenHeight;
    }

    @Override
    protected int getScreenWidth() {
        return XToolkit.getDefaultScreenWidth();
    }

    @Override
    protected int getScreenHeight() {
        return XToolkit.getDefaultScreenHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Rectangle getWorkArea(long root) {
        XAtom XA_NET_WORKAREA = XAtom.get("_NET_WORKAREA");
        long native_ptr = Native.allocateLongArray(4);
        try {
            boolean workareaPresent = XA_NET_WORKAREA.getAtomData(root, 6L, native_ptr, 4);
            if (workareaPresent) {
                int rootX = (int)Native.getLong(native_ptr, 0);
                int rootY = (int)Native.getLong(native_ptr, 1);
                int rootWidth = (int)Native.getLong(native_ptr, 2);
                int rootHeight = (int)Native.getLong(native_ptr, 3);
                Rectangle rectangle = new Rectangle(rootX, rootY, rootWidth, rootHeight);
                return rectangle;
            }
        }
        finally {
            XlibWrapper.unsafe.freeMemory(native_ptr);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Insets getScreenInsets(GraphicsConfiguration gc) {
        XNETProtocol netProto = XWM.getWM().getNETProtocol();
        if (netProto == null || !netProto.active()) {
            return super.getScreenInsets(gc);
        }
        XToolkit.awtLock();
        try {
            Rectangle workArea;
            X11GraphicsConfig x11gc = (X11GraphicsConfig)gc;
            X11GraphicsDevice x11gd = (X11GraphicsDevice)x11gc.getDevice();
            long root = XlibUtil.getRootWindow(x11gd.getScreen());
            Rectangle rootBounds = XlibUtil.getWindowGeometry(root);
            X11GraphicsEnvironment x11ge = (X11GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (!x11ge.runningXinerama() && (workArea = XToolkit.getWorkArea(root)) != null) {
                Insets insets = new Insets(workArea.y, workArea.x, rootBounds.height - workArea.height - workArea.y, rootBounds.width - workArea.width - workArea.x);
                return insets;
            }
            Insets insets = this.getScreenInsetsManually(root, rootBounds, gc.getBounds());
            return insets;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Insets getScreenInsetsManually(long root, Rectangle rootBounds, Rectangle screenBounds) {
        int MAX_NESTED_LEVEL = 3;
        XAtom XA_NET_WM_STRUT = XAtom.get("_NET_WM_STRUT");
        XAtom XA_NET_WM_STRUT_PARTIAL = XAtom.get("_NET_WM_STRUT_PARTIAL");
        Insets insets = new Insets(0, 0, 0, 0);
        LinkedList<Number> search = new LinkedList<Number>();
        search.add(root);
        search.add(0);
        while (!search.isEmpty()) {
            long window = (Long)search.remove(0);
            int windowLevel = (Integer)search.remove(0);
            if (XlibUtil.getWindowMapState(window) == 0) continue;
            long native_ptr = Native.allocateLongArray(4);
            try {
                boolean strutPresent = XA_NET_WM_STRUT_PARTIAL.getAtomData(window, 6L, native_ptr, 4);
                if (!strutPresent) {
                    strutPresent = XA_NET_WM_STRUT.getAtomData(window, 6L, native_ptr, 4);
                }
                if (strutPresent) {
                    Rectangle windowBounds = XlibUtil.getWindowGeometry(window);
                    if (windowLevel > 1) {
                        windowBounds = XlibUtil.translateCoordinates(window, root, windowBounds);
                    }
                    if (windowBounds.intersects(screenBounds)) {
                        insets.left = Math.max((int)Native.getLong(native_ptr, 0), insets.left);
                        insets.right = Math.max((int)Native.getLong(native_ptr, 1), insets.right);
                        insets.top = Math.max((int)Native.getLong(native_ptr, 2), insets.top);
                        insets.bottom = Math.max((int)Native.getLong(native_ptr, 3), insets.bottom);
                    }
                }
            }
            finally {
                XlibWrapper.unsafe.freeMemory(native_ptr);
            }
            if (windowLevel >= 3) continue;
            Set<Long> children = XlibUtil.getChildWindows(window);
            for (long child : children) {
                search.add(child);
                search.add(windowLevel + 1);
            }
        }
        return insets;
    }

    protected static final Object targetToPeer(Object target) {
        Object p = null;
        if (target != null && !GraphicsEnvironment.isHeadless()) {
            p = specialPeerMap.get(target);
        }
        if (p != null) {
            return p;
        }
        return SunToolkit.targetToPeer(target);
    }

    protected static final void targetDisposedPeer(Object target, Object peer) {
        SunToolkit.targetDisposedPeer(target, peer);
    }

    @Override
    public RobotPeer createRobot(Robot target, GraphicsDevice screen) {
        return new XRobotPeer(screen.getDefaultConfiguration());
    }

    @Override
    public void setDynamicLayout(boolean b) {
        dynamicLayoutSetting = b;
    }

    @Override
    protected boolean isDynamicLayoutSet() {
        return dynamicLayoutSetting;
    }

    protected boolean isDynamicLayoutSupported() {
        return XWM.getWM().supportsDynamicLayout();
    }

    @Override
    public boolean isDynamicLayoutActive() {
        return this.isDynamicLayoutSupported();
    }

    @Override
    public FontPeer getFontPeer(String name, int style) {
        return new XFontPeer(name, style);
    }

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dge) throws InvalidDnDOperationException {
        return XDragSourceContextPeer.createDragSourceContextPeer(dge);
    }

    @Override
    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> recognizerClass, DragSource ds, Component c, int srcActions, DragGestureListener dgl) {
        if (MouseDragGestureRecognizer.class.equals(recognizerClass)) {
            return (T)new XMouseDragGestureRecognizer(ds, c, srcActions, dgl);
        }
        return null;
    }

    @Override
    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem target) {
        XCheckboxMenuItemPeer peer = new XCheckboxMenuItemPeer(target);
        return peer;
    }

    @Override
    public MenuItemPeer createMenuItem(MenuItem target) {
        XMenuItemPeer peer = new XMenuItemPeer(target);
        return peer;
    }

    @Override
    public TextFieldPeer createTextField(TextField target) {
        XTextFieldPeer peer = new XTextFieldPeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public LabelPeer createLabel(Label target) {
        XLabelPeer peer = new XLabelPeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public ListPeer createList(List target) {
        XListPeer peer = new XListPeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public CheckboxPeer createCheckbox(Checkbox target) {
        XCheckboxPeer peer = new XCheckboxPeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public ScrollbarPeer createScrollbar(Scrollbar target) {
        XScrollbarPeer peer = new XScrollbarPeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public ScrollPanePeer createScrollPane(ScrollPane target) {
        XScrollPanePeer peer = new XScrollPanePeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public TextAreaPeer createTextArea(TextArea target) {
        XTextAreaPeer peer = new XTextAreaPeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public ChoicePeer createChoice(Choice target) {
        XChoicePeer peer = new XChoicePeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public CanvasPeer createCanvas(Canvas target) {
        XCanvasPeer peer = this.isXEmbedServerRequested() ? new XEmbedCanvasPeer(target) : new XCanvasPeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public PanelPeer createPanel(Panel target) {
        XPanelPeer peer = new XPanelPeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public WindowPeer createWindow(Window target) {
        XWindowPeer peer = new XWindowPeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public DialogPeer createDialog(Dialog target) {
        XDialogPeer peer = new XDialogPeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public FileDialogPeer createFileDialog(FileDialog target) {
        XFileDialogPeer peer = new XFileDialogPeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public MenuBarPeer createMenuBar(MenuBar target) {
        XMenuBarPeer peer = new XMenuBarPeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public MenuPeer createMenu(Menu target) {
        XMenuPeer peer = new XMenuPeer(target);
        return peer;
    }

    @Override
    public PopupMenuPeer createPopupMenu(PopupMenu target) {
        XPopupMenuPeer peer = new XPopupMenuPeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public synchronized MouseInfoPeer getMouseInfoPeer() {
        if (xPeer == null) {
            xPeer = new XMouseInfoPeer();
        }
        return xPeer;
    }

    public XEmbeddedFramePeer createEmbeddedFrame(XEmbeddedFrame target) {
        XEmbeddedFramePeer peer = new XEmbeddedFramePeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    XEmbedChildProxyPeer createEmbedProxy(XEmbedChildProxy target) {
        XEmbedChildProxyPeer peer = new XEmbedChildProxyPeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public KeyboardFocusManagerPeer createKeyboardFocusManagerPeer(KeyboardFocusManager manager) throws HeadlessException {
        XKeyboardFocusManagerPeer peer = new XKeyboardFocusManagerPeer(manager);
        return peer;
    }

    @Override
    public Cursor createCustomCursor(Image cursor, Point hotSpot, String name) throws IndexOutOfBoundsException {
        return new XCustomCursor(cursor, hotSpot, name);
    }

    @Override
    public TrayIconPeer createTrayIcon(TrayIcon target) throws HeadlessException, AWTException {
        XTrayIconPeer peer = new XTrayIconPeer(target);
        XToolkit.targetCreatedPeer(target, peer);
        return peer;
    }

    @Override
    public SystemTrayPeer createSystemTray(SystemTray target) throws HeadlessException {
        XSystemTrayPeer peer = new XSystemTrayPeer(target);
        return peer;
    }

    @Override
    public boolean isTraySupported() {
        XSystemTrayPeer peer = XSystemTrayPeer.getPeerInstance();
        if (peer != null) {
            return peer.isAvailable();
        }
        return false;
    }

    @Override
    public Dimension getBestCursorSize(int preferredWidth, int preferredHeight) {
        return XCustomCursor.getBestCursorSize(Math.max(1, preferredWidth), Math.max(1, preferredHeight));
    }

    @Override
    public int getMaximumCursorColors() {
        return 2;
    }

    public Map mapInputMethodHighlight(InputMethodHighlight highlight) {
        return XInputMethod.mapInputMethodHighlight(highlight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clipboard getSystemClipboard() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSystemClipboardAccess();
        }
        XToolkit xToolkit = this;
        synchronized (xToolkit) {
            if (this.clipboard == null) {
                this.clipboard = new XClipboard("System", "CLIPBOARD");
            }
        }
        return this.clipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clipboard getSystemSelection() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSystemClipboardAccess();
        }
        XToolkit xToolkit = this;
        synchronized (xToolkit) {
            if (this.selection == null) {
                this.selection = new XClipboard("Selection", "PRIMARY");
            }
        }
        return this.selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beep() {
        XToolkit.awtLock();
        try {
            XlibWrapper.XBell(XToolkit.getDisplay(), 0);
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static String getSystemProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name);
            }
        });
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String doctitle, Properties props) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob = new PrintJob2D(frame, doctitle, props);
        if (!printJob.printDialog()) {
            printJob = null;
        }
        return printJob;
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String doctitle, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob = new PrintJob2D(frame, doctitle, jobAttributes, pageAttributes);
        if (!printJob.printDialog()) {
            printJob = null;
        }
        return printJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void XSync() {
        XToolkit.awtLock();
        try {
            XlibWrapper.XSync(XToolkit.getDisplay(), 0);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getScreenResolution() {
        long display = XToolkit.getDisplay();
        XToolkit.awtLock();
        try {
            int n = (int)((double)XlibWrapper.DisplayWidth(display, XlibWrapper.DefaultScreen(display)) * 25.4 / (double)XlibWrapper.DisplayWidthMM(display, XlibWrapper.DefaultScreen(display)));
            return n;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static native long getDefaultXColormap();

    static native long getDefaultScreenData();

    static ColorModel getStaticColorModel() {
        if (screenmodel == null) {
            screenmodel = config.getColorModel();
        }
        return screenmodel;
    }

    @Override
    public ColorModel getColorModel() {
        return XToolkit.getStaticColorModel();
    }

    @Override
    public InputMethodDescriptor getInputMethodAdapterDescriptor() throws AWTException {
        return new XInputMethodDescriptor();
    }

    static int getMultiClickTime() {
        if (awt_multiclick_time == 0) {
            XToolkit.initializeMultiClickTime();
        }
        return awt_multiclick_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initializeMultiClickTime() {
        block9: {
            XToolkit.awtLock();
            try {
                try {
                    String multiclick_time_query = XlibWrapper.XGetDefault(XToolkit.getDisplay(), "*", "multiClickTime");
                    if (multiclick_time_query != null) {
                        awt_multiclick_time = (int)Long.parseLong(multiclick_time_query);
                        break block9;
                    }
                    multiclick_time_query = XlibWrapper.XGetDefault(XToolkit.getDisplay(), "OpenWindows", "MultiClickTimeout");
                    if (multiclick_time_query != null) {
                        awt_multiclick_time = (int)Long.parseLong(multiclick_time_query) * 100;
                        break block9;
                    }
                    awt_multiclick_time = 200;
                }
                catch (NumberFormatException nf) {
                    awt_multiclick_time = 200;
                }
                catch (NullPointerException npe) {
                    awt_multiclick_time = 200;
                }
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        if (awt_multiclick_time == 0) {
            awt_multiclick_time = 200;
        }
    }

    @Override
    public boolean isFrameStateSupported(int state) throws HeadlessException {
        if (state == 0 || state == 1) {
            return true;
        }
        return XWM.getWM().supportsExtendedState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOverrideRedirect(Window target) {
        WeakHashMap<Window, Boolean> weakHashMap = this.overrideRedirectWindows;
        synchronized (weakHashMap) {
            this.overrideRedirectWindows.put(target, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOverrideRedirect(Window target) {
        WeakHashMap<Window, Boolean> weakHashMap = this.overrideRedirectWindows;
        synchronized (weakHashMap) {
            return this.overrideRedirectWindows.containsKey(target);
        }
    }

    static void dumpPeers() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Mapped windows:");
            for (Map.Entry entry : winMap.entrySet()) {
                log.fine(entry.getKey() + "->" + entry.getValue());
                if (!(entry.getValue() instanceof XComponentPeer)) continue;
                Component target = (Component)((XComponentPeer)entry.getValue()).getTarget();
                log.fine("\ttarget: " + target);
            }
            SunToolkit.dumpPeers(log);
            log.fine("Mapped special peers:");
            for (Map.Entry entry : specialPeerMap.entrySet()) {
                log.fine(entry.getKey() + "->" + entry.getValue());
            }
            log.fine("Mapped dispatchers:");
            for (Map.Entry entry : winToDispatcher.entrySet()) {
                log.fine(entry.getKey() + "->" + entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getCurrentServerTime() {
        block12: {
            XToolkit.awtLock();
            try {
                try {
                    if (!initialized) {
                        XToolkit.addEventDispatcher(XBaseWindow.getXAWTRootWindow().getWindow(), timeFetcher);
                        _XA_JAVA_TIME_PROPERTY_ATOM = XAtom.get("_SUNW_JAVA_AWT_TIME");
                        initialized = true;
                    }
                    timeStampUpdated = false;
                    XlibWrapper.XChangeProperty(XToolkit.getDisplay(), XBaseWindow.getXAWTRootWindow().getWindow(), _XA_JAVA_TIME_PROPERTY_ATOM.getAtom(), 4L, 32, 2, 0L, 0);
                    XlibWrapper.XFlush(XToolkit.getDisplay());
                    if (XToolkit.isToolkitThread()) {
                        XEvent event = new XEvent();
                        try {
                            XlibWrapper.XWindowEvent(XToolkit.getDisplay(), XBaseWindow.getXAWTRootWindow().getWindow(), 0x400000L, event.pData);
                            timeFetcher.dispatchEvent(event);
                            break block12;
                        }
                        finally {
                            event.dispose();
                        }
                    }
                    while (!timeStampUpdated) {
                        XToolkit.awtLockWait();
                    }
                }
                catch (InterruptedException ie) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Catched exception, timeStamp may not be correct (ie = " + ie + ")");
                    }
                }
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        return timeStamp;
    }

    @Override
    protected void initializeDesktopProperties() {
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", 50);
        this.desktopProperties.put("DnD.Autoscroll.interval", 50);
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", 5);
        if (!GraphicsEnvironment.isHeadless()) {
            this.desktopProperties.put("awt.multiClickInterval", XToolkit.getMultiClickTime());
            this.desktopProperties.put("awt.mouse.numButtons", this.getNumMouseButtons());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumMouseButtons() {
        XToolkit.awtLock();
        try {
            int n = XlibWrapper.XGetPointerMapping(XToolkit.getDisplay(), 0L, 0);
            return n;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    protected Object lazilyLoadDesktopProperty(String name) {
        if (name.startsWith(prefix)) {
            String cursorName = name.substring(prefix.length(), name.length()) + postfix;
            try {
                return Cursor.getSystemCustomCursor(cursorName);
            }
            catch (AWTException awte) {
                throw new RuntimeException("cannot load system cursor: " + cursorName, awte);
            }
        }
        if (name.equals("awt.dynamicLayoutSupported")) {
            return this.isDynamicLayoutSupported();
        }
        if (this.initXSettingsIfNeeded(name)) {
            return this.desktopProperties.get(name);
        }
        return super.lazilyLoadDesktopProperty(name);
    }

    @Override
    public synchronized void addPropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.initXSettingsIfNeeded(name);
        super.addPropertyChangeListener(name, pcl);
    }

    private boolean initXSettingsIfNeeded(String propName) {
        if (!this.loadedXSettings && (propName.startsWith("gnome.") || propName.equals("awt.font.desktophints") || propName.startsWith(dndPrefix))) {
            this.loadedXSettings = true;
            if (!GraphicsEnvironment.isHeadless()) {
                this.loadXSettings();
                if (this.desktopProperties.get("awt.font.desktophints") == null) {
                    Object hint;
                    if (XWM.isKDE2() && (hint = FontManager.getFontConfigAAHint()) != null) {
                        this.desktopProperties.put("fontconfig/Antialias", hint);
                    }
                    this.desktopProperties.put("awt.font.desktophints", SunToolkit.getDesktopFontHints());
                }
                return true;
            }
        }
        return false;
    }

    private void loadXSettings() {
        this.xs = new XAWTXSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseXSettings(int screen_XXX_ignored, Map updatedSettings) {
        if (updatedSettings == null || updatedSettings.isEmpty()) {
            return;
        }
        for (Map.Entry e : updatedSettings.entrySet()) {
            String name = (String)e.getKey();
            name = "gnome." + name;
            this.setDesktopProperty(name, e.getValue());
            log.fine("name = " + name + " value = " + e.getValue());
        }
        this.setDesktopProperty("awt.font.desktophints", SunToolkit.getDesktopFontHints());
        Integer dragThreshold = null;
        XToolkit xToolkit = this;
        synchronized (xToolkit) {
            dragThreshold = (Integer)this.desktopProperties.get("gnome.Net/DndDragThreshold");
        }
        if (dragThreshold != null) {
            this.setDesktopProperty("DnD.gestureMotionThreshold", dragThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int keysymToPrimaryKeycode(long sym2) {
        XToolkit.awtLock();
        try {
            int code = XlibWrapper.XKeysymToKeycode(XToolkit.getDisplay(), sym2);
            if (code == 0) {
                int n = 0;
                return n;
            }
            long primary = XlibWrapper.XKeycodeToKeysym(XToolkit.getDisplay(), code, 0);
            if (sym2 != primary) {
                int n = 0;
                return n;
            }
            int n = code;
            return n;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setupModifierMap() {
        int metaL = XToolkit.keysymToPrimaryKeycode(65511L);
        int metaR = XToolkit.keysymToPrimaryKeycode(65512L);
        int altL = XToolkit.keysymToPrimaryKeycode(65513L);
        int altR = XToolkit.keysymToPrimaryKeycode(65514L);
        int numLock = XToolkit.keysymToPrimaryKeycode(65407L);
        int modeSwitch = XToolkit.keysymToPrimaryKeycode(65406L);
        int shiftLock = XToolkit.keysymToPrimaryKeycode(65510L);
        int capsLock = XToolkit.keysymToPrimaryKeycode(65509L);
        int[] modmask = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        log.fine("In setupModifierMap");
        XToolkit.awtLock();
        try {
            short keycode;
            XModifierKeymap modmap = new XModifierKeymap(XlibWrapper.XGetModifierMapping(XToolkit.getDisplay()));
            int nkeys = modmap.get_max_keypermod();
            long map_ptr = modmap.get_modifiermap();
            block3: for (int modn = 3; modn <= 7; ++modn) {
                short keycode2;
                for (int i = 0; i < nkeys && (keycode2 = Native.getUByte(map_ptr, modn * nkeys + i)) != 0; ++i) {
                    if (metaMask == 0 && (keycode2 == metaL || keycode2 == metaR)) {
                        metaMask = modmask[modn];
                        continue block3;
                    }
                    if (altMask == 0 && (keycode2 == altL || keycode2 == altR)) {
                        altMask = modmask[modn];
                        continue block3;
                    }
                    if (numLockMask == 0 && keycode2 == numLock) {
                        numLockMask = modmask[modn];
                        continue block3;
                    }
                    if (modeSwitchMask != 0 || keycode2 != modeSwitch) continue;
                    modeSwitchMask = modmask[modn];
                    continue block3;
                }
            }
            modLockIsShiftLock = 0;
            for (int j = 0; j < nkeys && (keycode = Native.getUByte(map_ptr, 1 * nkeys + j)) != 0; ++j) {
                if (keycode == shiftLock) {
                    modLockIsShiftLock = 1;
                    break;
                }
                if (keycode == capsLock) break;
            }
            XlibWrapper.XFreeModifiermap(modmap.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("metaMask = " + metaMask);
            log.fine("altMask = " + altMask);
            log.fine("numLockMask = " + numLockMask);
            log.fine("modeSwitchMask = " + modeSwitchMask);
            log.fine("modLockIsShiftLock = " + modLockIsShiftLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(Runnable task) {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        XToolkit.awtLock();
        try {
            if (timeoutTaskLog.isLoggable(Level.FINER)) {
                timeoutTaskLog.finer("Removing task " + task);
            }
            if (timeoutTasks == null) {
                if (timeoutTaskLog.isLoggable(Level.FINER)) {
                    timeoutTaskLog.finer("Task is not scheduled");
                }
                return;
            }
            Collection values = timeoutTasks.values();
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                java.util.List list = (java.util.List)iter.next();
                boolean removed = false;
                if (!list.contains(task)) continue;
                list.remove(task);
                if (list.isEmpty()) {
                    iter.remove();
                }
                break;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static native void wakeup_poll();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void schedule(Runnable task, long interval) {
        if (task == null) {
            throw new NullPointerException("task is null");
        }
        if (interval <= 0L) {
            throw new IllegalArgumentException("interval " + interval + " is not positive");
        }
        XToolkit.awtLock();
        try {
            Long time;
            ArrayList<Runnable> tasks;
            if (timeoutTaskLog.isLoggable(Level.FINER)) {
                timeoutTaskLog.log(Level.FINER, "XToolkit.schedule(): current time={0};  interval={1};  task being added={2};  tasks before addition={3}", new Object[]{System.currentTimeMillis(), interval, String.valueOf(task), String.valueOf(timeoutTasks)});
            }
            if (timeoutTasks == null) {
                timeoutTasks = new TreeMap();
            }
            if ((tasks = (ArrayList<Runnable>)timeoutTasks.get(time = Long.valueOf(System.currentTimeMillis() + interval))) == null) {
                tasks = new ArrayList<Runnable>(1);
                timeoutTasks.put(time, tasks);
            }
            tasks.add(task);
            if (timeoutTasks.get(timeoutTasks.firstKey()) == tasks && tasks.size() == 1) {
                XToolkit.wakeup_poll();
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextTaskTime() {
        XToolkit.awtLock();
        try {
            if (timeoutTasks == null || timeoutTasks.isEmpty()) {
                long l = -1L;
                return l;
            }
            long l = (Long)timeoutTasks.firstKey();
            return l;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    private static void callTimeoutTasks() {
        if (timeoutTaskLog.isLoggable(Level.FINER)) {
            timeoutTaskLog.log(Level.FINER, "XToolkit.callTimeoutTasks(): current time={0};  tasks={1}", new Object[]{System.currentTimeMillis(), String.valueOf(timeoutTasks)});
        }
        if (timeoutTasks == null || timeoutTasks.isEmpty()) {
            return;
        }
        Long currentTime = System.currentTimeMillis();
        Long time = (Long)timeoutTasks.firstKey();
        while (time.compareTo(currentTime) <= 0) {
            java.util.List tasks = (java.util.List)timeoutTasks.remove(time);
            for (Runnable task : tasks) {
                if (timeoutTaskLog.isLoggable(Level.FINER)) {
                    timeoutTaskLog.log(Level.FINER, "XToolkit.callTimeoutTasks(): current time={0};  about to run task={1}", new Object[]{(long)currentTime, String.valueOf(task)});
                }
                try {
                    task.run();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable thr) {
                    XToolkit.processException(thr);
                }
            }
            if (timeoutTasks.isEmpty()) break;
            time = (Long)timeoutTasks.firstKey();
        }
    }

    static long getAwtDefaultFg() {
        return awt_defaultFg;
    }

    static boolean isLeftMouseButton(MouseEvent me) {
        switch (me.getID()) {
            case 501: 
            case 502: {
                return me.getButton() == 1;
            }
            case 500: 
            case 504: 
            case 505: 
            case 506: {
                return (me.getModifiersEx() & 0x400) != 0;
            }
        }
        return false;
    }

    static boolean isRightMouseButton(MouseEvent me) {
        int numButtons = (Integer)XToolkit.getDefaultToolkit().getDesktopProperty("awt.mouse.numButtons");
        switch (me.getID()) {
            case 501: 
            case 502: {
                return numButtons == 2 && me.getButton() == 2 || numButtons > 2 && me.getButton() == 3;
            }
            case 500: 
            case 504: 
            case 505: 
            case 506: {
                return numButtons == 2 && (me.getModifiersEx() & 0x800) != 0 || numButtons > 2 && (me.getModifiersEx() & 0x1000) != 0;
            }
        }
        return false;
    }

    static long nowMillisUTC_offset(long server_offset) {
        long current_time_utc = System.currentTimeMillis();
        if (log.isLoggable(Level.FINER)) {
            log.finer("reset_time=" + reset_time_utc + ", current_time=" + current_time_utc + ", server_offset=" + server_offset + ", wrap_time=" + Integer.MAX_VALUE);
        }
        if (current_time_utc - reset_time_utc > Integer.MAX_VALUE) {
            reset_time_utc = System.currentTimeMillis() - XToolkit.getCurrentServerTime();
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("result = " + (reset_time_utc + server_offset));
        }
        return reset_time_utc + server_offset;
    }

    @Override
    protected boolean needsXEmbedImpl() {
        return true;
    }

    @Override
    public boolean isModalityTypeSupported(Dialog.ModalityType modalityType) {
        return modalityType == null || modalityType == Dialog.ModalityType.MODELESS || modalityType == Dialog.ModalityType.DOCUMENT_MODAL || modalityType == Dialog.ModalityType.APPLICATION_MODAL || modalityType == Dialog.ModalityType.TOOLKIT_MODAL;
    }

    @Override
    public boolean isModalExclusionTypeSupported(Dialog.ModalExclusionType exclusionType) {
        return exclusionType == null || exclusionType == Dialog.ModalExclusionType.NO_EXCLUDE || exclusionType == Dialog.ModalExclusionType.APPLICATION_EXCLUDE || exclusionType == Dialog.ModalExclusionType.TOOLKIT_EXCLUDE;
    }

    static EventQueue getEventQueue(Object target) {
        AppContext appContext = XToolkit.targetToAppContext(target);
        if (appContext != null) {
            return (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
        }
        return null;
    }

    static void removeSourceEvents(EventQueue queue, Object source, boolean removeAllEvents) {
        try {
            m_removeSourceEvents.invoke(queue, source, removeAllEvents);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isAlwaysOnTopSupported() {
        for (XLayerProtocol xLayerProtocol : XWM.getWM().getProtocols(XLayerProtocol.class)) {
            if (!xLayerProtocol.supportsLayer(1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean useBufferPerWindow() {
        return XToolkit.getBackingStoreType() == 0;
    }

    static int getBackingStoreType() {
        return backingStoreType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setBackingStoreType() {
        String prop = AccessController.doPrivileged(new GetPropertyAction("sun.awt.backingStore"));
        if (prop == null) {
            backingStoreType = 0;
            if (backingStoreLog.isLoggable(Level.CONFIG)) {
                backingStoreLog.config("The system property sun.awt.backingStore is not set, by default backingStore=NotUseful");
            }
            return;
        }
        if (backingStoreLog.isLoggable(Level.CONFIG)) {
            backingStoreLog.config("The system property sun.awt.backingStore is " + prop);
        }
        backingStoreType = (prop = prop.toLowerCase()).equals("always") ? 2 : (prop.equals("whenmapped") ? 1 : 0);
        if (backingStoreLog.isLoggable(Level.CONFIG)) {
            backingStoreLog.config("backingStore(as provided by the system property)=" + (backingStoreType == 0 ? "NotUseful" : (backingStoreType == 1 ? "WhenMapped" : "Always")));
        }
        if (X11SurfaceData.isDgaAvailable()) {
            backingStoreType = 0;
            if (backingStoreLog.isLoggable(Level.CONFIG)) {
                backingStoreLog.config("DGA is available, backingStore=NotUseful");
            }
            return;
        }
        XToolkit.awtLock();
        try {
            int screenCount = XlibWrapper.ScreenCount(XToolkit.getDisplay());
            for (int i = 0; i < screenCount; ++i) {
                if (XlibWrapper.DoesBackingStore(XlibWrapper.ScreenOfDisplay(XToolkit.getDisplay(), i)) != 0) continue;
                backingStoreType = 0;
                if (backingStoreLog.isLoggable(Level.CONFIG)) {
                    backingStoreLog.config("Backing store is not available on the screen " + i + ", backingStore=NotUseful");
                }
                return;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isXsunServer() {
        XToolkit.awtLock();
        try {
            if (awt_ServerInquired) {
                boolean bl = awt_IsXsunServer;
                return bl;
            }
            if (!XlibWrapper.ServerVendor(XToolkit.getDisplay()).startsWith("Sun Microsystems")) {
                awt_ServerInquired = true;
                awt_IsXsunServer = false;
                boolean bl = false;
                return bl;
            }
            if (XlibWrapper.VendorRelease(XToolkit.getDisplay()) > 10000) {
                awt_ServerInquired = true;
                awt_IsXsunServer = false;
                boolean bl = false;
                return bl;
            }
            awt_ServerInquired = true;
            awt_IsXsunServer = true;
            boolean bl = true;
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isXKBenabled() {
        XToolkit.awtLock();
        try {
            if (awt_XKBInquired) {
                boolean bl = awt_UseXKB;
                return bl;
            }
            awt_XKBInquired = true;
            String name = "XKEYBOARD";
            boolean bl = awt_UseXKB = XlibWrapper.XQueryExtension(XToolkit.getDisplay(), name, XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3);
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getEventNumber() {
        XToolkit.awtLock();
        try {
            long l = eventNumber;
            return l;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean syncNativeQueue(long timeout) {
        XRootWindow win = XBaseWindow.getXAWTRootWindow();
        if (oops_waiter == null) {
            oops_waiter = new XEventDispatcher(){

                public void dispatchEvent(XEvent e) {
                    if (e.get_type() == 31) {
                        XSelectionEvent pe = e.get_xselection();
                        if (pe.get_property() == XToolkit.this.oops.getAtom()) {
                            oops_updated = true;
                            SunToolkit.awtLockNotifyAll();
                        } else if (pe.get_selection() == XAtom.get("WM_S0").getAtom() && pe.get_target() == XAtom.get("VERSION").getAtom() && pe.get_property() == 0L && XlibWrapper.XGetSelectionOwner(XToolkit.getDisplay(), XAtom.get("WM_S0").getAtom()) == 0L) {
                            oops_failed = true;
                            SunToolkit.awtLockNotifyAll();
                        }
                    }
                }
            };
        }
        if (this.oops == null) {
            this.oops = XAtom.get("OOPS");
        }
        XToolkit.awtLock();
        try {
            XToolkit.addEventDispatcher(win.getWindow(), oops_waiter);
            oops_updated = false;
            oops_failed = false;
            long event_number = XToolkit.getEventNumber();
            XAtom atom = XAtom.get("WM_S0");
            eventLog.log(Level.FINER, "WM_S0 selection owner {0}", new Object[]{XlibWrapper.XGetSelectionOwner(XToolkit.getDisplay(), atom.getAtom())});
            XlibWrapper.XConvertSelection(XToolkit.getDisplay(), atom.getAtom(), XAtom.get("VERSION").getAtom(), this.oops.getAtom(), win.getWindow(), 0L);
            XToolkit.XSync();
            eventLog.finer("Requested OOPS");
            long start = System.currentTimeMillis();
            while (!oops_updated && !oops_failed) {
                try {
                    XToolkit.awtLockWait(timeout);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (System.currentTimeMillis() - start <= timeout || timeout < 0L) continue;
                throw new SunToolkit.OperationTimedOut(Long.toString(System.currentTimeMillis() - start));
            }
            if (oops_failed && XToolkit.getEventNumber() - event_number == 1L) {
                XToolkit.awtUnlock();
                eventLog.log(Level.FINEST, "Emergency sleep");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                finally {
                    XToolkit.awtLock();
                }
            }
            boolean bl = XToolkit.getEventNumber() - event_number > 2L;
            return bl;
        }
        finally {
            XToolkit.removeEventDispatcher(win.getWindow(), oops_waiter);
            eventLog.log(Level.FINER, "Exiting syncNativeQueue");
            XToolkit.awtUnlock();
        }
    }

    @Override
    public void grab(Window w) {
        if (w.getPeer() != null) {
            ((XWindowPeer)w.getPeer()).setGrab(true);
        }
    }

    @Override
    public void ungrab(Window w) {
        if (w.getPeer() != null) {
            ((XWindowPeer)w.getPeer()).setGrab(false);
        }
    }

    @Override
    public boolean isDesktopSupported() {
        return XDesktopPeer.isDesktopSupported();
    }

    @Override
    public DesktopPeer createDesktopPeer(Desktop target) {
        return new XDesktopPeer();
    }

    static {
        winMap = new TreeMap();
        specialPeerMap = new HashMap();
        winToDispatcher = new HashMap();
        screenWidth = -1;
        screenHeight = -1;
        XToolkit.initSecurityWarning();
        if (GraphicsEnvironment.isHeadless()) {
            config = null;
        } else {
            localEnv = (X11GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
            device = (X11GraphicsDevice)localEnv.getDefaultScreenDevice();
            config = (X11GraphicsConfig)device.getDefaultConfiguration();
            if (device != null) {
                _display = device.getDisplay();
            }
            XToolkit.setupModifierMap();
            XToolkit.initIDs();
            XToolkit.setBackingStoreType();
        }
        m_removeSourceEvents = SunToolkit.getMethod(EventQueue.class, "removeSourceEvents", new Class[]{Object.class, Boolean.TYPE});
        noisyAwtHandler = AccessController.doPrivileged(new GetBooleanAction("sun.awt.noisyerrorhandler"));
        displayLock = new Object();
        timeFetcher = new XEventDispatcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispatchEvent(XEvent ev) {
                switch (ev.get_type()) {
                    case 28: {
                        XPropertyEvent xpe = ev.get_xproperty();
                        SunToolkit.awtLock();
                        try {
                            timeStamp = xpe.get_time();
                            timeStampUpdated = true;
                            SunToolkit.awtLockNotifyAll();
                            break;
                        }
                        finally {
                            SunToolkit.awtUnlock();
                        }
                    }
                }
            }
        };
        awt_ServerInquired = false;
        awt_IsXsunServer = false;
        awt_XKBInquired = false;
        awt_UseXKB = false;
    }

    public static interface XEventListener {
        public void eventProcessed(XEvent var1);
    }
}

