/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.ScrollPaneAdjustable;
import java.awt.event.MouseEvent;
import java.awt.peer.ScrollPanePeer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.awt.SunToolkit;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XHorizontalScrollbar;
import sun.awt.X11.XScrollbar;
import sun.awt.X11.XScrollbarClient;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XVerticalScrollbar;
import sun.awt.X11.XWindow;

class XScrollPanePeer
extends XComponentPeer
implements ScrollPanePeer,
XScrollbarClient {
    public static final int MARGIN = 1;
    public static final int SCROLLBAR;
    public static final int SPACE = 2;
    public static final int SCROLLBAR_INSET = 2;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;
    private static Method m_setValue;
    XVerticalScrollbar vsb;
    XHorizontalScrollbar hsb;
    XWindow clip = null;
    int active = 1;
    int hsbSpace;
    int vsbSpace;
    int vval;
    int hval;
    int vmax;
    int hmax;

    XScrollPanePeer(ScrollPane target) {
        super(target);
        XScrollPaneContentWindow c = new XScrollPaneContentWindow(target, this.window);
        this.clip = c;
        this.vsb = new XVerticalScrollbar(this);
        this.hsb = new XHorizontalScrollbar(this);
        if (target.getScrollbarDisplayPolicy() == 1) {
            this.vsbSpace = this.hsbSpace = SCROLLBAR;
        } else {
            this.hsbSpace = 0;
            this.vsbSpace = 0;
        }
        int unitIncrement = 1;
        Adjustable vAdjustable = target.getVAdjustable();
        if (vAdjustable != null) {
            unitIncrement = vAdjustable.getUnitIncrement();
        }
        int h = this.height - this.hsbSpace;
        this.vsb.setValues(0, h, 0, h, unitIncrement, Math.max(1, (int)((double)h * 0.9)));
        this.vsb.setSize(this.vsbSpace - 2, h);
        unitIncrement = 1;
        Adjustable hAdjustable = target.getHAdjustable();
        if (hAdjustable != null) {
            unitIncrement = hAdjustable.getUnitIncrement();
        }
        int w = this.width - this.vsbSpace;
        this.hsb.setValues(0, w, 0, w, unitIncrement, Math.max(1, (int)((double)w * 0.9)));
        this.hsb.setSize(w, this.hsbSpace - 2);
        this.setViewportSize();
        this.clip.xSetVisible(true);
    }

    public long getContentWindow() {
        return this.clip == null ? this.window : this.clip.getWindow();
    }

    public void setBounds(int x, int y, int w, int h, int op) {
        super.setBounds(x, y, w, h, op);
        if (this.clip == null) {
            return;
        }
        this.setScrollbarSpace();
        this.setViewportSize();
        this.repaint();
    }

    public Insets getInsets() {
        return new Insets(1, 1, 1 + this.hsbSpace, 1 + this.vsbSpace);
    }

    public int getHScrollbarHeight() {
        return SCROLLBAR;
    }

    public int getVScrollbarWidth() {
        return SCROLLBAR;
    }

    public void childResized(int w, int h) {
        if (this.setScrollbarSpace()) {
            this.setViewportSize();
        }
        this.repaint();
    }

    Dimension getChildSize() {
        ScrollPane sp = (ScrollPane)this.target;
        if (sp.countComponents() > 0) {
            Component c = sp.getComponent(0);
            return c.size();
        }
        return new Dimension(0, 0);
    }

    boolean setScrollbarSpace() {
        int max;
        int vis;
        ScrollPane sp = (ScrollPane)this.target;
        boolean changed = false;
        int sbDisplayPolicy = sp.getScrollbarDisplayPolicy();
        if (sbDisplayPolicy == 2) {
            return changed;
        }
        Dimension cSize = this.getChildSize();
        if (sbDisplayPolicy == 0) {
            int oldHsbSpace = this.hsbSpace;
            int oldVsbSpace = this.vsbSpace;
            this.hsbSpace = cSize.width <= this.width - 2 ? 0 : SCROLLBAR;
            int n = this.vsbSpace = cSize.height <= this.height - 2 ? 0 : SCROLLBAR;
            if (this.hsbSpace == 0 && this.vsbSpace != 0) {
                int n2 = this.hsbSpace = cSize.width <= this.width - SCROLLBAR - 2 ? 0 : SCROLLBAR;
            }
            if (this.vsbSpace == 0 && this.hsbSpace != 0) {
                int n3 = this.vsbSpace = cSize.height <= this.height - SCROLLBAR - 2 ? 0 : SCROLLBAR;
            }
            if (oldHsbSpace != this.hsbSpace || oldVsbSpace != this.vsbSpace) {
                changed = true;
            }
        }
        if (this.vsbSpace > 0) {
            vis = this.height - 2 - this.hsbSpace;
            max = Math.max(cSize.height, vis);
            this.vsb.setValues(this.vsb.getValue(), vis, 0, max);
            this.vsb.setBlockIncrement((int)((double)this.vsb.getVisibleAmount() * 0.9));
            this.vsb.setSize(this.vsbSpace - 2, this.height - this.hsbSpace);
        }
        if (this.hsbSpace > 0) {
            vis = this.width - 2 - this.vsbSpace;
            max = Math.max(cSize.width, vis);
            this.hsb.setValues(this.hsb.getValue(), vis, 0, max);
            this.hsb.setBlockIncrement((int)((double)this.hsb.getVisibleAmount() * 0.9));
            this.hsb.setSize(this.width - this.vsbSpace, this.hsbSpace - 2);
        }
        boolean must_scroll = false;
        Point p = new Point(0, 0);
        if (((ScrollPane)this.target).getComponentCount() > 0) {
            p = ((ScrollPane)this.target).getComponent(0).location();
            if (this.vsbSpace == 0 && p.y < 0) {
                p.y = 0;
                must_scroll = true;
            }
            if (this.hsbSpace == 0 && p.x < 0) {
                p.x = 0;
                must_scroll = true;
            }
        }
        if (must_scroll) {
            this.scroll(this.x, this.y, 3);
        }
        return changed;
    }

    void setViewportSize() {
        this.clip.xSetBounds(1, 1, this.width - 2 - this.vsbSpace, this.height - 2 - this.hsbSpace);
    }

    public void setUnitIncrement(Adjustable adj, int u) {
        if (adj.getOrientation() == 1) {
            this.vsb.setUnitIncrement(u);
        } else {
            this.hsb.setUnitIncrement(u);
        }
    }

    public void setValue(Adjustable adj, int v) {
        if (adj.getOrientation() == 1) {
            this.scroll(-1, v, 1);
        } else {
            this.scroll(v, -1, 2);
        }
    }

    public void setScrollPosition(int x, int y) {
        this.scroll(x, y, 3);
    }

    void scroll(int x, int y, int flag) {
        this.scroll(x, y, flag, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scroll(int x, int y, int flag, int type) {
        int sy;
        int sx;
        XScrollPanePeer.checkSecurity();
        ScrollPane sp = (ScrollPane)this.target;
        Component c = this.getScrollChild();
        if (c == null) {
            return;
        }
        Color[] colors = this.getGUIcolors();
        if (sp.getScrollbarDisplayPolicy() == 2) {
            sx = -x;
            sy = -y;
        } else {
            Graphics g;
            Point p = c.location();
            sx = p.x;
            sy = p.y;
            if ((flag & 2) != 0) {
                this.hsb.setValue(Math.min(x, this.hsb.getMaximum() - this.hsb.getVisibleAmount()));
                ScrollPaneAdjustable hadj = (ScrollPaneAdjustable)sp.getHAdjustable();
                this.setAdjustableValue(hadj, this.hsb.getValue(), type);
                sx = -this.hsb.getValue();
                g = this.getGraphics();
                try {
                    this.paintHorScrollbar(g, colors, true);
                    Object var14_13 = null;
                    g.dispose();
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    g.dispose();
                    throw throwable;
                }
            }
            if ((flag & 1) != 0) {
                this.vsb.setValue(Math.min(y, this.vsb.getMaximum() - this.vsb.getVisibleAmount()));
                ScrollPaneAdjustable vadj = (ScrollPaneAdjustable)sp.getVAdjustable();
                this.setAdjustableValue(vadj, this.vsb.getValue(), type);
                sy = -this.vsb.getValue();
                g = this.getGraphics();
                try {
                    this.paintVerScrollbar(g, colors, true);
                    Object var16_16 = null;
                    g.dispose();
                }
                catch (Throwable throwable) {
                    Object var16_17 = null;
                    g.dispose();
                    throw throwable;
                }
            }
        }
        c.move(sx, sy);
    }

    void setAdjustableValue(ScrollPaneAdjustable adj, int value, int type) {
        try {
            m_setValue.invoke(adj, value, type);
        }
        catch (IllegalAccessException iae) {
            adj.setValue(value);
        }
        catch (IllegalArgumentException iae2) {
            adj.setValue(value);
        }
        catch (InvocationTargetException ite) {
            adj.setValue(value);
            ite.getCause().printStackTrace();
        }
    }

    public void paint(Graphics g) {
        this.paintComponent(g);
    }

    void paintScrollBars(Graphics g, Color[] colors) {
        if (this.vsbSpace > 0) {
            this.paintVerScrollbar(g, colors, true);
        }
        if (this.hsbSpace > 0) {
            this.paintHorScrollbar(g, colors, true);
        }
    }

    void repaintScrollBars() {
        Graphics g = this.getGraphics();
        Color[] colors = this.getGUIcolors();
        if (g != null) {
            this.paintScrollBars(g, colors);
        }
        g.dispose();
    }

    public void repaintScrollbarRequest(XScrollbar sb) {
        Graphics g = this.getGraphics();
        Color[] colors = this.getGUIcolors();
        if (g != null) {
            if (sb == this.vsb) {
                this.paintVerScrollbar(g, colors, true);
            } else if (sb == this.hsb) {
                this.paintHorScrollbar(g, colors, true);
            }
        }
    }

    public void paintComponent(Graphics g) {
        Color[] colors = this.getGUIcolors();
        g.setColor(colors[0]);
        int h = this.height - this.hsbSpace;
        int w = this.width - this.vsbSpace;
        g.fillRect(0, 0, w, h);
        g.fillRect(w, h, this.vsbSpace, this.hsbSpace);
        this.draw3DRect(g, colors, 0, 0, w - 1, h - 1, false);
        this.paintScrollBars(g, colors);
    }

    public void handleEvent(AWTEvent e) {
        super.handleEvent(e);
        int id = e.getID();
        switch (id) {
            case 800: 
            case 801: {
                this.repaintScrollBars();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintHorScrollbar(Graphics g, Color[] colors, boolean paintAll) {
        if (this.hsbSpace <= 0) {
            return;
        }
        Graphics ng = g.create();
        g.setColor(colors[0]);
        int w = this.width - this.vsbSpace - 2;
        g.fillRect(1, this.height - SCROLLBAR, w, 2);
        g.fillRect(0, this.height - SCROLLBAR, 1, SCROLLBAR);
        g.fillRect(1 + w, this.height - SCROLLBAR, 1, SCROLLBAR);
        try {
            ng.translate(1, this.height - (SCROLLBAR - 2));
            this.hsb.paint(ng, colors, paintAll);
            Object var7_6 = null;
            ng.dispose();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ng.dispose();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintVerScrollbar(Graphics g, Color[] colors, boolean paintAll) {
        if (this.vsbSpace <= 0) {
            return;
        }
        Graphics ng = g.create();
        g.setColor(colors[0]);
        int h = this.height - this.hsbSpace - 2;
        g.fillRect(this.width - SCROLLBAR, 1, 2, h);
        g.fillRect(this.width - SCROLLBAR, 0, SCROLLBAR, 1);
        g.fillRect(this.width - SCROLLBAR, 1 + h, SCROLLBAR, 1);
        try {
            ng.translate(this.width - (SCROLLBAR - 2), 1);
            this.vsb.paint(ng, colors, paintAll);
            Object var7_6 = null;
            ng.dispose();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ng.dispose();
            throw throwable;
        }
    }

    public void handleJavaMouseEvent(MouseEvent mouseEvent) {
        super.handleJavaMouseEvent(mouseEvent);
        int modifiers = mouseEvent.getModifiers();
        int id = mouseEvent.getID();
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        if ((modifiers & 0x10) == 0) {
            return;
        }
        switch (id) {
            case 501: {
                if (this.inVerticalScrollbar(x, y)) {
                    this.active = 1;
                    int h = this.height - this.hsbSpace - 2;
                    this.vsb.handleMouseEvent(id, modifiers, x - (this.width - SCROLLBAR + 2), y - 1);
                    break;
                }
                if (!this.inHorizontalScrollbar(x, y)) break;
                this.active = 2;
                int w = this.width - 2 - this.vsbSpace;
                this.hsb.handleMouseEvent(id, modifiers, x - 1, y - (this.height - SCROLLBAR + 2));
                break;
            }
            case 502: {
                if (this.active == 1) {
                    this.vsb.handleMouseEvent(id, modifiers, x, y);
                    break;
                }
                if (this.active != 2) break;
                this.hsb.handleMouseEvent(id, modifiers, x, y);
                break;
            }
            case 506: {
                if (this.active == 1) {
                    int h = this.height - 2 - this.hsbSpace;
                    this.vsb.handleMouseEvent(id, modifiers, x - (this.width - SCROLLBAR + 2), y - 1);
                    break;
                }
                if (this.active != 2) break;
                int w = this.width - 2 - this.vsbSpace;
                this.hsb.handleMouseEvent(id, modifiers, x - 1, y - (this.height - SCROLLBAR + 2));
            }
        }
    }

    public void notifyValue(XScrollbar obj, int type, int v, boolean isAdjusting) {
        if (obj == this.vsb) {
            this.scroll(-1, v, 1, type);
        } else if ((XHorizontalScrollbar)obj == this.hsb) {
            this.scroll(v, -1, 2, type);
        }
    }

    boolean inVerticalScrollbar(int x, int y) {
        if (this.vsbSpace <= 0) {
            return false;
        }
        int h = this.height - 1 - this.hsbSpace;
        return x >= this.width - (SCROLLBAR - 2) && x < this.width && y >= 1 && y < h;
    }

    boolean inHorizontalScrollbar(int x, int y) {
        if (this.hsbSpace <= 0) {
            return false;
        }
        int w = this.width - 1 - this.vsbSpace;
        return x >= 1 && x < w && y >= this.height - (SCROLLBAR - 2) && y < this.height;
    }

    private Component getScrollChild() {
        ScrollPane sp = (ScrollPane)this.target;
        Component child = null;
        try {
            child = sp.getComponent(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics g) {
        Graphics ng;
        ScrollPane sp = (ScrollPane)this.target;
        Dimension d = sp.size();
        Color bg = sp.getBackground();
        Color fg = sp.getForeground();
        Point p = sp.getScrollPosition();
        Component c = this.getScrollChild();
        Dimension cd = c != null ? c.size() : new Dimension(0, 0);
        int sbDisplay = sp.getScrollbarDisplayPolicy();
        switch (sbDisplay) {
            case 2: {
                this.vsbSpace = 0;
                this.hsbSpace = 0;
                break;
            }
            case 1: {
                this.hsbSpace = this.vsbSpace = SCROLLBAR;
                break;
            }
            case 0: {
                this.hsbSpace = cd.width <= d.width - 2 ? 0 : SCROLLBAR;
                int n = this.vsbSpace = cd.height <= d.height - 2 ? 0 : SCROLLBAR;
                if (this.hsbSpace == 0 && this.vsbSpace != 0) {
                    int n2 = this.hsbSpace = cd.width <= d.width - SCROLLBAR - 2 ? 0 : SCROLLBAR;
                }
                if (this.vsbSpace != 0 || this.hsbSpace == 0) break;
                this.vsbSpace = cd.height <= d.height - SCROLLBAR - 2 ? 0 : SCROLLBAR;
            }
        }
        int hval = 0;
        int vval = 0;
        int hmax = 0;
        int vmax = 0;
        int hmin = 0;
        int vmin = 0;
        int hvis = 0;
        int vvis = 0;
        if (this.vsbSpace > 0) {
            vmin = 0;
            vvis = d.height - 2 - this.hsbSpace;
            vmax = Math.max(cd.height - vvis, 0);
            vval = p.y;
        }
        if (this.hsbSpace > 0) {
            hmin = 0;
            hvis = d.width - 2 - this.vsbSpace;
            hmax = Math.max(cd.width - hvis, 0);
            hval = p.x;
        }
        int w = d.width - this.vsbSpace;
        int h = d.height - this.hsbSpace;
        g.setColor(bg);
        g.fillRect(0, 0, d.width, d.height);
        if (this.hsbSpace > 0) {
            int sbw = d.width - this.vsbSpace;
            g.fillRect(1, d.height - SCROLLBAR - 3, sbw - 1, SCROLLBAR - 3);
            ng = g.create();
            try {
                ng.translate(0, d.height - (SCROLLBAR - 2));
                this.drawScrollbar(ng, bg, SCROLLBAR - 2, sbw, hmin, hmax, hval, hvis, true);
                Object var23_22 = null;
                ng.dispose();
            }
            catch (Throwable throwable) {
                Object var23_23 = null;
                ng.dispose();
                throw throwable;
            }
        }
        if (this.vsbSpace > 0) {
            int sbh = d.height - this.hsbSpace;
            g.fillRect(d.width - SCROLLBAR - 3, 1, SCROLLBAR - 3, sbh - 1);
            ng = g.create();
            try {
                ng.translate(d.width - (SCROLLBAR - 2), 0);
                this.drawScrollbar(ng, bg, SCROLLBAR - 2, sbh, vmin, vmax, vval, vvis, false);
                Object var25_25 = null;
                ng.dispose();
            }
            catch (Throwable throwable) {
                Object var25_26 = null;
                ng.dispose();
                throw throwable;
            }
        }
        this.draw3DRect(g, bg, 0, 0, w - 1, h - 1, false);
        this.target.print(g);
        sp.printComponents(g);
    }

    static {
        m_setValue = SunToolkit.getMethod(ScrollPaneAdjustable.class, "setTypedValue", new Class[]{Integer.TYPE, Integer.TYPE});
        SCROLLBAR = XToolkit.getUIDefaults().getInt("ScrollBar.defaultWidth");
    }

    static class XScrollPaneContentWindow
    extends XWindow {
        XScrollPaneContentWindow(ScrollPane target, long parentWindow) {
            super(target, parentWindow);
        }

        public String getWMName() {
            return "ScrollPane content";
        }
    }
}

