/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.PathPlaceHolder;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeSelectionModel
implements Cloneable,
Serializable,
TreeSelectionModel {
    public static final String SELECTION_MODE_PROPERTY = "selectionMode";
    protected SwingPropertyChangeSupport changeSupport;
    protected TreePath[] selection;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient RowMapper rowMapper;
    protected DefaultListSelectionModel listSelectionModel = new DefaultListSelectionModel();
    protected int selectionMode = 4;
    protected TreePath leadPath;
    protected int leadIndex = -1;
    protected int leadRow = -1;
    private Hashtable uniquePaths = new Hashtable();
    private Hashtable lastPaths = new Hashtable();
    private TreePath[] tempPaths = new TreePath[1];

    @Override
    public void setRowMapper(RowMapper newMapper) {
        this.rowMapper = newMapper;
        this.resetRowSelection();
    }

    @Override
    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    @Override
    public void setSelectionMode(int mode) {
        int oldMode = this.selectionMode;
        this.selectionMode = mode;
        if (this.selectionMode != 1 && this.selectionMode != 2 && this.selectionMode != 4) {
            this.selectionMode = 4;
        }
        if (oldMode != this.selectionMode && this.changeSupport != null) {
            this.changeSupport.firePropertyChange(SELECTION_MODE_PROPERTY, new Integer(oldMode), new Integer(this.selectionMode));
        }
    }

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void setSelectionPath(TreePath path) {
        if (path == null) {
            this.setSelectionPaths(null);
        } else {
            TreePath[] newPaths = new TreePath[]{path};
            this.setSelectionPaths(newPaths);
        }
    }

    @Override
    public void setSelectionPaths(TreePath[] pPaths) {
        int oldCount;
        TreePath[] paths = pPaths;
        int newCount = paths == null ? 0 : paths.length;
        if (newCount + (oldCount = this.selection == null ? 0 : this.selection.length) != 0) {
            TreePath[] newSelection;
            if (this.selectionMode == 1) {
                if (newCount > 1) {
                    paths = new TreePath[]{pPaths[0]};
                    newCount = 1;
                }
            } else if (this.selectionMode == 2 && newCount > 0 && !this.arePathsContiguous(paths)) {
                paths = new TreePath[]{pPaths[0]};
                newCount = 1;
            }
            int validCount = 0;
            TreePath beginLeadPath = this.leadPath;
            Vector<PathPlaceHolder> cPaths = new Vector<PathPlaceHolder>(newCount + oldCount);
            this.lastPaths.clear();
            this.leadPath = null;
            for (int newCounter = 0; newCounter < newCount; ++newCounter) {
                if (paths[newCounter] == null || this.lastPaths.get(paths[newCounter]) != null) continue;
                ++validCount;
                this.lastPaths.put(paths[newCounter], Boolean.TRUE);
                if (this.uniquePaths.get(paths[newCounter]) == null) {
                    cPaths.addElement(new PathPlaceHolder(paths[newCounter], true));
                }
                this.leadPath = paths[newCounter];
            }
            if (validCount == 0) {
                newSelection = null;
            } else if (validCount != newCount) {
                Enumeration keys = this.lastPaths.keys();
                newSelection = new TreePath[validCount];
                validCount = 0;
                while (keys.hasMoreElements()) {
                    newSelection[validCount++] = (TreePath)keys.nextElement();
                }
            } else {
                newSelection = new TreePath[paths.length];
                System.arraycopy(paths, 0, newSelection, 0, paths.length);
            }
            for (int oldCounter = 0; oldCounter < oldCount; ++oldCounter) {
                if (this.selection[oldCounter] == null || this.lastPaths.get(this.selection[oldCounter]) != null) continue;
                cPaths.addElement(new PathPlaceHolder(this.selection[oldCounter], false));
            }
            this.selection = newSelection;
            Hashtable tempHT = this.uniquePaths;
            this.uniquePaths = this.lastPaths;
            this.lastPaths = tempHT;
            this.lastPaths.clear();
            if (this.selection != null) {
                this.insureUniqueness();
            }
            this.updateLeadIndex();
            this.resetRowSelection();
            if (cPaths.size() > 0) {
                this.notifyPathChange(cPaths, beginLeadPath);
            }
        }
    }

    @Override
    public void addSelectionPath(TreePath path) {
        if (path != null) {
            TreePath[] toAdd = new TreePath[]{path};
            this.addSelectionPaths(toAdd);
        }
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        int newPathLength;
        int n = newPathLength = paths == null ? 0 : paths.length;
        if (newPathLength > 0) {
            if (this.selectionMode == 1) {
                this.setSelectionPaths(paths);
            } else if (this.selectionMode == 2 && !this.canPathsBeAdded(paths)) {
                if (this.arePathsContiguous(paths)) {
                    this.setSelectionPaths(paths);
                } else {
                    TreePath[] newPaths = new TreePath[]{paths[0]};
                    this.setSelectionPaths(newPaths);
                }
            } else {
                int counter;
                TreePath beginLeadPath = this.leadPath;
                Vector<PathPlaceHolder> cPaths = null;
                int oldCount = this.selection == null ? 0 : this.selection.length;
                this.lastPaths.clear();
                int validCount = 0;
                for (counter = 0; counter < newPathLength; ++counter) {
                    if (paths[counter] == null) continue;
                    if (this.uniquePaths.get(paths[counter]) == null) {
                        ++validCount;
                        if (cPaths == null) {
                            cPaths = new Vector<PathPlaceHolder>();
                        }
                        cPaths.addElement(new PathPlaceHolder(paths[counter], true));
                        this.uniquePaths.put(paths[counter], Boolean.TRUE);
                        this.lastPaths.put(paths[counter], Boolean.TRUE);
                    }
                    this.leadPath = paths[counter];
                }
                if (this.leadPath == null) {
                    this.leadPath = beginLeadPath;
                }
                if (validCount > 0) {
                    TreePath[] newSelection = new TreePath[oldCount + validCount];
                    if (oldCount > 0) {
                        System.arraycopy(this.selection, 0, newSelection, 0, oldCount);
                    }
                    if (validCount != paths.length) {
                        Enumeration newPaths = this.lastPaths.keys();
                        counter = oldCount;
                        while (newPaths.hasMoreElements()) {
                            newSelection[counter++] = (TreePath)newPaths.nextElement();
                        }
                    } else {
                        System.arraycopy(paths, 0, newSelection, oldCount, validCount);
                    }
                    this.selection = newSelection;
                    this.insureUniqueness();
                    this.updateLeadIndex();
                    this.resetRowSelection();
                    this.notifyPathChange(cPaths, beginLeadPath);
                } else {
                    this.leadPath = beginLeadPath;
                }
                this.lastPaths.clear();
            }
        }
    }

    @Override
    public void removeSelectionPath(TreePath path) {
        if (path != null) {
            TreePath[] rPath = new TreePath[]{path};
            this.removeSelectionPaths(rPath);
        }
    }

    @Override
    public void removeSelectionPaths(TreePath[] paths) {
        if (paths != null && this.selection != null && paths.length > 0) {
            if (!this.canPathsBeRemoved(paths)) {
                this.clearSelection();
            } else {
                Vector<PathPlaceHolder> pathsToRemove = null;
                for (int removeCounter = paths.length - 1; removeCounter >= 0; --removeCounter) {
                    if (paths[removeCounter] == null || this.uniquePaths.get(paths[removeCounter]) == null) continue;
                    if (pathsToRemove == null) {
                        pathsToRemove = new Vector<PathPlaceHolder>(paths.length);
                    }
                    this.uniquePaths.remove(paths[removeCounter]);
                    pathsToRemove.addElement(new PathPlaceHolder(paths[removeCounter], false));
                }
                if (pathsToRemove != null) {
                    int removeCount = pathsToRemove.size();
                    TreePath beginLeadPath = this.leadPath;
                    if (removeCount == this.selection.length) {
                        this.selection = null;
                    } else {
                        Enumeration pEnum = this.uniquePaths.keys();
                        int validCount = 0;
                        this.selection = new TreePath[this.selection.length - removeCount];
                        while (pEnum.hasMoreElements()) {
                            this.selection[validCount++] = (TreePath)pEnum.nextElement();
                        }
                    }
                    this.leadPath = this.leadPath != null && this.uniquePaths.get(this.leadPath) == null ? (this.selection != null ? this.selection[this.selection.length - 1] : null) : (this.selection != null ? this.selection[this.selection.length - 1] : null);
                    this.updateLeadIndex();
                    this.resetRowSelection();
                    this.notifyPathChange(pathsToRemove, beginLeadPath);
                }
            }
        }
    }

    @Override
    public TreePath getSelectionPath() {
        if (this.selection != null) {
            return this.selection[0];
        }
        return null;
    }

    @Override
    public TreePath[] getSelectionPaths() {
        if (this.selection != null) {
            int pathSize = this.selection.length;
            TreePath[] result = new TreePath[pathSize];
            System.arraycopy(this.selection, 0, result, 0, pathSize);
            return result;
        }
        return null;
    }

    @Override
    public int getSelectionCount() {
        return this.selection == null ? 0 : this.selection.length;
    }

    @Override
    public boolean isPathSelected(TreePath path) {
        return path != null ? this.uniquePaths.get(path) != null : false;
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selection == null;
    }

    @Override
    public void clearSelection() {
        if (this.selection != null) {
            int selSize = this.selection.length;
            boolean[] newness = new boolean[selSize];
            for (int counter = 0; counter < selSize; ++counter) {
                newness[counter] = false;
            }
            TreeSelectionEvent event = new TreeSelectionEvent((Object)this, this.selection, newness, this.leadPath, null);
            this.leadPath = null;
            this.leadRow = -1;
            this.leadIndex = -1;
            this.uniquePaths.clear();
            this.selection = null;
            this.resetRowSelection();
            this.fireValueChanged(event);
        }
    }

    @Override
    public void addTreeSelectionListener(TreeSelectionListener x) {
        this.listenerList.add(TreeSelectionListener.class, x);
    }

    @Override
    public void removeTreeSelectionListener(TreeSelectionListener x) {
        this.listenerList.remove(TreeSelectionListener.class, x);
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        return (TreeSelectionListener[])this.listenerList.getListeners(TreeSelectionListener.class);
    }

    protected void fireValueChanged(TreeSelectionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeSelectionListener.class) continue;
            ((TreeSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    @Override
    public int[] getSelectionRows() {
        if (this.rowMapper != null && this.selection != null) {
            int[] rows = this.rowMapper.getRowsForPaths(this.selection);
            if (rows != null) {
                int invisCount = 0;
                for (int counter = rows.length - 1; counter >= 0; --counter) {
                    if (rows[counter] != -1) continue;
                    ++invisCount;
                }
                if (invisCount > 0) {
                    if (invisCount == rows.length) {
                        rows = null;
                    } else {
                        int[] tempRows = new int[rows.length - invisCount];
                        int visCounter = 0;
                        for (int counter = rows.length - 1; counter >= 0; --counter) {
                            if (rows[counter] == -1) continue;
                            tempRows[visCounter++] = rows[counter];
                        }
                        rows = tempRows;
                    }
                }
            }
            return rows;
        }
        return null;
    }

    @Override
    public int getMinSelectionRow() {
        return this.listSelectionModel.getMinSelectionIndex();
    }

    @Override
    public int getMaxSelectionRow() {
        return this.listSelectionModel.getMaxSelectionIndex();
    }

    @Override
    public boolean isRowSelected(int row) {
        return this.listSelectionModel.isSelectedIndex(row);
    }

    @Override
    public void resetRowSelection() {
        this.listSelectionModel.clearSelection();
        if (this.selection != null && this.rowMapper != null) {
            boolean validCount = false;
            int[] rows = this.rowMapper.getRowsForPaths(this.selection);
            int maxCounter = this.selection.length;
            for (int counter = 0; counter < maxCounter; ++counter) {
                int aRow = rows[counter];
                if (aRow == -1) continue;
                this.listSelectionModel.addSelectionInterval(aRow, aRow);
            }
            if (this.leadIndex != -1 && rows != null) {
                this.leadRow = rows[this.leadIndex];
            } else if (this.leadPath != null) {
                this.tempPaths[0] = this.leadPath;
                rows = this.rowMapper.getRowsForPaths(this.tempPaths);
                this.leadRow = rows != null ? rows[0] : -1;
            } else {
                this.leadRow = -1;
            }
            this.insureRowContinuity();
        } else {
            this.leadRow = -1;
        }
    }

    @Override
    public int getLeadSelectionRow() {
        return this.leadRow;
    }

    @Override
    public TreePath getLeadSelectionPath() {
        return this.leadPath;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected void insureRowContinuity() {
        if (this.selectionMode == 2 && this.selection != null && this.rowMapper != null) {
            DefaultListSelectionModel lModel = this.listSelectionModel;
            int min = lModel.getMinSelectionIndex();
            if (min != -1) {
                int maxCounter = lModel.getMaxSelectionIndex();
                for (int counter = min; counter <= maxCounter; ++counter) {
                    if (lModel.isSelectedIndex(counter)) continue;
                    if (counter == min) {
                        this.clearSelection();
                        continue;
                    }
                    TreePath[] newSel = new TreePath[counter - min];
                    int[] selectionIndex = this.rowMapper.getRowsForPaths(this.selection);
                    for (int i = 0; i < selectionIndex.length; ++i) {
                        if (selectionIndex[i] >= counter) continue;
                        newSel[selectionIndex[i] - min] = this.selection[i];
                    }
                    this.setSelectionPaths(newSel);
                    break;
                }
            }
        } else if (this.selectionMode == 1 && this.selection != null && this.selection.length > 1) {
            this.setSelectionPath(this.selection[0]);
        }
    }

    protected boolean arePathsContiguous(TreePath[] paths) {
        int counter;
        if (this.rowMapper == null || paths.length < 2) {
            return true;
        }
        BitSet bitSet = new BitSet(32);
        int pathCount = paths.length;
        int validCount = 0;
        TreePath[] tempPath = new TreePath[]{paths[0]};
        int min = this.rowMapper.getRowsForPaths(tempPath)[0];
        for (counter = 0; counter < pathCount; ++counter) {
            if (paths[counter] == null) continue;
            tempPath[0] = paths[counter];
            int[] rows = this.rowMapper.getRowsForPaths(tempPath);
            if (rows == null) {
                return false;
            }
            int anIndex = rows[0];
            if (anIndex == -1 || anIndex < min - pathCount || anIndex > min + pathCount) {
                return false;
            }
            if (anIndex < min) {
                min = anIndex;
            }
            if (bitSet.get(anIndex)) continue;
            bitSet.set(anIndex);
            ++validCount;
        }
        int maxCounter = validCount + min;
        for (counter = min; counter < maxCounter; ++counter) {
            if (bitSet.get(counter)) continue;
            return false;
        }
        return true;
    }

    protected boolean canPathsBeAdded(TreePath[] paths) {
        int counter;
        if (paths == null || paths.length == 0 || this.rowMapper == null || this.selection == null || this.selectionMode == 4) {
            return true;
        }
        BitSet bitSet = new BitSet();
        DefaultListSelectionModel lModel = this.listSelectionModel;
        int min = lModel.getMinSelectionIndex();
        int max = lModel.getMaxSelectionIndex();
        TreePath[] tempPath = new TreePath[1];
        if (min != -1) {
            for (counter = min; counter <= max; ++counter) {
                if (!lModel.isSelectedIndex(counter)) continue;
                bitSet.set(counter);
            }
        } else {
            tempPath[0] = paths[0];
            min = max = this.rowMapper.getRowsForPaths(tempPath)[0];
        }
        for (counter = paths.length - 1; counter >= 0; --counter) {
            if (paths[counter] == null) continue;
            tempPath[0] = paths[counter];
            int[] rows = this.rowMapper.getRowsForPaths(tempPath);
            if (rows == null) {
                return false;
            }
            int anIndex = rows[0];
            min = Math.min(anIndex, min);
            max = Math.max(anIndex, max);
            if (anIndex == -1) {
                return false;
            }
            bitSet.set(anIndex);
        }
        for (counter = min; counter <= max; ++counter) {
            if (bitSet.get(counter)) continue;
            return false;
        }
        return true;
    }

    protected boolean canPathsBeRemoved(TreePath[] paths) {
        int counter;
        if (this.rowMapper == null || this.selection == null || this.selectionMode == 4) {
            return true;
        }
        BitSet bitSet = new BitSet();
        int pathCount = paths.length;
        int min = -1;
        int validCount = 0;
        TreePath[] tempPath = new TreePath[1];
        this.lastPaths.clear();
        for (counter = 0; counter < pathCount; ++counter) {
            if (paths[counter] == null) continue;
            this.lastPaths.put(paths[counter], Boolean.TRUE);
        }
        for (counter = this.selection.length - 1; counter >= 0; --counter) {
            if (this.lastPaths.get(this.selection[counter]) != null) continue;
            tempPath[0] = this.selection[counter];
            int[] rows = this.rowMapper.getRowsForPaths(tempPath);
            if (rows == null || rows[0] == -1 || bitSet.get(rows[0])) continue;
            ++validCount;
            min = min == -1 ? rows[0] : Math.min(min, rows[0]);
            bitSet.set(rows[0]);
        }
        this.lastPaths.clear();
        if (validCount > 1) {
            for (counter = min + validCount - 1; counter >= min; --counter) {
                if (bitSet.get(counter)) continue;
                return false;
            }
        }
        return true;
    }

    protected void notifyPathChange(Vector<PathPlaceHolder> changedPaths, TreePath oldLeadSelection) {
        int cPathCount = changedPaths.size();
        boolean[] newness = new boolean[cPathCount];
        TreePath[] paths = new TreePath[cPathCount];
        for (int counter = 0; counter < cPathCount; ++counter) {
            PathPlaceHolder placeholder = changedPaths.elementAt(counter);
            newness[counter] = placeholder.isNew;
            paths[counter] = placeholder.path;
        }
        TreeSelectionEvent event = new TreeSelectionEvent((Object)this, paths, newness, oldLeadSelection, this.leadPath);
        this.fireValueChanged(event);
    }

    protected void updateLeadIndex() {
        if (this.leadPath != null) {
            if (this.selection == null) {
                this.leadPath = null;
                this.leadRow = -1;
                this.leadIndex = -1;
            } else {
                this.leadIndex = -1;
                this.leadRow = -1;
                for (int counter = this.selection.length - 1; counter >= 0; --counter) {
                    if (this.selection[counter] != this.leadPath) continue;
                    this.leadIndex = counter;
                    break;
                }
            }
        } else {
            this.leadIndex = -1;
        }
    }

    protected void insureUniqueness() {
    }

    public String toString() {
        int selCount = this.getSelectionCount();
        StringBuffer retBuffer = new StringBuffer();
        int[] rows = this.rowMapper != null ? this.rowMapper.getRowsForPaths(this.selection) : null;
        retBuffer.append(this.getClass().getName() + " " + this.hashCode() + " [ ");
        for (int counter = 0; counter < selCount; ++counter) {
            if (rows != null) {
                retBuffer.append(this.selection[counter].toString() + "@" + Integer.toString(rows[counter]) + " ");
                continue;
            }
            retBuffer.append(this.selection[counter].toString() + " ");
        }
        retBuffer.append("]");
        return retBuffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultTreeSelectionModel clone = (DefaultTreeSelectionModel)super.clone();
        clone.changeSupport = null;
        if (this.selection != null) {
            int selLength = this.selection.length;
            clone.selection = new TreePath[selLength];
            System.arraycopy(this.selection, 0, clone.selection, 0, selLength);
        }
        clone.listenerList = new EventListenerList();
        clone.listSelectionModel = (DefaultListSelectionModel)this.listSelectionModel.clone();
        clone.uniquePaths = new Hashtable();
        clone.lastPaths = new Hashtable();
        clone.tempPaths = new TreePath[1];
        return clone;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Object[] tValues = this.rowMapper != null && this.rowMapper instanceof Serializable ? new Object[]{"rowMapper", this.rowMapper} : new Object[]{};
        s.writeObject(tValues);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object[] tValues = (Object[])s.readObject();
        if (tValues.length > 0 && tValues[0].equals("rowMapper")) {
            this.rowMapper = (RowMapper)tValues[1];
        }
    }
}

