/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProviderException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import sun.misc.HexDumpEncoder;
import sun.security.internal.interfaces.TlsMasterSecret;
import sun.security.internal.spec.TlsKeyMaterialParameterSpec;
import sun.security.internal.spec.TlsKeyMaterialSpec;
import sun.security.internal.spec.TlsMasterSecretParameterSpec;
import sun.security.ssl.CipherBox;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.Debug;
import sun.security.ssl.EngineOutputRecord;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.InputRecord;
import sun.security.ssl.JsseJce;
import sun.security.ssl.MAC;
import sun.security.ssl.OutputRecord;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RSAClientKeyExchange;
import sun.security.ssl.RandomCookie;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SSLSocketImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Handshaker {
    ProtocolVersion protocolVersion;
    ProtocolVersion activeProtocolVersion;
    boolean secureRenegotiation;
    byte[] clientVerifyData;
    byte[] serverVerifyData;
    boolean isInitialHandshake;
    ProtocolList enabledProtocols;
    private boolean isClient;
    SSLSocketImpl conn = null;
    SSLEngineImpl engine = null;
    HandshakeHash handshakeHash;
    HandshakeInStream input;
    HandshakeOutStream output;
    int state;
    SSLContextImpl sslContext;
    RandomCookie clnt_random;
    RandomCookie svr_random;
    SSLSessionImpl session;
    private MessageDigest md5Tmp;
    private MessageDigest shaTmp;
    CipherSuiteList enabledCipherSuites;
    CipherSuite cipherSuite;
    CipherSuite.KeyExchange keyExchange;
    boolean resumingSession;
    boolean enableNewSession;
    private SecretKey clntWriteKey;
    private SecretKey svrWriteKey;
    private IvParameterSpec clntWriteIV;
    private IvParameterSpec svrWriteIV;
    private SecretKey clntMacSecret;
    private SecretKey svrMacSecret;
    private volatile boolean taskDelegated = false;
    private volatile DelegatedTask delegatedTask = null;
    private volatile Exception thrown = null;
    private Object thrownLock = new Object();
    static final Debug debug = Debug.getInstance("ssl");
    static final boolean allowUnsafeRenegotiation = Debug.getBooleanProperty("sun.security.ssl.allowUnsafeRenegotiation", false);
    static final boolean allowLegacyHelloMessages = Debug.getBooleanProperty("sun.security.ssl.allowLegacyHelloMessages", true);
    boolean invalidated;

    Handshaker(SSLSocketImpl c, SSLContextImpl context, ProtocolList enabledProtocols, boolean needCertVerify, boolean isClient, ProtocolVersion activeProtocolVersion, boolean isInitialHandshake, boolean secureRenegotiation, byte[] clientVerifyData, byte[] serverVerifyData) {
        this.conn = c;
        this.init(context, enabledProtocols, needCertVerify, isClient, activeProtocolVersion, isInitialHandshake, secureRenegotiation, clientVerifyData, serverVerifyData);
    }

    Handshaker(SSLEngineImpl engine, SSLContextImpl context, ProtocolList enabledProtocols, boolean needCertVerify, boolean isClient, ProtocolVersion activeProtocolVersion, boolean isInitialHandshake, boolean secureRenegotiation, byte[] clientVerifyData, byte[] serverVerifyData) {
        this.engine = engine;
        this.init(context, enabledProtocols, needCertVerify, isClient, activeProtocolVersion, isInitialHandshake, secureRenegotiation, clientVerifyData, serverVerifyData);
    }

    private void init(SSLContextImpl context, ProtocolList enabledProtocols, boolean needCertVerify, boolean isClient, ProtocolVersion activeProtocolVersion, boolean isInitialHandshake, boolean secureRenegotiation, byte[] clientVerifyData, byte[] serverVerifyData) {
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("Allow unsafe renegotiation: " + allowUnsafeRenegotiation + "\nAllow legacy hello messages: " + allowLegacyHelloMessages + "\nIs initial handshake: " + isInitialHandshake + "\nIs secure renegotiation: " + secureRenegotiation);
        }
        this.sslContext = context;
        this.isClient = isClient;
        this.activeProtocolVersion = activeProtocolVersion;
        this.isInitialHandshake = isInitialHandshake;
        this.secureRenegotiation = secureRenegotiation;
        this.clientVerifyData = clientVerifyData;
        this.serverVerifyData = serverVerifyData;
        this.enableNewSession = true;
        this.invalidated = false;
        this.setCipherSuite(CipherSuite.C_NULL);
        this.md5Tmp = JsseJce.getMD5();
        this.shaTmp = JsseJce.getSHA();
        this.handshakeHash = new HandshakeHash(needCertVerify);
        this.setEnabledProtocols(enabledProtocols);
        if (this.conn != null) {
            this.conn.getAppInputStream().r.setHandshakeHash(this.handshakeHash);
        } else {
            this.engine.inputRecord.setHandshakeHash(this.handshakeHash);
        }
        this.state = -1;
    }

    void fatalSE(byte b, String diagnostic) throws IOException {
        this.fatalSE(b, diagnostic, null);
    }

    void fatalSE(byte b, Throwable cause) throws IOException {
        this.fatalSE(b, null, cause);
    }

    void fatalSE(byte b, String diagnostic, Throwable cause) throws IOException {
        if (this.conn != null) {
            this.conn.fatal(b, diagnostic, cause);
        } else {
            this.engine.fatal(b, diagnostic, cause);
        }
    }

    void warningSE(byte b) {
        if (this.conn != null) {
            this.conn.warning(b);
        } else {
            this.engine.warning(b);
        }
    }

    String getHostSE() {
        if (this.conn != null) {
            return this.conn.getHost();
        }
        return this.engine.getPeerHost();
    }

    String getHostAddressSE() {
        if (this.conn != null) {
            return this.conn.getInetAddress().getHostAddress();
        }
        return this.engine.getPeerHost();
    }

    boolean isLoopbackSE() {
        if (this.conn != null) {
            return this.conn.getInetAddress().isLoopbackAddress();
        }
        return false;
    }

    int getPortSE() {
        if (this.conn != null) {
            return this.conn.getPort();
        }
        return this.engine.getPeerPort();
    }

    int getLocalPortSE() {
        if (this.conn != null) {
            return this.conn.getLocalPort();
        }
        return -1;
    }

    String getHostnameVerificationSE() {
        if (this.conn != null) {
            return this.conn.getHostnameVerification();
        }
        return this.engine.getHostnameVerification();
    }

    AccessControlContext getAccSE() {
        if (this.conn != null) {
            return this.conn.getAcc();
        }
        return this.engine.getAcc();
    }

    private void setVersionSE(ProtocolVersion protocolVersion) {
        if (this.conn != null) {
            this.conn.setVersion(protocolVersion);
        } else {
            this.engine.setVersion(protocolVersion);
        }
    }

    void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.setVersionSE(protocolVersion);
        this.output.r.setVersion(protocolVersion);
    }

    void setEnabledProtocols(ProtocolList enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
        this.protocolVersion = enabledProtocols.max;
        ProtocolVersion helloVersion = enabledProtocols.helloVersion;
        this.input = new HandshakeInStream(this.handshakeHash);
        if (this.conn != null) {
            this.output = new HandshakeOutStream(this.protocolVersion, helloVersion, this.handshakeHash, this.conn);
            this.conn.getAppInputStream().r.setHelloVersion(helloVersion);
        } else {
            this.output = new HandshakeOutStream(this.protocolVersion, helloVersion, this.handshakeHash, this.engine);
            this.engine.outputRecord.setHelloVersion(helloVersion);
        }
    }

    void setCipherSuite(CipherSuite s) {
        this.cipherSuite = s;
        this.keyExchange = s.keyExchange;
    }

    boolean isNegotiable(CipherSuite s) {
        return this.enabledCipherSuites.contains(s) && s.isNegotiable();
    }

    void setEnableSessionCreation(boolean newSessions) {
        this.enableNewSession = newSessions;
    }

    CipherBox newReadCipher() throws NoSuchAlgorithmException {
        CipherBox box;
        CipherSuite.BulkCipher cipher = this.cipherSuite.cipher;
        if (this.isClient) {
            box = cipher.newCipher(this.protocolVersion, this.svrWriteKey, this.svrWriteIV, false);
            this.svrWriteKey = null;
            this.svrWriteIV = null;
        } else {
            box = cipher.newCipher(this.protocolVersion, this.clntWriteKey, this.clntWriteIV, false);
            this.clntWriteKey = null;
            this.clntWriteIV = null;
        }
        return box;
    }

    CipherBox newWriteCipher() throws NoSuchAlgorithmException {
        CipherBox box;
        CipherSuite.BulkCipher cipher = this.cipherSuite.cipher;
        if (this.isClient) {
            box = cipher.newCipher(this.protocolVersion, this.clntWriteKey, this.clntWriteIV, true);
            this.clntWriteKey = null;
            this.clntWriteIV = null;
        } else {
            box = cipher.newCipher(this.protocolVersion, this.svrWriteKey, this.svrWriteIV, true);
            this.svrWriteKey = null;
            this.svrWriteIV = null;
        }
        return box;
    }

    MAC newReadMAC() throws NoSuchAlgorithmException, InvalidKeyException {
        MAC mac;
        CipherSuite.MacAlg macAlg = this.cipherSuite.macAlg;
        if (this.isClient) {
            mac = macAlg.newMac(this.protocolVersion, this.svrMacSecret);
            this.svrMacSecret = null;
        } else {
            mac = macAlg.newMac(this.protocolVersion, this.clntMacSecret);
            this.clntMacSecret = null;
        }
        return mac;
    }

    MAC newWriteMAC() throws NoSuchAlgorithmException, InvalidKeyException {
        MAC mac;
        CipherSuite.MacAlg macAlg = this.cipherSuite.macAlg;
        if (this.isClient) {
            mac = macAlg.newMac(this.protocolVersion, this.clntMacSecret);
            this.clntMacSecret = null;
        } else {
            mac = macAlg.newMac(this.protocolVersion, this.svrMacSecret);
            this.svrMacSecret = null;
        }
        return mac;
    }

    boolean isDone() {
        return this.state == 20;
    }

    SSLSessionImpl getSession() {
        return this.session;
    }

    boolean isSecureRenegotiation() {
        return this.secureRenegotiation;
    }

    byte[] getClientVerifyData() {
        return this.clientVerifyData;
    }

    byte[] getServerVerifyData() {
        return this.serverVerifyData;
    }

    void process_record(InputRecord r, boolean expectingFinished) throws IOException {
        this.checkThrown();
        this.input.incomingRecord(r);
        if (this.conn != null || expectingFinished) {
            this.processLoop();
        } else {
            this.delegateTask(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Handshaker.this.processLoop();
                    return null;
                }
            });
        }
    }

    void processLoop() throws IOException {
        while (this.input.available() >= 4) {
            this.input.mark(4);
            byte messageType = (byte)this.input.getInt8();
            int messageLen = this.input.getInt24();
            if (this.input.available() < messageLen) {
                this.input.reset();
                return;
            }
            if (messageType == 0) {
                this.input.reset();
                this.processMessage(messageType, messageLen);
                this.input.ignore(4 + messageLen);
                continue;
            }
            this.input.mark(messageLen);
            this.processMessage(messageType, messageLen);
            this.input.digestNow();
        }
    }

    boolean started() {
        return this.state >= 0;
    }

    void kickstart() throws IOException {
        if (this.state >= 0) {
            return;
        }
        HandshakeMessage m = this.getKickstartMessage();
        if (debug != null && Debug.isOn("handshake")) {
            m.print(System.out);
        }
        m.write(this.output);
        this.output.flush();
        this.state = m.messageType();
    }

    abstract HandshakeMessage getKickstartMessage() throws SSLException;

    abstract void processMessage(byte var1, int var2) throws IOException;

    abstract void handshakeAlert(byte var1) throws SSLProtocolException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendChangeCipherSpec(HandshakeMessage.Finished mesg, boolean lastMessage) throws IOException {
        this.output.flush();
        OutputRecord r = this.conn != null ? new OutputRecord(20) : new EngineOutputRecord(20, this.engine);
        r.setVersion(this.protocolVersion);
        r.write(1);
        if (this.conn != null) {
            this.conn.writeLock.lock();
            try {
                this.conn.writeRecord(r);
                this.conn.changeWriteCiphers();
                if (debug != null && Debug.isOn("handshake")) {
                    mesg.print(System.out);
                }
                mesg.write(this.output);
                this.output.flush();
            }
            finally {
                this.conn.writeLock.unlock();
            }
        }
        Object object = this.engine.writeLock;
        synchronized (object) {
            this.engine.writeRecord((EngineOutputRecord)r);
            this.engine.changeWriteCiphers();
            if (debug != null && Debug.isOn("handshake")) {
                mesg.print(System.out);
            }
            mesg.write(this.output);
            if (lastMessage) {
                this.output.setFinishedMsg();
            }
            this.output.flush();
        }
    }

    void calculateKeys(SecretKey preMasterSecret, ProtocolVersion version) {
        SecretKey master = this.calculateMasterSecret(preMasterSecret, version);
        this.session.setMasterSecret(master);
        this.calculateConnectionKeys(master);
    }

    private SecretKey calculateMasterSecret(SecretKey preMasterSecret, ProtocolVersion requestedVersion) {
        boolean versionMismatch;
        SecretKey masterSecret;
        TlsMasterSecretParameterSpec spec = new TlsMasterSecretParameterSpec(preMasterSecret, (int)this.protocolVersion.major, (int)this.protocolVersion.minor, this.clnt_random.random_bytes, this.svr_random.random_bytes);
        if (debug != null && Debug.isOn("keygen")) {
            HexDumpEncoder dump = new HexDumpEncoder();
            System.out.println("SESSION KEYGEN:");
            System.out.println("PreMaster Secret:");
            Handshaker.printHex(dump, preMasterSecret.getEncoded());
        }
        try {
            KeyGenerator kg = JsseJce.getKeyGenerator("SunTlsMasterSecret");
            kg.init(spec);
            masterSecret = kg.generateKey();
        }
        catch (GeneralSecurityException e) {
            if (!preMasterSecret.getAlgorithm().equals("TlsRsaPremasterSecret")) {
                throw new ProviderException(e);
            }
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("RSA master secret generation error:");
                e.printStackTrace(System.out);
                System.out.println("Generating new random premaster secret");
            }
            preMasterSecret = RSAClientKeyExchange.generateDummySecret(this.protocolVersion);
            return this.calculateMasterSecret(preMasterSecret, null);
        }
        if (requestedVersion == null || !(masterSecret instanceof TlsMasterSecret)) {
            return masterSecret;
        }
        TlsMasterSecret tlsKey = (TlsMasterSecret)masterSecret;
        int major = tlsKey.getMajorVersion();
        int minor = tlsKey.getMinorVersion();
        if (major < 0 || minor < 0) {
            return masterSecret;
        }
        ProtocolVersion premasterVersion = ProtocolVersion.valueOf(major, minor);
        boolean bl = versionMismatch = premasterVersion != this.protocolVersion && premasterVersion.v != requestedVersion.v;
        if (!versionMismatch) {
            return masterSecret;
        }
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("RSA PreMasterSecret version error: expected" + this.protocolVersion + " or " + requestedVersion + ", decrypted: " + premasterVersion);
            System.out.println("Generating new random premaster secret");
        }
        preMasterSecret = RSAClientKeyExchange.generateDummySecret(this.protocolVersion);
        return this.calculateMasterSecret(preMasterSecret, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void calculateConnectionKeys(SecretKey masterKey) {
        int hashSize = this.cipherSuite.macAlg.size;
        boolean is_exportable = this.cipherSuite.exportable;
        CipherSuite.BulkCipher cipher = this.cipherSuite.cipher;
        int keySize = cipher.keySize;
        int ivSize = cipher.ivSize;
        int expandedKeySize = is_exportable ? cipher.expandedKeySize : 0;
        TlsKeyMaterialParameterSpec spec = new TlsKeyMaterialParameterSpec(masterKey, (int)this.protocolVersion.major, (int)this.protocolVersion.minor, this.clnt_random.random_bytes, this.svr_random.random_bytes, cipher.algorithm, cipher.keySize, expandedKeySize, cipher.ivSize, hashSize);
        try {
            KeyGenerator kg = JsseJce.getKeyGenerator("SunTlsKeyMaterial");
            kg.init(spec);
            TlsKeyMaterialSpec keySpec = (TlsKeyMaterialSpec)kg.generateKey();
            this.clntWriteKey = keySpec.getClientCipherKey();
            this.svrWriteKey = keySpec.getServerCipherKey();
            this.clntWriteIV = keySpec.getClientIv();
            this.svrWriteIV = keySpec.getServerIv();
            this.clntMacSecret = keySpec.getClientMacKey();
            this.svrMacSecret = keySpec.getServerMacKey();
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(e);
        }
        if (debug != null && Debug.isOn("keygen")) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                HexDumpEncoder dump = new HexDumpEncoder();
                System.out.println("CONNECTION KEYGEN:");
                System.out.println("Client Nonce:");
                Handshaker.printHex(dump, this.clnt_random.random_bytes);
                System.out.println("Server Nonce:");
                Handshaker.printHex(dump, this.svr_random.random_bytes);
                System.out.println("Master Secret:");
                Handshaker.printHex(dump, masterKey.getEncoded());
                System.out.println("Client MAC write Secret:");
                Handshaker.printHex(dump, this.clntMacSecret.getEncoded());
                System.out.println("Server MAC write Secret:");
                Handshaker.printHex(dump, this.svrMacSecret.getEncoded());
                if (this.clntWriteKey != null) {
                    System.out.println("Client write key:");
                    Handshaker.printHex(dump, this.clntWriteKey.getEncoded());
                    System.out.println("Server write key:");
                    Handshaker.printHex(dump, this.svrWriteKey.getEncoded());
                } else {
                    System.out.println("... no encryption keys used");
                }
                if (this.clntWriteIV != null) {
                    System.out.println("Client write IV:");
                    Handshaker.printHex(dump, this.clntWriteIV.getIV());
                    System.out.println("Server write IV:");
                    Handshaker.printHex(dump, this.svrWriteIV.getIV());
                } else {
                    System.out.println("... no IV used for this cipher");
                }
                System.out.flush();
            }
        }
    }

    private static void printHex(HexDumpEncoder dump, byte[] bytes) {
        if (bytes == null) {
            System.out.println("(key bytes not available)");
        } else {
            try {
                dump.encodeBuffer(bytes, (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void throwSSLException(String msg, Throwable cause) throws SSLException {
        SSLException e = new SSLException(msg);
        e.initCause(cause);
        throw e;
    }

    private <T> void delegateTask(PrivilegedExceptionAction<T> pea) {
        this.delegatedTask = new DelegatedTask<T>(pea);
        this.taskDelegated = false;
        this.thrown = null;
    }

    DelegatedTask getTask() {
        if (!this.taskDelegated) {
            this.taskDelegated = true;
            return this.delegatedTask;
        }
        return null;
    }

    boolean taskOutstanding() {
        return this.delegatedTask != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkThrown() throws SSLException {
        Object object = this.thrownLock;
        synchronized (object) {
            if (this.thrown != null) {
                String msg = this.thrown.getMessage();
                if (msg == null) {
                    msg = "Delegated task threw Exception/Error";
                }
                Exception e = this.thrown;
                this.thrown = null;
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)new RuntimeException(msg).initCause(e);
                }
                if (e instanceof SSLHandshakeException) {
                    throw (SSLHandshakeException)new SSLHandshakeException(msg).initCause(e);
                }
                if (e instanceof SSLKeyException) {
                    throw (SSLKeyException)new SSLKeyException(msg).initCause(e);
                }
                if (e instanceof SSLPeerUnverifiedException) {
                    throw (SSLPeerUnverifiedException)new SSLPeerUnverifiedException(msg).initCause(e);
                }
                if (e instanceof SSLProtocolException) {
                    throw (SSLProtocolException)new SSLProtocolException(msg).initCause(e);
                }
                throw (SSLException)new SSLException(msg).initCause(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DelegatedTask<E>
    implements Runnable {
        private PrivilegedExceptionAction<E> pea;

        DelegatedTask(PrivilegedExceptionAction<E> pea) {
            this.pea = pea;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SSLEngineImpl sSLEngineImpl = Handshaker.this.engine;
            synchronized (sSLEngineImpl) {
                try {
                    AccessController.doPrivileged(this.pea, Handshaker.this.engine.getAcc());
                }
                catch (PrivilegedActionException pae) {
                    Handshaker.this.thrown = pae.getException();
                }
                catch (RuntimeException rte) {
                    Handshaker.this.thrown = rte;
                }
                Handshaker.this.delegatedTask = null;
                Handshaker.this.taskDelegated = false;
            }
        }
    }
}

