/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSPRequest;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.URIName;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OCSP {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final int CONNECT_TIMEOUT = 15000;

    private OCSP() {
    }

    public static RevocationStatus check(X509Certificate cert, X509Certificate issuerCert) throws IOException, CertPathValidatorException {
        CertId certId = null;
        URI responderURI = null;
        try {
            X509CertImpl certImpl = X509CertImpl.toImpl(cert);
            responderURI = OCSP.getResponderURI(certImpl);
            if (responderURI == null) {
                throw new CertPathValidatorException("No OCSP Responder URI in certificate");
            }
            certId = new CertId(issuerCert, certImpl.getSerialNumberObject());
        }
        catch (CertificateException ce) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", ce);
        }
        catch (IOException ioe) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", ioe);
        }
        OCSPResponse ocspResponse = OCSP.check(Collections.singletonList(certId), responderURI, issuerCert, null);
        return ocspResponse.getSingleResponse(certId);
    }

    public static RevocationStatus check(X509Certificate cert, X509Certificate issuerCert, URI responderURI, X509Certificate responderCert, Date date) throws IOException, CertPathValidatorException {
        CertId certId = null;
        try {
            X509CertImpl certImpl = X509CertImpl.toImpl(cert);
            certId = new CertId(issuerCert, certImpl.getSerialNumberObject());
        }
        catch (CertificateException ce) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", ce);
        }
        catch (IOException ioe) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", ioe);
        }
        OCSPResponse ocspResponse = OCSP.check(Collections.singletonList(certId), responderURI, responderCert, date);
        return ocspResponse.getSingleResponse(certId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OCSPResponse check(List<CertId> certIds, URI responderURI, X509Certificate responderCert, Date date) throws IOException, CertPathValidatorException {
        byte[] bytes = null;
        try {
            OCSPRequest request = new OCSPRequest(certIds);
            bytes = request.encodeBytes();
        }
        catch (IOException ioe) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", ioe);
        }
        InputStream in = null;
        OutputStream out = null;
        byte[] response = null;
        try {
            int count;
            URL url = responderURI.toURL();
            if (debug != null) {
                debug.println("connecting to OCSP service at: " + url);
            }
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(15000);
            con.setReadTimeout(15000);
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-type", "application/ocsp-request");
            con.setRequestProperty("Content-length", String.valueOf(bytes.length));
            out = con.getOutputStream();
            out.write(bytes);
            out.flush();
            if (debug != null && con.getResponseCode() != 200) {
                debug.println("Received HTTP error: " + con.getResponseCode() + " - " + con.getResponseMessage());
            }
            in = con.getInputStream();
            int contentLength = con.getContentLength();
            if (contentLength == -1) {
                contentLength = Integer.MAX_VALUE;
            }
            response = new byte[contentLength > 2048 ? 2048 : contentLength];
            int total = 0;
            while (total < contentLength && (count = in.read(response, total, response.length - total)) >= 0) {
                if ((total += count) < response.length || total >= contentLength) continue;
                response = Arrays.copyOf(response, total * 2);
            }
            response = Arrays.copyOf(response, total);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        OCSPResponse ocspResponse = null;
        try {
            ocspResponse = new OCSPResponse(response, date, responderCert);
        }
        catch (IOException ioe) {
            throw new CertPathValidatorException(ioe);
        }
        if (ocspResponse.getResponseStatus() != OCSPResponse.ResponseStatus.SUCCESSFUL) {
            throw new CertPathValidatorException("OCSP response error: " + (Object)((Object)ocspResponse.getResponseStatus()));
        }
        for (CertId certId : certIds) {
            OCSPResponse.SingleResponse sr = ocspResponse.getSingleResponse(certId);
            if (sr == null) {
                if (debug != null) {
                    debug.println("No response found for CertId: " + certId);
                }
                throw new CertPathValidatorException("OCSP response does not include a response for a certificate supplied in the OCSP request");
            }
            if (debug == null) continue;
            debug.println("Status of certificate (with serial number " + certId.getSerialNumber() + ") is: " + (Object)((Object)sr.getCertStatus()));
        }
        return ocspResponse;
    }

    public static URI getResponderURI(X509Certificate cert) {
        try {
            return OCSP.getResponderURI(X509CertImpl.toImpl(cert));
        }
        catch (CertificateException ce) {
            return null;
        }
    }

    static URI getResponderURI(X509CertImpl certImpl) {
        AuthorityInfoAccessExtension aia = certImpl.getAuthorityInfoAccessExtension();
        if (aia == null) {
            return null;
        }
        List<AccessDescription> descriptions = aia.getAccessDescriptions();
        for (AccessDescription description : descriptions) {
            GeneralName generalName;
            if (!description.getAccessMethod().equals(AccessDescription.Ad_OCSP_Id) || (generalName = description.getAccessLocation()).getType() != 6) continue;
            URIName uri = (URIName)generalName.getName();
            return uri.getURI();
        }
        return null;
    }

    public static interface RevocationStatus {
        public CertStatus getCertStatus();

        public Date getRevocationTime();

        public Reason getRevocationReason();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Reason {
            UNSPECIFIED,
            KEY_COMPROMISE,
            CA_COMPROMISE,
            AFFILIATION_CHANGED,
            SUPERSEDED,
            CESSATION_OF_OPERATION,
            CERTIFICATE_HOLD,
            UNUSED,
            REMOVE_FROM_CRL,
            PRIVILEGE_WITHDRAWN,
            AA_COMPROMISE;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum CertStatus {
            GOOD,
            REVOKED,
            UNKNOWN;

        }
    }
}

